// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for Azure Cognitive Search when used as an Azure OpenAI chat extension. The supported authentication types
 * are APIKey, SystemAssignedManagedIdentity and UserAssignedManagedIdentity.
 */
@Fluent
public final class AzureSearchChatExtensionParameters implements JsonSerializable<AzureSearchChatExtensionParameters> {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    private OnYourDataAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    private Integer strictness;

    /*
     * Give the model instructions about how it should behave and any context it should reference when generating a
     * response. You can describe the assistant's personality and tell it how to format responses. There's a 100 token
     * limit for it, and it counts against the overall token limit.
     */
    @Generated
    private String roleInformation;

    /*
     * The absolute endpoint path for the Azure Cognitive Search resource to use.
     */
    @Generated
    private final String endpoint;

    /*
     * The name of the index to use as available in the referenced Azure Cognitive Search resource.
     */
    @Generated
    private final String indexName;

    /*
     * Customized field mapping behavior to use when interacting with the search index.
     */
    @Generated
    private AzureSearchIndexFieldMappingOptions fieldsMapping;

    /*
     * The query type to use with Azure Cognitive Search.
     */
    @Generated
    private AzureSearchQueryType queryType;

    /*
     * The additional semantic configuration for the query.
     */
    @Generated
    private String semanticConfiguration;

    /*
     * Search filter.
     */
    @Generated
    private String filter;

    /*
     * The embedding dependency for vector search.
     */
    @Generated
    private OnYourDataVectorizationSource embeddingDependency;

    /**
     * Creates an instance of AzureSearchChatExtensionParameters class.
     *
     * @param endpoint the endpoint value to set.
     * @param indexName the indexName value to set.
     */
    @Generated
    public AzureSearchChatExtensionParameters(String endpoint, String indexName) {
        this.endpoint = endpoint;
        this.indexName = indexName;
    }

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @return the roleInformation value.
     */
    @Generated
    public String getRoleInformation() {
        return this.roleInformation;
    }

    /**
     * Set the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @param roleInformation the roleInformation value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    /**
     * Get the endpoint property: The absolute endpoint path for the Azure Cognitive Search resource to use.
     *
     * @return the endpoint value.
     */
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Get the indexName property: The name of the index to use as available in the referenced Azure Cognitive Search
     * resource.
     *
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Get the fieldsMapping property: Customized field mapping behavior to use when interacting with the search index.
     *
     * @return the fieldsMapping value.
     */
    @Generated
    public AzureSearchIndexFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    /**
     * Set the fieldsMapping property: Customized field mapping behavior to use when interacting with the search index.
     *
     * @param fieldsMapping the fieldsMapping value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setFieldsMapping(AzureSearchIndexFieldMappingOptions fieldsMapping) {
        this.fieldsMapping = fieldsMapping;
        return this;
    }

    /**
     * Get the queryType property: The query type to use with Azure Cognitive Search.
     *
     * @return the queryType value.
     */
    @Generated
    public AzureSearchQueryType getQueryType() {
        return this.queryType;
    }

    /**
     * Set the queryType property: The query type to use with Azure Cognitive Search.
     *
     * @param queryType the queryType value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setQueryType(AzureSearchQueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    /**
     * Get the semanticConfiguration property: The additional semantic configuration for the query.
     *
     * @return the semanticConfiguration value.
     */
    @Generated
    public String getSemanticConfiguration() {
        return this.semanticConfiguration;
    }

    /**
     * Set the semanticConfiguration property: The additional semantic configuration for the query.
     *
     * @param semanticConfiguration the semanticConfiguration value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setSemanticConfiguration(String semanticConfiguration) {
        this.semanticConfiguration = semanticConfiguration;
        return this;
    }

    /**
     * Get the filter property: Search filter.
     *
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: Search filter.
     *
     * @param filter the filter value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the embeddingDependency property: The embedding dependency for vector search.
     *
     * @return the embeddingDependency value.
     */
    @Generated
    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    /**
     * Set the embeddingDependency property: The embedding dependency for vector search.
     *
     * @param embeddingDependency the embeddingDependency value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters
        setEmbeddingDependency(OnYourDataVectorizationSource embeddingDependency) {
        this.embeddingDependency = embeddingDependency;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeJsonField("authentication", this.authentication);
        jsonWriter.writeNumberField("top_n_documents", this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", this.strictness);
        jsonWriter.writeStringField("role_information", this.roleInformation);
        jsonWriter.writeNumberField("max_search_queries", this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("fields_mapping", this.fieldsMapping);
        jsonWriter.writeStringField("query_type", this.queryType == null ? null : this.queryType.toString());
        jsonWriter.writeStringField("semantic_configuration", this.semanticConfiguration);
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeJsonField("embedding_dependency", this.embeddingDependency);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureSearchChatExtensionParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureSearchChatExtensionParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureSearchChatExtensionParameters.
     */
    @Generated
    public static AzureSearchChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String endpoint = null;
            String indexName = null;
            OnYourDataAuthenticationOptions authentication = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            String roleInformation = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List<OnYourDataContextProperty> includeContexts = null;
            AzureSearchIndexFieldMappingOptions fieldsMapping = null;
            AzureSearchQueryType queryType = null;
            String semanticConfiguration = null;
            String filter = null;
            OnYourDataVectorizationSource embeddingDependency = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                } else if ("index_name".equals(fieldName)) {
                    indexName = reader.getString();
                } else if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataAuthenticationOptions.fromJson(reader);
                } else if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = reader.getNullable(JsonReader::getInt);
                } else if ("in_scope".equals(fieldName)) {
                    inScope = reader.getNullable(JsonReader::getBoolean);
                } else if ("strictness".equals(fieldName)) {
                    strictness = reader.getNullable(JsonReader::getInt);
                } else if ("role_information".equals(fieldName)) {
                    roleInformation = reader.getString();
                } else if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = reader.getNullable(JsonReader::getInt);
                } else if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = reader.getNullable(JsonReader::getBoolean);
                } else if ("include_contexts".equals(fieldName)) {
                    includeContexts
                        = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                } else if ("fields_mapping".equals(fieldName)) {
                    fieldsMapping = AzureSearchIndexFieldMappingOptions.fromJson(reader);
                } else if ("query_type".equals(fieldName)) {
                    queryType = AzureSearchQueryType.fromString(reader.getString());
                } else if ("semantic_configuration".equals(fieldName)) {
                    semanticConfiguration = reader.getString();
                } else if ("filter".equals(fieldName)) {
                    filter = reader.getString();
                } else if ("embedding_dependency".equals(fieldName)) {
                    embeddingDependency = OnYourDataVectorizationSource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            AzureSearchChatExtensionParameters deserializedAzureSearchChatExtensionParameters
                = new AzureSearchChatExtensionParameters(endpoint, indexName);
            deserializedAzureSearchChatExtensionParameters.authentication = authentication;
            deserializedAzureSearchChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedAzureSearchChatExtensionParameters.inScope = inScope;
            deserializedAzureSearchChatExtensionParameters.strictness = strictness;
            deserializedAzureSearchChatExtensionParameters.roleInformation = roleInformation;
            deserializedAzureSearchChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedAzureSearchChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedAzureSearchChatExtensionParameters.includeContexts = includeContexts;
            deserializedAzureSearchChatExtensionParameters.fieldsMapping = fieldsMapping;
            deserializedAzureSearchChatExtensionParameters.queryType = queryType;
            deserializedAzureSearchChatExtensionParameters.semanticConfiguration = semanticConfiguration;
            deserializedAzureSearchChatExtensionParameters.filter = filter;
            deserializedAzureSearchChatExtensionParameters.embeddingDependency = embeddingDependency;
            return deserializedAzureSearchChatExtensionParameters;
        });
    }

    /*
     * The max number of rewritten queries should be send to search provider for one user message. If not specified,
     * the system will decide the number of queries to send.
     */
    @Generated
    private Integer maxSearchQueries;

    /*
     * If specified as true, the system will allow partial search results to be used and the request fails if all the
     * queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     */
    @Generated
    private Boolean allowPartialResult;

    /*
     * The included properties of the output context. If not specified, the default value is `citations` and `intent`.
     */
    @Generated
    private List<OnYourDataContextProperty> includeContexts;

    /**
     * Get the maxSearchQueries property: The max number of rewritten queries should be send to search provider for one
     * user message. If not specified,
     * the system will decide the number of queries to send.
     *
     * @return the maxSearchQueries value.
     */
    @Generated
    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    /**
     * Set the maxSearchQueries property: The max number of rewritten queries should be send to search provider for one
     * user message. If not specified,
     * the system will decide the number of queries to send.
     *
     * @param maxSearchQueries the maxSearchQueries value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    /**
     * Get the allowPartialResult property: If specified as true, the system will allow partial search results to be
     * used and the request fails if all the queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     *
     * @return the allowPartialResult value.
     */
    @Generated
    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    /**
     * Set the allowPartialResult property: If specified as true, the system will allow partial search results to be
     * used and the request fails if all the queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     *
     * @param allowPartialResult the allowPartialResult value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    /**
     * Get the includeContexts property: The included properties of the output context. If not specified, the default
     * value is `citations` and `intent`.
     *
     * @return the includeContexts value.
     */
    @Generated
    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    /**
     * Set the includeContexts property: The included properties of the output context. If not specified, the default
     * value is `citations` and `intent`.
     *
     * @param includeContexts the includeContexts value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }
}
