// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai;

import com.azure.ai.openai.implementation.MultipartFormDataHelper;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.models.FileListResponse;
import com.azure.ai.openai.implementation.models.OpenAIPageableListOfBatch;
import com.azure.ai.openai.implementation.models.UploadFileRequest;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranscriptionTimestampGranularity;
import com.azure.ai.openai.models.AudioTranslation;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.ai.openai.models.Batch;
import com.azure.ai.openai.models.BatchCreateRequest;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.FileDeletionStatus;
import com.azure.ai.openai.models.FileDetails;
import com.azure.ai.openai.models.FilePurpose;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageGenerations;
import com.azure.ai.openai.models.OpenAIFile;
import com.azure.ai.openai.models.SpeechGenerationOptions;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.util.List;
import java.util.Objects;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.implementation.accesshelpers.PageableListAccessHelper;
import com.azure.ai.openai.models.PageableList;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import reactor.core.publisher.Flux;
import java.nio.ByteBuffer;
import static com.azure.ai.openai.implementation.AudioTranscriptionValidator.validateAudioResponseFormatForTranscription;
import static com.azure.ai.openai.implementation.AudioTranscriptionValidator.validateAudioResponseFormatForTranscriptionText;
import static com.azure.ai.openai.implementation.AudioTranslationValidator.validateAudioResponseFormatForTranslation;
import static com.azure.ai.openai.implementation.AudioTranslationValidator.validateAudioResponseFormatForTranslationText;
import static com.azure.ai.openai.implementation.EmbeddingsUtils.addEncodingFormat;
import static com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl.addModelIdJson;
import static com.azure.ai.openai.implementation.OpenAIUtils.addAzureVersionToRequestOptions;

/**
 * Initializes a new instance of the synchronous OpenAIClient type.
 */
@ServiceClient(builder = OpenAIClientBuilder.class)
public final class OpenAIClient {

    private static final ClientLogger LOGGER = new ClientLogger(OpenAIClient.class);

    @Generated
    private final OpenAIClientImpl serviceClient;

    private final NonAzureOpenAIClientImpl openAIServiceClient;

    /**
     * Initializes an instance of OpenAIClient class.
     *
     * @param serviceClient the service client implementation.
     */
    OpenAIClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        openAIServiceClient = null;
    }

    /**
     * Initializes an instance of OpenAIClient class for NonAzure Implementation.
     *
     * @param serviceClient the service client implementation.
     */
    OpenAIClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        openAIServiceClient = serviceClient;
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     user: String (Optional)
     *     model: String (Optional)
     *     input (Required): [
     *         String (Required)
     *     ]
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     data (Required): [
     *          (Required){
     *             embedding (Required): [
     *                 double (Required)
     *             ]
     *             index: int (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request. Embeddings measure the
     * relatedness of text strings and are commonly used for search, clustering, recommendations, and other similar
     * scenarios.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return representation of the response data from an embeddings request. Embeddings measure the relatedness of
     * text strings and are commonly used for search, clustering, recommendations, and other similar scenarios along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String deploymentOrModelName, BinaryData embeddingsOptions,
        RequestOptions requestOptions) {
        final BinaryData embeddingsOptionsUpdated = addEncodingFormat(embeddingsOptions);
        return openAIServiceClient != null
            ? openAIServiceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptionsUpdated,
                requestOptions)
            : serviceClient.getEmbeddingsWithResponse(deploymentOrModelName, embeddingsOptionsUpdated, requestOptions);
    }

    /**
     * Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     prompt (Required): [
     *         String (Required)
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     logprobs: Integer (Optional)
     *     echo: Boolean (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     best_of: Integer (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             text: String (Required)
     *             index: int (Required)
     *             logprobs (Required): {
     *                 tokens (Required): [
     *                     String (Required)
     *                 ]
     *                 token_logprobs (Required): [
     *                     double (Required)
     *                 ]
     *                 top_logprobs (Required): [
     *                      (Required){
     *                         String: double (Required)
     *                     }
     *                 ]
     *                 text_offset (Required): [
     *                     int (Required)
     *                 ]
     *             }
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String deploymentOrModelName, BinaryData completionsOptions,
        RequestOptions requestOptions) {
        return openAIServiceClient != null
            ? openAIServiceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions)
            : serviceClient.getCompletionsWithResponse(deploymentOrModelName, completionsOptions, requestOptions);
    }

    /**
     * Gets chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messages (Required): [
     *          (Required){
     *             role: String(system/assistant/user) (Required)
     *             content: String (Optional)
     *         }
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             message (Optional): {
     *                 role: String(system/assistant/user) (Required)
     *                 content: String (Optional)
     *             }
     *             index: int (Required)
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *             delta (Optional): {
     *                 role: String(system/assistant/user) (Optional)
     *                 content: String (Optional)
     *             }
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     * wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String deploymentOrModelName,
        BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return openAIServiceClient != null
            ? openAIServiceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions,
                requestOptions)
            : serviceClient.getChatCompletionsWithResponse(deploymentOrModelName, chatCompletionsOptions,
                requestOptions);
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     user: String (Optional)
     *     model: String (Optional)
     *     input (Required): [
     *         String (Required)
     *     ]
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     data (Required): [
     *          (Required){
     *             embedding (Required): [
     *                 double (Required)
     *             ]
     *             index: int (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request. Embeddings measure the
     * relatedness of text strings and are commonly used for search, clustering, recommendations, and other similar
     * scenarios.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return representation of the response data from an embeddings request. Embeddings measure the relatedness of
     * text strings and are commonly used for search, clustering, recommendations, and other similar scenarios along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Embeddings> getEmbeddingsWithResponse(String deploymentOrModelName,
        EmbeddingsOptions embeddingsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getEmbeddingsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(embeddingsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(Embeddings.class));
    }

    /**
     * Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     prompt (Required): [
     *         String (Required)
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     logprobs: Integer (Optional)
     *     echo: Boolean (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     best_of: Integer (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             text: String (Required)
     *             index: int (Required)
     *             logprobs (Required): {
     *                 tokens (Required): [
     *                     String (Required)
     *                 ]
     *                 token_logprobs (Required): [
     *                     double (Required)
     *                 ]
     *                 top_logprobs (Required): [
     *                      (Required){
     *                         String: double (Required)
     *                     }
     *                 ]
     *                 text_offset (Required): [
     *                     int (Required)
     *                 ]
     *             }
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Completions> getCompletionsWithResponse(String deploymentOrModelName,
        CompletionsOptions completionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(completionsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(Completions.class));
    }

    /**
     * Gets chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data.
     *
     * <p>
     * <strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     messages (Required): [
     *          (Required){
     *             role: String(system/assistant/user) (Required)
     *             content: String (Optional)
     *         }
     *     ]
     *     max_tokens: Integer (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     logit_bias (Optional): {
     *         String: int (Optional)
     *     }
     *     user: String (Optional)
     *     n: Integer (Optional)
     *     stop (Optional): [
     *         String (Optional)
     *     ]
     *     presence_penalty: Double (Optional)
     *     frequency_penalty: Double (Optional)
     *     stream: Boolean (Optional)
     *     model: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     created: int (Required)
     *     choices (Required): [
     *          (Required){
     *             message (Optional): {
     *                 role: String(system/assistant/user) (Required)
     *                 content: String (Optional)
     *             }
     *             index: int (Required)
     *             finish_reason: String(stopped/tokenLimitReached/contentFiltered) (Required)
     *             delta (Optional): {
     *                 role: String(system/assistant/user) (Optional)
     *                 content: String (Optional)
     *             }
     *         }
     *     ]
     *     usage (Required): {
     *         completion_tokens: int (Required)
     *         prompt_tokens: int (Required)
     *         total_tokens: int (Required)
     *     }
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     * wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return chat completions for the provided chat messages. Completions support a wide variety of tasks and generate
     * text that continues from or "completes" provided prompt data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ChatCompletions> getChatCompletionsWithResponse(String deploymentOrModelName,
        ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getChatCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(chatCompletionsOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(ChatCompletions.class));
    }

    /**
     * Return the embeddings for a given prompt.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param embeddingsOptions The configuration information for an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return representation of the response data from an embeddings request.
     * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
     * recommendations, and other similar scenarios.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Embeddings getEmbeddings(String deploymentOrModelName, EmbeddingsOptions embeddingsOptions) {
        // Generated convenience method for getEmbeddingsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getEmbeddingsWithResponse(deploymentOrModelName, BinaryData.fromObject(embeddingsOptions),
            requestOptions).getValue().toObject(Embeddings.class);
    }

    /**
     * Gets completions for the provided input prompts.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return completions for the provided input prompts.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, CompletionsOptions completionsOptions) {
        // Generated convenience method for getCompletionsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject(completionsOptions),
            requestOptions).getValue().toObject(Completions.class);
    }

    /**
     * Gets completions for the provided input prompt. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param prompt The prompt to generate completion text from.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return completions for the provided input prompts. Completions support a wide variety of tasks and generate text
     * that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Completions getCompletions(String deploymentOrModelName, String prompt) {
        return getCompletions(deploymentOrModelName, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    /**
     * Gets completions as a stream for the provided input prompts. Completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param completionsOptions The configuration information for a completions request. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an {@link IterableStream} of completions for the provided input prompts. Completions support a wide
     * variety of tasks and generate text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(String deploymentOrModelName,
        CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux<ByteBuffer> responseStream = getCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(completionsOptions), requestOptions).getValue().toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream
            = new OpenAIServerSentEvents<>(responseStream, Completions.class);
        return new IterableStream<>(completionsStream.getEvents());
    }

    /**
     * Gets chat completions for the provided chat messages.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return chat completions for the provided chat messages.
     * Completions support a wide variety of tasks and generate text that continues from or "completes"
     * provided prompt data.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ChatCompletions getChatCompletions(String deploymentOrModelName,
        ChatCompletionsOptions chatCompletionsOptions) {
        // Generated convenience method for getChatCompletionsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getChatCompletionsWithResponse(deploymentOrModelName, BinaryData.fromObject(chatCompletionsOptions),
            requestOptions).getValue().toObject(ChatCompletions.class);
    }

    /**
     * Gets chat completions for the provided chat messages in streaming mode. Chat completions support a wide variety
     * of tasks and generate text that continues from or "completes" provided prompt data.
     * <p>
     * <strong>Code Samples</strong>
     * </p>
     * <!-- @formatter:off -->
     * <!-- src_embed com.azure.ai.openai.OpenAIClient.getChatCompletionsStream#String-ChatCompletionsOptions -->
     * <pre>
     * openAIClient.getChatCompletionsStream&#40;deploymentOrModelId, new ChatCompletionsOptions&#40;chatMessages&#41;&#41;
     *         .forEach&#40;chatCompletions -&gt; &#123;
     *             if &#40;CoreUtils.isNullOrEmpty&#40;chatCompletions.getChoices&#40;&#41;&#41;&#41; &#123;
     *                 return;
     *             &#125;
     *             ChatResponseMessage delta = chatCompletions.getChoices&#40;&#41;.get&#40;0&#41;.getDelta&#40;&#41;;
     *             if &#40;delta.getRole&#40;&#41; != null&#41; &#123;
     *                 System.out.println&#40;&quot;Role = &quot; + delta.getRole&#40;&#41;&#41;;
     *             &#125;
     *             if &#40;delta.getContent&#40;&#41; != null&#41; &#123;
     *                 String content = delta.getContent&#40;&#41;;
     *                 System.out.print&#40;content&#41;;
     *             &#125;
     *         &#125;&#41;;
     * </pre>
     * <!-- end com.azure.ai.openai.OpenAIClient.getChatCompletionsStream#String-ChatCompletionsOptions -->
     * <!-- @formatter:on -->
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     * wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return chat completions stream for the provided chat messages. Completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(String deploymentOrModelName,
        ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux<ByteBuffer> responseStream = getChatCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(chatCompletionsOptions), requestOptions).getValue().toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream
            = new OpenAIServerSentEvents<>(responseStream, ChatCompletions.class);
        return new IterableStream<>(chatCompletionsStream.getEvents());
    }

    /**
     * Gets chat completions for the provided chat messages in streaming mode. Chat completions support a wide variety
     * of tasks and generate text that continues from or "completes" provided prompt data.
     * <p>
     * <strong>Code Samples</strong>
     * </p>
     * <!-- @formatter:off -->
     * <!-- src_embed com.azure.ai.openai.OpenAIClient.getChatCompletionsStream#String-ChatCompletionsOptionsMaxOverload
     * -->
     *
     * <pre>
     * openAIClient
     *     .getChatCompletionsStreamWithResponse&#40;deploymentOrModelId, new ChatCompletionsOptions&#40;chatMessages&#41;,
     *         new RequestOptions&#40;&#41;.setHeader&#40;&quot;my-header&quot;, &quot;my-header-value&quot;&#41;&#41;
     *     .getValue&#40;&#41;
     *     .forEach&#40;chatCompletions -&gt; &#123;
     *         if &#40;CoreUtils.isNullOrEmpty&#40;chatCompletions.getChoices&#40;&#41;&#41;&#41; &#123;
     *             return;
     *         &#125;
     *         ChatResponseMessage delta = chatCompletions.getChoices&#40;&#41;.get&#40;0&#41;.getDelta&#40;&#41;;
     *         if &#40;delta.getRole&#40;&#41; != null&#41; &#123;
     *             System.out.println&#40;&quot;Role = &quot; + delta.getRole&#40;&#41;&#41;;
     *         &#125;
     *         if &#40;delta.getContent&#40;&#41; != null&#41; &#123;
     *             String content = delta.getContent&#40;&#41;;
     *             System.out.print&#40;content&#41;;
     *         &#125;
     *     &#125;&#41;;
     * </pre>
     *
     * <!-- end com.azure.ai.openai.OpenAIClient.getChatCompletionsStream#String-ChatCompletionsOptionsMaxOverload -->
     * <!-- @formatter:on -->
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param chatCompletionsOptions The configuration information for a chat completions request. Completions support a
     * wide variety of tasks and generate text that continues from or "completes" provided prompt data.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return chat completions stream for the provided chat messages. Completions support a wide variety of tasks and
     * generate text that continues from or "completes" provided prompt data.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public Response<IterableStream<ChatCompletions>> getChatCompletionsStreamWithResponse(String deploymentOrModelName,
        ChatCompletionsOptions chatCompletionsOptions, RequestOptions requestOptions) {
        chatCompletionsOptions.setStream(true);
        Response<BinaryData> response = getChatCompletionsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(chatCompletionsOptions), requestOptions);
        Flux<ByteBuffer> responseStream = response.getValue().toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream
            = new OpenAIServerSentEvents<>(responseStream, ChatCompletions.class);
        return new SimpleResponse<>(response, new IterableStream<>(chatCompletionsStream.getEvents()));
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranscription getAudioTranscription(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscriptionWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null)
            .getValue();
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} transcribed text and associated metadata from provided spoken audio data along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AudioTranscription> getAudioTranscriptionWithResponse(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        // checking allowed formats for a JSON response
        validateAudioResponseFormatForTranscription(audioTranscriptionOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes(audioTranscriptionOptions.getFile()), fileName);
        // String.valueOf would return "null" for a null value, which is not null
        String temperature = audioTranscriptionOptions.getTemperature() == null
            ? null
            : String.valueOf(audioTranscriptionOptions.getTemperature());
        MultipartFormDataHelper multipartRequest = new MultipartFormDataHelper(multipartRequestOptions)
            .serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename())
            .serializeTextField("response_format", audioTranscriptionOptions.getResponseFormat().toString())
            .serializeTextField("model", audioTranscriptionOptions.getModel())
            .serializeTextField("prompt", audioTranscriptionOptions.getPrompt())
            .serializeTextField("language", audioTranscriptionOptions.getLanguage())
            .serializeTextField("temperature", temperature);
        List<AudioTranscriptionTimestampGranularity> timestampGranularities
            = audioTranscriptionOptions.getTimestampGranularities();
        if (!CoreUtils.isNullOrEmpty(timestampGranularities)) {
            for (AudioTranscriptionTimestampGranularity timestampGranularity : timestampGranularities) {
                // somehow we don't need to send the index in OAI
                multipartRequest.serializeTextField("timestamp_granularities[]", timestampGranularity.toString());
            }
        }
        BinaryData uploadFileRequest = multipartRequest.end().getRequestBody();
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName,
                uploadFileRequest, multipartRequestOptions)
            : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest,
                multipartRequestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(AudioTranscription.class));
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranscriptionText(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscriptionTextWithResponse(deploymentOrModelName, fileName, audioTranscriptionOptions, null)
            .getValue();
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio file data. Audio will be transcribed in
     * the written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranscriptionOptions}.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getAudioTranscriptionTextWithResponse(String deploymentOrModelName, String fileName,
        AudioTranscriptionOptions audioTranscriptionOptions, RequestOptions requestOptions) {
        // checking allowed formats for a plain text response
        validateAudioResponseFormatForTranscriptionText(audioTranscriptionOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranscriptionOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranscriptionOptions.getFilename())) {
            audioTranscriptionOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes(audioTranscriptionOptions.getFile()), fileName);
        // String.valueOf would return "null" for a null value, which is not null
        String temperature = audioTranscriptionOptions.getTemperature() == null
            ? null
            : String.valueOf(audioTranscriptionOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions)
            .serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename())
            .serializeTextField("response_format", audioTranscriptionOptions.getResponseFormat().toString())
            .serializeTextField("model", audioTranscriptionOptions.getModel())
            .serializeTextField("prompt", audioTranscriptionOptions.getPrompt())
            .serializeTextField("language", audioTranscriptionOptions.getLanguage())
            .serializeTextField("temperature", temperature)
            .end()
            .getRequestBody();
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName,
                uploadFileRequest, multipartRequestOptions)
            : this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest,
                multipartRequestOptions);
        return new SimpleResponse<>(response, response.getValue().toString());
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranscription} english language transcribed text and associated metadata from provided spoken
     * audio file data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AudioTranslation getAudioTranslation(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslationWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null)
            .getValue();
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return {@link AudioTranslation} english language transcribed text and associated metadata from provided spoken
     * audio file data along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AudioTranslation> getAudioTranslationWithResponse(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        // checking allowed formats for a JSON response
        validateAudioResponseFormatForTranslation(audioTranslationOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes(audioTranslationOptions.getFile()), fileName);
        // String.valueOf would return "null" for a null value, which is not null
        String temperature = audioTranslationOptions.getTemperature() == null
            ? null
            : String.valueOf(audioTranslationOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions)
            .serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename())
            .serializeTextField("response_format", audioTranslationOptions.getResponseFormat().toString())
            .serializeTextField("model", audioTranslationOptions.getModel())
            .serializeTextField("prompt", audioTranslationOptions.getPrompt())
            .serializeTextField("temperature", temperature)
            .end()
            .getRequestBody();
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName,
                uploadFileRequest, multipartRequestOptions)
            : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest,
                multipartRequestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(AudioTranslation.class));
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio file data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranslationText(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslationTextWithResponse(deploymentOrModelName, fileName, audioTranslationOptions, null)
            .getValue();
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio file data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param fileName The file name that is represented in the {@code file} field of {@link AudioTranslationOptions}.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio file data along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getAudioTranslationTextWithResponse(String deploymentOrModelName, String fileName,
        AudioTranslationOptions audioTranslationOptions, RequestOptions requestOptions) {
        // checking allowed formats for a plain text response
        validateAudioResponseFormatForTranslationText(audioTranslationOptions);
        // embedding the `model` in the request for non-Azure case
        if (this.openAIServiceClient != null) {
            audioTranslationOptions.setModel(deploymentOrModelName);
        }
        // setting the name as part of the request object will allow users for better visualization in the web dashboard
        if (CoreUtils.isNullOrEmpty(audioTranslationOptions.getFilename())) {
            audioTranslationOptions.setFilename(fileName);
        }
        RequestOptions multipartRequestOptions = requestOptions == null ? new RequestOptions() : requestOptions;
        FileDetails file = new FileDetails(BinaryData.fromBytes(audioTranslationOptions.getFile()), fileName);
        // String.valueOf would return "null" for a null value, which is not null
        String temperature = audioTranslationOptions.getTemperature() == null
            ? null
            : String.valueOf(audioTranslationOptions.getTemperature());
        BinaryData uploadFileRequest = new MultipartFormDataHelper(multipartRequestOptions)
            .serializeFileField("file", file.getContent(), file.getContentType(), file.getFilename())
            .serializeTextField("response_format", audioTranslationOptions.getResponseFormat().toString())
            .serializeTextField("model", audioTranslationOptions.getModel())
            .serializeTextField("prompt", audioTranslationOptions.getPrompt())
            .serializeTextField("temperature", temperature)
            .end()
            .getRequestBody();
        Response<BinaryData> response = openAIServiceClient != null
            ? this.openAIServiceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName,
                uploadFileRequest, multipartRequestOptions)
            : this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName, uploadFileRequest,
                multipartRequestOptions);
        return new SimpleResponse<>(response, response.getValue().toString());
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>{@code
     * {
     *     text: String (Required)
     *     task: String(transcribe/translate) (Optional)
     *     language: String (Optional)
     *     duration: Double (Optional)
     *     segments (Optional): [
     *          (Optional){
     *             id: int (Required)
     *             start: double (Required)
     *             end: double (Required)
     *             text: String (Required)
     *             temperature: double (Required)
     *             avg_logprob: double (Required)
     *             compression_ratio: double (Required)
     *             no_speech_prob: double (Required)
     *             tokens (Required): [
     *                 int (Required)
     *             ]
     *             seek: int (Required)
     *         }
     *     ]
     *     words (Optional): [
     *          (Optional){
     *             word: String (Required)
     *             start: double (Required)
     *             end: double (Required)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return transcribed text and associated metadata from provided spoken audio data along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranscriptionAsResponseObjectWithResponse(String deploymentOrModelName,
        BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranscriptionAsResponseObject' is 'multipart/form-data'
        return this.serviceClient.getAudioTranscriptionAsResponseObjectWithResponse(deploymentOrModelName,
            audioTranscriptionOptions, requestOptions);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>{@code
     * String
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return transcribed text and associated metadata from provided spoken audio data along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranscriptionAsPlainTextWithResponse(String deploymentOrModelName,
        BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranscriptionAsPlainText' is 'multipart/form-data'
        return this.serviceClient.getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName,
            audioTranscriptionOptions, requestOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>{@code
     * {
     *     text: String (Required)
     *     task: String(transcribe/translate) (Optional)
     *     language: String (Optional)
     *     duration: Double (Optional)
     *     segments (Optional): [
     *          (Optional){
     *             id: int (Required)
     *             start: double (Required)
     *             end: double (Required)
     *             text: String (Required)
     *             temperature: double (Required)
     *             avg_logprob: double (Required)
     *             compression_ratio: double (Required)
     *             no_speech_prob: double (Required)
     *             tokens (Required): [
     *                 int (Required)
     *             ]
     *             seek: int (Required)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return english language transcribed text and associated metadata from provided spoken audio data along with
     * {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranslationAsResponseObjectWithResponse(String deploymentOrModelName,
        BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranslationAsResponseObject' is 'multipart/form-data'
        return this.serviceClient.getAudioTranslationAsResponseObjectWithResponse(deploymentOrModelName,
            audioTranslationOptions, requestOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>{@code
     * String
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return english language transcribed text and associated metadata from provided spoken audio data along with
     * {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getAudioTranslationAsPlainTextWithResponse(String deploymentOrModelName,
        BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation
        // 'getAudioTranslationAsPlainText' is 'multipart/form-data'
        return this.serviceClient.getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName,
            audioTranslationOptions, requestOptions);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranscriptionAsPlainText(String deploymentOrModelName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranscriptionAsPlainTextWithResponse(deploymentOrModelName,
            BinaryData.fromObject(audioTranscriptionOptions), requestOptions).getValue().toObject(String.class);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getAudioTranslationAsPlainText(String deploymentOrModelName,
        AudioTranslationOptions audioTranslationOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return getAudioTranslationAsPlainTextWithResponse(deploymentOrModelName,
            BinaryData.fromObject(audioTranslationOptions), requestOptions).getValue().toObject(String.class);
    }

    /**
     * Creates an image given a prompt.
     * <p>
     * <strong>Request Body Schema</strong>
     * </p>
     *
     * <pre>{@code
     * {
     *     model: String (Optional)
     *     prompt: String (Required)
     *     n: Integer (Optional)
     *     size: String(256x256/512x512/1024x1024/1792x1024/1024x1792) (Optional)
     *     response_format: String(url/b64_json) (Optional)
     *     quality: String(standard/hd) (Optional)
     *     style: String(natural/vivid) (Optional)
     *     user: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     *
     * <pre>{@code
     * {
     *     created: long (Required)
     *     data (Required): [
     *          (Required){
     *             url: String (Optional)
     *             b64_json: String (Optional)
     *             revised_prompt: String (Optional)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the result of a successful image generation operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BinaryData> getImageGenerationsWithResponse(String deploymentOrModelName,
        BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        return openAIServiceClient != null
            ? this.openAIServiceClient.getImageGenerationsWithResponse(deploymentOrModelName, imageGenerationOptions,
                requestOptions)
            : this.serviceClient.getImageGenerationsWithResponse(deploymentOrModelName, imageGenerationOptions,
                requestOptions);
    }

    /**
     * Creates an image given a prompt.
     * <p>
     * <strong>Request Body Schema</strong>
     * </p>
     *
     * <pre>{@code
     * {
     *     model: String (Optional)
     *     prompt: String (Required)
     *     n: Integer (Optional)
     *     size: String(256x256/512x512/1024x1024/1792x1024/1024x1792) (Optional)
     *     response_format: String(url/b64_json) (Optional)
     *     quality: String(standard/hd) (Optional)
     *     style: String(natural/vivid) (Optional)
     *     user: String (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     *
     * <pre>{@code
     * {
     *     created: long (Required)
     *     data (Required): [
     *          (Required){
     *             url: String (Optional)
     *             b64_json: String (Optional)
     *             revised_prompt: String (Optional)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the result of a successful image generation operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ImageGenerations> getImageGenerationsWithResponse(String deploymentOrModelName,
        ImageGenerationOptions imageGenerationOptions, RequestOptions requestOptions) {
        Response<BinaryData> response = getImageGenerationsWithResponse(deploymentOrModelName,
            BinaryData.fromObject(imageGenerationOptions), requestOptions);
        return new SimpleResponse<>(response, response.getValue().toObject(ImageGenerations.class));
    }

    /**
     * Creates an image given a prompt.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param imageGenerationOptions Represents the request data used to generate images.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a successful image generation operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ImageGenerations getImageGenerations(String deploymentOrModelName,
        ImageGenerationOptions imageGenerationOptions) {
        // Generated convenience method for getImageGenerationsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getImageGenerationsWithResponse(deploymentOrModelName, BinaryData.fromObject(imageGenerationOptions),
            requestOptions).getValue().toObject(ImageGenerations.class);
    }

    /**
     * Gets transcribed text and associated metadata from provided spoken audio data. Audio will be transcribed in the
     * written language corresponding to the language it was spoken in.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranscriptionOptions The configuration information for an audio transcription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AudioTranscription getAudioTranscriptionAsResponseObject(String deploymentOrModelName,
        AudioTranscriptionOptions audioTranscriptionOptions) {
        return getAudioTranscription(deploymentOrModelName, "filename", audioTranscriptionOptions);
    }

    /**
     * Gets English language transcribed text and associated metadata from provided spoken audio data.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param audioTranslationOptions The configuration information for an audio translation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return english language transcribed text and associated metadata from provided spoken audio data.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AudioTranslation getAudioTranslationAsResponseObject(String deploymentOrModelName,
        AudioTranslationOptions audioTranslationOptions) {
        return getAudioTranslation(deploymentOrModelName, "filename", audioTranslationOptions);
    }

    /**
     * Generates text-to-speech audio from the input text.
     * <p>
     * <strong>Request Body Schema</strong>
     * </p>
     *
     * <pre>{@code
     * {
     *     input: String (Required)
     *     voice: String(alloy/echo/fable/onyx/nova/shimmer) (Required)
     *     response_format: String(mp3/opus/aac/flac) (Optional)
     *     speed: Double (Optional)
     * }
     * }</pre>
     *
     * <p>
     * <strong>Response Body Schema</strong>
     * </p>
     *
     * <pre>{@code
     * BinaryData
     * }</pre>
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param speechGenerationOptions A representation of the request options that control the behavior of a
     * text-to-speech operation.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> generateSpeechFromTextWithResponse(String deploymentOrModelName,
        BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        final BinaryData speechGenerationOptionsWithModelId
            = addModelIdJson(speechGenerationOptions, deploymentOrModelName);
        return openAIServiceClient != null
            ? this.openAIServiceClient.generateSpeechFromTextWithResponse(speechGenerationOptionsWithModelId,
                requestOptions)
            : this.serviceClient.generateSpeechFromTextWithResponse(deploymentOrModelName,
                speechGenerationOptionsWithModelId, requestOptions);
    }

    /**
     * Generates text-to-speech audio from the input text.
     *
     * @param deploymentOrModelName Specifies either the model deployment name (when using Azure OpenAI) or model name
     * (when using non-Azure OpenAI) to use for this request.
     * @param speechGenerationOptions A representation of the request options that control the behavior of a
     * text-to-speech operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BinaryData generateSpeechFromText(String deploymentOrModelName,
        SpeechGenerationOptions speechGenerationOptions) {
        // Generated convenience method for generateSpeechFromTextWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return generateSpeechFromTextWithResponse(deploymentOrModelName, BinaryData.fromObject(speechGenerationOptions),
            requestOptions).getValue();
    }

    /**
     * Gets a list of previously uploaded files.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>purpose</td><td>String</td><td>No</td><td>A value that, when provided, limits list results to files
     * matching the corresponding purpose. Allowed values: "fine-tune", "fine-tune-results", "assistants",
     * "assistants_output", "batch", "batch_output", "vision".</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     object: String (Required)
     *     data (Required): [
     *          (Required){
     *             object: String (Required)
     *             id: String (Required)
     *             bytes: int (Required)
     *             filename: String (Required)
     *             created_at: long (Required)
     *             purpose: String(fine-tune/fine-tune-results/assistants/assistants_output/batch/batch_output/vision) (Required)
     *             status: String(uploaded/pending/running/processed/error/deleting/deleted) (Optional)
     *             status_details: String (Optional)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of previously uploaded files along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<OpenAIFile>> listFilesWithResponse(RequestOptions requestOptions) {
        Response<BinaryData> listedFilesWithResponse;
        if (openAIServiceClient != null) {
            listedFilesWithResponse = this.openAIServiceClient.listFilesWithResponse(requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            listedFilesWithResponse = this.serviceClient.listFilesWithResponse(requestOptions);
        }
        return new SimpleResponse<>(listedFilesWithResponse,
            listedFilesWithResponse.getValue().toObject(FileListResponse.class).getData());
    }

    /**
     * Uploads a file for use by other operations.
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     object: String (Required)
     *     id: String (Required)
     *     bytes: int (Required)
     *     filename: String (Required)
     *     created_at: long (Required)
     *     purpose: String(fine-tune/fine-tune-results/assistants/assistants_output/batch/batch_output/vision) (Required)
     *     status: String(uploaded/pending/running/processed/error/deleting/deleted) (Optional)
     *     status_details: String (Optional)
     * }
     * }</pre>
     *
     * @param uploadFileRequest The uploadFileRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return represents an assistant that can call the model and use tools along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<OpenAIFile> uploadFileWithResponse(BinaryData uploadFileRequest, RequestOptions requestOptions) {
        // Protocol API requires serialization of parts with content-disposition and data, as operation 'uploadFile' is
        // 'multipart/form-data'
        Response<BinaryData> uploadedFileWithResponse;
        if (openAIServiceClient != null) {
            uploadedFileWithResponse
                = this.openAIServiceClient.uploadFileWithResponse(uploadFileRequest, requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            try {
                uploadedFileWithResponse = this.serviceClient.uploadFileWithResponse(uploadFileRequest, requestOptions);
            } catch (HttpResponseException ex) {
                final HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 201) {
                    return new ResponseBase<Void, OpenAIFile>(httpResponse.getRequest(), httpResponse.getStatusCode(),
                        httpResponse.getHeaders(), BinaryData.fromObject(ex.getValue()).toObject(OpenAIFile.class),
                        null);
                }
                throw LOGGER.logExceptionAsError(ex);
            }
        }
        return new SimpleResponse<>(uploadedFileWithResponse,
            uploadedFileWithResponse.getValue().toObject(OpenAIFile.class));
    }

    /**
     * Delete a previously uploaded file.
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     deleted: boolean (Required)
     *     object: String (Required)
     * }
     * }</pre>
     *
     * @param fileId The ID of the file to delete.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a status response from a file deletion operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FileDeletionStatus> deleteFileWithResponse(String fileId, RequestOptions requestOptions) {
        Response<BinaryData> deletedFileWithResponse;
        if (openAIServiceClient != null) {
            deletedFileWithResponse = this.openAIServiceClient.deleteFileWithResponse(fileId, requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            try {
                deletedFileWithResponse = this.serviceClient.deleteFileWithResponse(fileId, requestOptions);
            } catch (HttpResponseException ex) {
                final HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 204) {
                    return new ResponseBase<Void, FileDeletionStatus>(httpResponse.getRequest(),
                        httpResponse.getStatusCode(), httpResponse.getHeaders(),
                        BinaryData.fromObject(ex.getValue()).toObject(FileDeletionStatus.class), null);
                }
                throw LOGGER.logExceptionAsError(ex);
            }
        }
        return new SimpleResponse<>(deletedFileWithResponse,
            deletedFileWithResponse.getValue().toObject(FileDeletionStatus.class));
    }

    /**
     * Returns information about a specific file. Does not retrieve file content.
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     object: String (Required)
     *     id: String (Required)
     *     bytes: int (Required)
     *     filename: String (Required)
     *     created_at: long (Required)
     *     purpose: String(fine-tune/fine-tune-results/assistants/assistants_output/batch/batch_output/vision) (Required)
     *     status: String(uploaded/pending/running/processed/error/deleting/deleted) (Optional)
     *     status_details: String (Optional)
     * }
     * }</pre>
     *
     * @param fileId The ID of the file to retrieve.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return represents an assistant that can call the model and use tools along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<OpenAIFile> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        Response<BinaryData> retrievedFileWithResponse;
        if (openAIServiceClient != null) {
            retrievedFileWithResponse = this.openAIServiceClient.getFileWithResponse(fileId, requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            retrievedFileWithResponse = this.serviceClient.getFileWithResponse(fileId, requestOptions);
        }
        return new SimpleResponse<>(retrievedFileWithResponse,
            retrievedFileWithResponse.getValue().toObject(OpenAIFile.class));
    }

    /**
     * Returns information about a specific file. Does not retrieve file content.
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * byte[]
     * }</pre>
     *
     * @param fileId The ID of the file to retrieve.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return represent a byte array along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<byte[]> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        Response<BinaryData> fileContentWithResponse;
        if (openAIServiceClient != null) {
            fileContentWithResponse = this.openAIServiceClient.getFileContentWithResponse(fileId, requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            fileContentWithResponse = this.serviceClient.getFileContentWithResponse(fileId, requestOptions);
        }
        return new SimpleResponse<>(fileContentWithResponse, fileContentWithResponse.getValue().toBytes());
    }

    /**
     * Gets a list of all batches owned by the Azure OpenAI resource.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>Identifier for the last event from the previous pagination
     * request.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>Number of batches to retrieve. Defaults to 20.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     object: String (Required)
     *     data (Optional): [
     *          (Optional){
     *             id: String (Required)
     *             object: String (Required)
     *             endpoint: String (Optional)
     *             errors (Optional): {
     *                 object: String (Required)
     *                 data (Optional): [
     *                      (Optional){
     *                         code: String (Optional)
     *                         message: String (Optional)
     *                         param: String (Optional)
     *                         line: Integer (Optional)
     *                     }
     *                 ]
     *             }
     *             input_file_id: String (Required)
     *             completion_window: String (Optional)
     *             status: String(validating/failed/in_progress/finalizing/completed/expired/cancelling/cancelled) (Optional)
     *             output_file_id: String (Optional)
     *             error_file_id: String (Optional)
     *             created_at: Long (Optional)
     *             in_progress_at: Long (Optional)
     *             expires_at: Long (Optional)
     *             finalizing_at: Long (Optional)
     *             completed_at: Long (Optional)
     *             failed_at: Long (Optional)
     *             expired_at: Long (Optional)
     *             cancelling_at: Long (Optional)
     *             cancelled_at: Long (Optional)
     *             request_counts (Optional): {
     *                 total: Integer (Optional)
     *                 completed: Integer (Optional)
     *                 failed: Integer (Optional)
     *             }
     *             metadata (Optional): {
     *                 String: String (Required)
     *             }
     *         }
     *     ]
     *     first_id: String (Optional)
     *     last_id: String (Optional)
     *     has_more: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all batches owned by the Azure OpenAI resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PageableList<Batch>> listBatchesWithResponse(RequestOptions requestOptions) {
        Response<BinaryData> listedBatchesWithResponse;
        if (openAIServiceClient != null) {
            listedBatchesWithResponse = this.openAIServiceClient.listBatchesWithResponse(requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            listedBatchesWithResponse = this.serviceClient.listBatchesWithResponse(requestOptions);
        }
        OpenAIPageableListOfBatch batchList
            = listedBatchesWithResponse.getValue().toObject(OpenAIPageableListOfBatch.class);
        return new SimpleResponse<>(listedBatchesWithResponse, PageableListAccessHelper.create(batchList.getData(),
            batchList.getFirstId(), batchList.getLastId(), batchList.isHasMore()));
    }

    /**
     * Creates and executes a batch from an uploaded file of requests.
     * Response includes details of the enqueued job including job status.
     * The ID of the result file is added to the response once complete.
     * <p><strong>Request Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     endpoint: String (Required)
     *     input_file_id: String (Required)
     *     completion_window: String (Required)
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     endpoint: String (Optional)
     *     errors (Optional): {
     *         object: String (Required)
     *         data (Optional): [
     *              (Optional){
     *                 code: String (Optional)
     *                 message: String (Optional)
     *                 param: String (Optional)
     *                 line: Integer (Optional)
     *             }
     *         ]
     *     }
     *     input_file_id: String (Required)
     *     completion_window: String (Optional)
     *     status: String(validating/failed/in_progress/finalizing/completed/expired/cancelling/cancelled) (Optional)
     *     output_file_id: String (Optional)
     *     error_file_id: String (Optional)
     *     created_at: Long (Optional)
     *     in_progress_at: Long (Optional)
     *     expires_at: Long (Optional)
     *     finalizing_at: Long (Optional)
     *     completed_at: Long (Optional)
     *     failed_at: Long (Optional)
     *     expired_at: Long (Optional)
     *     cancelling_at: Long (Optional)
     *     cancelled_at: Long (Optional)
     *     request_counts (Optional): {
     *         total: Integer (Optional)
     *         completed: Integer (Optional)
     *         failed: Integer (Optional)
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }</pre>
     *
     * @param createBatchRequest The specification of the batch to create and execute.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the Batch object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Batch> createBatchWithResponse(BinaryData createBatchRequest, RequestOptions requestOptions) {
        Response<BinaryData> createdBatchWithResponse;
        if (openAIServiceClient != null) {
            createdBatchWithResponse
                = this.openAIServiceClient.createBatchWithResponse(createBatchRequest, requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            try {
                createdBatchWithResponse
                    = this.serviceClient.createBatchWithResponse(createBatchRequest, requestOptions);
            } catch (HttpResponseException ex) {
                final HttpResponse httpResponse = ex.getResponse();
                if (httpResponse.getStatusCode() == 200) {
                    return new ResponseBase<Void, Batch>(httpResponse.getRequest(), httpResponse.getStatusCode(),
                        httpResponse.getHeaders(), BinaryData.fromObject(ex.getValue()).toObject(Batch.class), null);
                }
                throw LOGGER.logExceptionAsError(ex);
            }
        }
        return new SimpleResponse<>(createdBatchWithResponse,
            createdBatchWithResponse.getValue().toObject(Batch.class));
    }

    /**
     * Gets details for a single batch specified by the given batchID.
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     endpoint: String (Optional)
     *     errors (Optional): {
     *         object: String (Required)
     *         data (Optional): [
     *              (Optional){
     *                 code: String (Optional)
     *                 message: String (Optional)
     *                 param: String (Optional)
     *                 line: Integer (Optional)
     *             }
     *         ]
     *     }
     *     input_file_id: String (Required)
     *     completion_window: String (Optional)
     *     status: String(validating/failed/in_progress/finalizing/completed/expired/cancelling/cancelled) (Optional)
     *     output_file_id: String (Optional)
     *     error_file_id: String (Optional)
     *     created_at: Long (Optional)
     *     in_progress_at: Long (Optional)
     *     expires_at: Long (Optional)
     *     finalizing_at: Long (Optional)
     *     completed_at: Long (Optional)
     *     failed_at: Long (Optional)
     *     expired_at: Long (Optional)
     *     cancelling_at: Long (Optional)
     *     cancelled_at: Long (Optional)
     *     request_counts (Optional): {
     *         total: Integer (Optional)
     *         completed: Integer (Optional)
     *         failed: Integer (Optional)
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }</pre>
     *
     * @param batchId The identifier of the batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return details for a single batch specified by the given batchID along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Batch> getBatchWithResponse(String batchId, RequestOptions requestOptions) {
        Response<BinaryData> retrievedBatchWithResponse;
        if (openAIServiceClient != null) {
            retrievedBatchWithResponse = this.openAIServiceClient.getBatchWithResponse(batchId, requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            retrievedBatchWithResponse = this.serviceClient.getBatchWithResponse(batchId, requestOptions);
        }
        return new SimpleResponse<>(retrievedBatchWithResponse,
            retrievedBatchWithResponse.getValue().toObject(Batch.class));
    }

    /**
     * Gets details for a single batch specified by the given batchID.
     * <p><strong>Response Body Schema</strong></p>
     *
     * <pre>{@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     endpoint: String (Optional)
     *     errors (Optional): {
     *         object: String (Required)
     *         data (Optional): [
     *              (Optional){
     *                 code: String (Optional)
     *                 message: String (Optional)
     *                 param: String (Optional)
     *                 line: Integer (Optional)
     *             }
     *         ]
     *     }
     *     input_file_id: String (Required)
     *     completion_window: String (Optional)
     *     status: String(validating/failed/in_progress/finalizing/completed/expired/cancelling/cancelled) (Optional)
     *     output_file_id: String (Optional)
     *     error_file_id: String (Optional)
     *     created_at: Long (Optional)
     *     in_progress_at: Long (Optional)
     *     expires_at: Long (Optional)
     *     finalizing_at: Long (Optional)
     *     completed_at: Long (Optional)
     *     failed_at: Long (Optional)
     *     expired_at: Long (Optional)
     *     cancelling_at: Long (Optional)
     *     cancelled_at: Long (Optional)
     *     request_counts (Optional): {
     *         total: Integer (Optional)
     *         completed: Integer (Optional)
     *         failed: Integer (Optional)
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }</pre>
     *
     * @param batchId The identifier of the batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return details for a single batch specified by the given batchID along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Batch> cancelBatchWithResponse(String batchId, RequestOptions requestOptions) {
        Response<BinaryData> cancelledBatchWithResponse;
        if (openAIServiceClient != null) {
            cancelledBatchWithResponse = this.openAIServiceClient.cancelBatchWithResponse(batchId, requestOptions);
        } else {
            addAzureVersionToRequestOptions(serviceClient.getEndpoint(), requestOptions,
                serviceClient.getServiceVersion());
            cancelledBatchWithResponse = this.serviceClient.cancelBatchWithResponse(batchId, requestOptions);
        }
        return new SimpleResponse<>(cancelledBatchWithResponse,
            cancelledBatchWithResponse.getValue().toObject(Batch.class));
    }

    /**
     * Gets a list of previously uploaded files.
     *
     * @param purpose A value that, when provided, limits list results to files matching the corresponding purpose.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of previously uploaded files.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public List<OpenAIFile> listFiles(FilePurpose purpose) {
        // Generated convenience method for listFilesWithResponse
        RequestOptions requestOptions = new RequestOptions();
        if (purpose != null) {
            requestOptions.addQueryParam("purpose", purpose.toString(), false);
        }
        return listFilesWithResponse(requestOptions).getValue();
    }

    /**
     * Gets a list of previously uploaded files.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of previously uploaded files.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public List<OpenAIFile> listFiles() {
        return listFiles(null);
    }

    /**
     * Uploads a file for use by other operations.
     *
     * @param file The file data (not filename) to upload.
     * @param purpose The intended purpose of the file.
     * @param filename A filename to associate with the uploaded data.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an assistant that can call the model and use tools.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private OpenAIFile uploadFile(FileDetails file, FilePurpose purpose, String filename) {
        // Generated convenience method for uploadFileWithResponse
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest uploadFileRequestObj = new UploadFileRequest(file, purpose).setFilename(filename);
        BinaryData uploadFileRequest = new MultipartFormDataHelper(requestOptions)
            .serializeFileField("file", uploadFileRequestObj.getFile().getContent(),
                uploadFileRequestObj.getFile().getContentType(), uploadFileRequestObj.getFile().getFilename())
            .serializeTextField("purpose", Objects.toString(uploadFileRequestObj.getPurpose()))
            .serializeTextField("filename", uploadFileRequestObj.getFilename())
            .end()
            .getRequestBody();
        return uploadFileWithResponse(uploadFileRequest, requestOptions).getValue();
    }

    /**
     * Uploads a file for use by other operations.
     *
     * @param file The file data (not filename) to upload.
     * @param purpose The intended purpose of the file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an assistant that can call the model and use tools.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OpenAIFile uploadFile(FileDetails file, FilePurpose purpose) {
        // Generated convenience method for uploadFileWithResponse
        RequestOptions requestOptions = new RequestOptions();
        UploadFileRequest uploadFileRequestObj = new UploadFileRequest(file, purpose);
        BinaryData uploadFileRequest = new MultipartFormDataHelper(requestOptions)
            .serializeFileField("file", uploadFileRequestObj.getFile().getContent(),
                uploadFileRequestObj.getFile().getContentType(), uploadFileRequestObj.getFile().getFilename())
            .serializeTextField("purpose", Objects.toString(uploadFileRequestObj.getPurpose()))
            .serializeTextField("filename", uploadFileRequestObj.getFilename())
            .end()
            .getRequestBody();
        return uploadFileWithResponse(uploadFileRequest, requestOptions).getValue();
    }

    /**
     * Delete a previously uploaded file.
     *
     * @param fileId The ID of the file to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a status response from a file deletion operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FileDeletionStatus deleteFile(String fileId) {
        // Generated convenience method for deleteFileWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return deleteFileWithResponse(fileId, requestOptions).getValue();
    }

    /**
     * Returns information about a specific file. Does not retrieve file content.
     *
     * @param fileId The ID of the file to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an assistant that can call the model and use tools.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OpenAIFile getFile(String fileId) {
        // Generated convenience method for getFileWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getFileWithResponse(fileId, requestOptions).getValue();
    }

    /**
     * Returns information about a specific file. Does not retrieve file content.
     *
     * @param fileId The ID of the file to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represent a byte array.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public byte[] getFileContent(String fileId) {
        // Generated convenience method for getFileContentWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getFileContentWithResponse(fileId, requestOptions).getValue();
    }

    /**
     * Gets a list of all batches owned by the Azure OpenAI resource.
     *
     * @param after Identifier for the last event from the previous pagination request.
     * @param limit The number of batches to retrieve. The default is 20.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all batches owned by the Azure OpenAI resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PageableList<Batch> listBatches(String after, Integer limit) {
        // Generated convenience method for listBatchesWithResponse
        RequestOptions requestOptions = new RequestOptions();
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        return listBatchesWithResponse(requestOptions).getValue();
    }

    /**
     * Gets a list of all batches owned by the Azure OpenAI resource.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all batches owned by the Azure OpenAI resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PageableList<Batch> listBatches() {
        return listBatches(null, null);
    }

    /**
     * Gets details for a single batch specified by the given batchID.
     *
     * @param batchId The identifier of the batch.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details for a single batch specified by the given batchID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Batch getBatch(String batchId) {
        // Generated convenience method for getBatchWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getBatchWithResponse(batchId, requestOptions).getValue();
    }

    /**
     * Gets details for a single batch specified by the given batchID.
     *
     * @param batchId The identifier of the batch.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details for a single batch specified by the given batchID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Batch cancelBatch(String batchId) {
        // Generated convenience method for cancelBatchWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return cancelBatchWithResponse(batchId, requestOptions).getValue();
    }

    /**
     * Creates and executes a batch from an uploaded file of requests.
     * Response includes details of the enqueued job including job status.
     * The ID of the result file is added to the response once complete.
     *
     * @param createBatchRequest The specification of the batch to create and execute.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Batch object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Batch createBatch(BatchCreateRequest createBatchRequest) {
        // Generated convenience method for createBatchWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return createBatchWithResponse(BinaryData.fromObject(createBatchRequest), requestOptions).getValue();
    }
}
