/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training;

import com.azure.ai.formrecognizer.FormRecognizerAsyncClient;
import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.ComposeCustomModelsAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.ComposeRequest;
import com.azure.ai.formrecognizer.implementation.models.CopyAuthorizationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyCustomModelHeaders;
import com.azure.ai.formrecognizer.implementation.models.CopyOperationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyRequest;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.OperationStatus;
import com.azure.ai.formrecognizer.implementation.models.TrainCustomModelAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.ai.formrecognizer.implementation.models.TrainSourceFilter;
import com.azure.ai.formrecognizer.models.CreateComposedModelOptions;
import com.azure.ai.formrecognizer.models.FormRecognizerErrorInformation;
import com.azure.ai.formrecognizer.models.FormRecognizerException;
import com.azure.ai.formrecognizer.models.FormRecognizerOperationResult;
import com.azure.ai.formrecognizer.training.CustomModelTransforms;
import com.azure.ai.formrecognizer.training.FormTrainingClientBuilder;
import com.azure.ai.formrecognizer.training.models.AccountProperties;
import com.azure.ai.formrecognizer.training.models.CopyAuthorization;
import com.azure.ai.formrecognizer.training.models.CustomFormModel;
import com.azure.ai.formrecognizer.training.models.CustomFormModelInfo;
import com.azure.ai.formrecognizer.training.models.CustomFormModelStatus;
import com.azure.ai.formrecognizer.training.models.TrainingOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=FormTrainingClientBuilder.class, isAsync=true)
public final class FormTrainingAsyncClient {
    private final ClientLogger logger = new ClientLogger(FormTrainingAsyncClient.class);
    private final FormRecognizerClientImpl service;
    private final FormRecognizerServiceVersion serviceVersion;

    FormTrainingAsyncClient(FormRecognizerClientImpl service, FormRecognizerServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    public FormRecognizerAsyncClient getFormRecognizerAsyncClient() {
        return new FormRecognizerClientBuilder().endpoint(this.getEndpoint()).pipeline(this.getHttpPipeline()).buildAsyncClient();
    }

    HttpPipeline getHttpPipeline() {
        return this.service.getHttpPipeline();
    }

    String getEndpoint() {
        return this.service.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, CustomFormModel> beginTraining(String trainingFilesUrl, boolean useTrainingLabels) {
        return this.beginTraining(trainingFilesUrl, useTrainingLabels, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, CustomFormModel> beginTraining(String trainingFilesUrl, boolean useTrainingLabels, TrainingOptions trainingOptions) {
        return this.beginTraining(trainingFilesUrl, useTrainingLabels, trainingOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, CustomFormModel> beginTraining(String trainingFilesUrl, boolean useTrainingLabels, TrainingOptions trainingOptions, Context context) {
        trainingOptions = trainingOptions == null ? new TrainingOptions() : trainingOptions;
        return new PollerFlux(trainingOptions.getPollInterval(), this.getTrainingActivationOperation(trainingFilesUrl, useTrainingLabels, trainingOptions.getTrainingFileFilter() != null ? trainingOptions.getTrainingFileFilter().isSubfoldersIncluded() : false, trainingOptions.getTrainingFileFilter() != null ? trainingOptions.getTrainingFileFilter().getPrefix() : null, trainingOptions.getModelName(), context), this.createModelPollOperation(context), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchModelResultOperation(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomFormModel> getCustomModel(String modelId) {
        return this.getCustomModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CustomFormModel>> getCustomModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.getCustomModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CustomFormModel>> getCustomModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        return this.service.getCustomModelWithResponseAsync(UUID.fromString(modelId), true, context).onErrorMap(Utility::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)CustomModelTransforms.toCustomFormModel((Model)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccountProperties> getAccountProperties() {
        return this.getAccountPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccountProperties>> getAccountPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AccountProperties>> getAccountPropertiesWithResponse(Context context) {
        return this.service.getCustomModelsWithResponseAsync(context).onErrorMap(Utility::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)new AccountProperties(((Models)response.getValue()).getSummary().getCount(), ((Models)response.getValue()).getSummary().getLimit())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModel(String modelId) {
        return this.deleteModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.deleteModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        return this.service.deleteCustomModelWithResponseAsync(UUID.fromString(modelId), context).onErrorMap(Utility::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CustomFormModelInfo> listCustomModels() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listFirstPageModelInfo), continuationToken -> FluxUtil.withContext(context -> this.listNextPageModelInfo((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CustomFormModelInfo> listCustomModels(Context context) {
        return new PagedFlux(() -> this.listFirstPageModelInfo(context), continuationToken -> this.listNextPageModelInfo((String)continuationToken, context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModel(String modelId, CopyAuthorization target) {
        return this.beginCopyModel(modelId, target, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModel(String modelId, CopyAuthorization target, Duration pollInterval) {
        return this.beginCopyModel(modelId, target, pollInterval, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModel(String modelId, CopyAuthorization target, Duration pollInterval, Context context) {
        Duration interval = pollInterval != null ? pollInterval : Utility.DEFAULT_POLL_INTERVAL;
        return new PollerFlux(interval, this.getCopyActivationOperation(modelId, target, context), this.createCopyPollOperation(modelId, context), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchCopyModelResultOperation(modelId, target.getModelId(), context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> getCopyAuthorization(String resourceId, String resourceRegion) {
        return this.getCopyAuthorizationWithResponse(resourceId, resourceRegion).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> getCopyAuthorizationWithResponse(String resourceId, String resourceRegion) {
        try {
            return FluxUtil.withContext(context -> this.getCopyAuthorizationWithResponse(resourceId, resourceRegion, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModel(List<String> modelIds) {
        return this.beginCreateComposedModel(modelIds, null, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModel(List<String> modelIds, CreateComposedModelOptions createComposedModelOptions) {
        return this.beginCreateComposedModel(modelIds, createComposedModelOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModel(List<String> modelIds, CreateComposedModelOptions creatComposeModelOptions, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty(modelIds)) {
                throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'modelIds' cannot be null or empty"));
            }
            creatComposeModelOptions = FormTrainingAsyncClient.getCreateComposeModelOptions(creatComposeModelOptions);
            ComposeRequest composeRequest = new ComposeRequest().setModelIds(modelIds.stream().map(UUID::fromString).collect(Collectors.toList())).setModelName(creatComposeModelOptions.getModelName());
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, Utility.urlActivationOperation(() -> this.service.composeCustomModelsAsyncWithResponseAsync(composeRequest, context).map(response -> {
                String composeModelOperationId = Utility.parseModelId(((ComposeCustomModelsAsyncHeaders)response.getDeserializedHeaders()).getLocation());
                return new FormRecognizerOperationResult(composeModelOperationId);
            }), this.logger), this.createModelPollOperation(context), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchModelResultOperation(context));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    Mono<Response<CopyAuthorization>> getCopyAuthorizationWithResponse(String resourceId, String resourceRegion, Context context) {
        Objects.requireNonNull(resourceId, "'resourceId' cannot be null");
        Objects.requireNonNull(resourceRegion, "'resourceRegion' cannot be null");
        return this.service.generateModelCopyAuthorizationWithResponseAsync(context).onErrorMap(Utility::mapToHttpResponseExceptionIfExists).map(response -> {
            CopyAuthorizationResult copyAuthorizationResult = response.getValue();
            return new SimpleResponse((Response)response, (Object)new CopyAuthorization(copyAuthorizationResult.getModelId(), copyAuthorizationResult.getAccessToken(), resourceId, resourceRegion, copyAuthorizationResult.getExpirationDateTimeTicks()));
        });
    }

    private Mono<PagedResponse<CustomFormModelInfo>> listFirstPageModelInfo(Context context) {
        return this.service.listCustomModelsSinglePageAsync(context).doOnRequest(ignoredValue -> this.logger.info("Listing information for all models")).doOnSuccess(response -> this.logger.info("Listed all models")).doOnError(error -> this.logger.warning("Failed to list all models information", new Object[]{error})).onErrorMap(Utility::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), CustomModelTransforms.toCustomFormModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<CustomFormModelInfo>> listNextPageModelInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.listCustomModelsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).onErrorMap(Utility::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), CustomModelTransforms.toCustomFormModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<CustomFormModelInfo>> fetchCopyModelResultOperation(String modelId, String copyModelId, Context context) {
        return pollingContext -> {
            try {
                UUID resultUid = UUID.fromString(((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                Objects.requireNonNull(modelId, "'modelId' cannot be null.");
                return this.service.getCustomModelCopyResultWithResponseAsync(UUID.fromString(modelId), resultUid, context).map(modelSimpleResponse -> {
                    CopyOperationResult copyOperationResult = (CopyOperationResult)modelSimpleResponse.getValue();
                    return new CustomFormModelInfo(copyModelId, copyOperationResult.getStatus() == OperationStatus.SUCCEEDED ? CustomFormModelStatus.READY : CustomFormModelStatus.fromString(copyOperationResult.getStatus().toString()), copyOperationResult.getCreatedDateTime(), copyOperationResult.getLastUpdatedDateTime());
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<PollResponse<FormRecognizerOperationResult>>> createCopyPollOperation(String modelId, Context context) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID targetId = UUID.fromString(((FormRecognizerOperationResult)operationResultPollResponse.getValue()).getResultId());
                return this.service.getCustomModelCopyResultWithResponseAsync(UUID.fromString(modelId), targetId, context).flatMap(modelSimpleResponse -> this.processCopyModelResponse((Response<CopyOperationResult>)modelSimpleResponse, (PollResponse<FormRecognizerOperationResult>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (HttpResponseException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)ex));
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<FormRecognizerOperationResult>> getCopyActivationOperation(String modelId, CopyAuthorization target, Context context) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(modelId, "'modelId' cannot be null.");
                Objects.requireNonNull(target, "'target' cannot be null.");
                CopyRequest copyRequest = new CopyRequest().setTargetResourceId(target.getResourceId()).setTargetResourceRegion(target.getResourceRegion()).setCopyAuthorization(new CopyAuthorizationResult().setModelId(target.getModelId()).setAccessToken(target.getAccessToken()).setExpirationDateTimeTicks(target.getExpiresOn().toEpochSecond()));
                return this.service.copyCustomModelWithResponseAsync(UUID.fromString(modelId), copyRequest, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((CopyCustomModelHeaders)response.getDeserializedHeaders()).getOperationLocation()))).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<FormRecognizerOperationResult>> processCopyModelResponse(Response<CopyOperationResult> copyModel, PollResponse<FormRecognizerOperationResult> copyModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (((CopyOperationResult)copyModel.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new FormRecognizerException("Copy operation failed", ((CopyOperationResult)copyModel.getValue()).getCopyResult().getErrors().stream().map(errorInformation -> new FormRecognizerErrorInformation(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList()))));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((CopyOperationResult)copyModel.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((FormRecognizerOperationResult)copyModelOperationResponse.getValue())));
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<CustomFormModel>> fetchModelResultOperation(Context context) {
        return pollingContext -> {
            try {
                UUID modelUid = UUID.fromString(((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                return this.service.getCustomModelWithResponseAsync(modelUid, true, context).map(modelSimpleResponse -> CustomModelTransforms.toCustomFormModel((Model)modelSimpleResponse.getValue())).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<PollResponse<FormRecognizerOperationResult>>> createModelPollOperation(Context context) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID modelUid = UUID.fromString(((FormRecognizerOperationResult)operationResultPollResponse.getValue()).getResultId());
                return this.service.getCustomModelWithResponseAsync(modelUid, true, context).flatMap(modelSimpleResponse -> this.processTrainingModelResponse((Response<Model>)modelSimpleResponse, (PollResponse<FormRecognizerOperationResult>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (HttpResponseException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)ex));
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<FormRecognizerOperationResult>> getTrainingActivationOperation(String trainingFilesUrl, boolean useTrainingLabels, boolean includeSubfolders, String filePrefix, String modelName, Context context) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(trainingFilesUrl, "'trainingFilesUrl' cannot be null.");
                TrainSourceFilter trainSourceFilter = new TrainSourceFilter().setIncludeSubFolders(includeSubfolders).setPrefix(filePrefix);
                TrainRequest serviceTrainRequest = new TrainRequest().setSource(trainingFilesUrl).setSourceFilter(trainSourceFilter).setUseLabelFile(useTrainingLabels).setModelName(modelName);
                return this.service.trainCustomModelAsyncWithResponseAsync(serviceTrainRequest, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((TrainCustomModelAsyncHeaders)response.getDeserializedHeaders()).getLocation()))).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<FormRecognizerOperationResult>> processTrainingModelResponse(Response<Model> trainingModel, PollResponse<FormRecognizerOperationResult> trainingModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (((Model)trainingModel.getValue()).getModelInfo().getStatus()) {
            case CREATING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case READY: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case INVALID: {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new FormRecognizerException(String.format("Invalid model created with model Id %s", ((Model)trainingModel.getValue()).getModelInfo().getModelId()), ((Model)trainingModel.getValue()).getTrainResult().getErrors().stream().map(errorInformation -> new FormRecognizerErrorInformation(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList()))));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((Model)trainingModel.getValue()).getModelInfo().getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((FormRecognizerOperationResult)trainingModelOperationResponse.getValue())));
    }

    private static CreateComposedModelOptions getCreateComposeModelOptions(CreateComposedModelOptions userProvidedOptions) {
        return userProvidedOptions == null ? new CreateComposedModelOptions() : userProvidedOptions;
    }
}

