/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.models.FieldValueType;
import com.azure.ai.formrecognizer.models.FormField;
import com.azure.ai.formrecognizer.models.SelectionMarkState;
import com.azure.core.util.logging.ClientLogger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

public final class FieldValue {
    private final ClientLogger logger = new ClientLogger(FieldValue.class);
    private final FieldValueType valueType;
    private Map<String, FormField> formFieldMap;
    private List<FormField> formFieldList;
    private Float formFieldFloat;
    private Long formFieldLong;
    private LocalDate formFieldDate;
    private LocalTime formFieldTime;
    private SelectionMarkState selectionMarkState;
    private String formFieldString;
    private String formFieldPhoneNumber;
    private String formFieldCountryRegion;

    public FieldValue(Object value, FieldValueType valueType) {
        this.valueType = valueType;
        switch (valueType) {
            case STRING: {
                this.formFieldString = (String)value;
                break;
            }
            case DATE: {
                this.formFieldDate = (LocalDate)value;
                break;
            }
            case TIME: {
                this.formFieldTime = (LocalTime)value;
                break;
            }
            case PHONE_NUMBER: {
                this.formFieldPhoneNumber = (String)value;
                break;
            }
            case FLOAT: {
                this.formFieldFloat = (Float)value;
                break;
            }
            case LONG: {
                this.formFieldLong = (Long)value;
                break;
            }
            case LIST: {
                this.formFieldList = (List)value;
                break;
            }
            case MAP: {
                this.formFieldMap = (Map)value;
                break;
            }
            case SELECTION_MARK_STATE: {
                this.selectionMarkState = (SelectionMarkState)((Object)value);
                break;
            }
            case COUNTRY_REGION: {
                this.formFieldCountryRegion = (String)value;
                break;
            }
            default: {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Unexpected type value: " + (Object)((Object)valueType)));
            }
        }
    }

    public FieldValueType getValueType() {
        return this.valueType;
    }

    public String asString() {
        if (FieldValueType.STRING != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as %s from field value of type %s", new Object[]{FieldValueType.STRING, this.getValueType()})));
        }
        return this.formFieldString;
    }

    public Long asLong() {
        if (FieldValueType.LONG != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as %s from field value of type %s", new Object[]{FieldValueType.LONG, this.getValueType()})));
        }
        return this.formFieldLong;
    }

    public Float asFloat() {
        if (FieldValueType.FLOAT != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as %s from field value of type %s", new Object[]{FieldValueType.FLOAT, this.getValueType()})));
        }
        return this.formFieldFloat;
    }

    public LocalDate asDate() {
        if (FieldValueType.DATE != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as %s from field value of type %s", new Object[]{FieldValueType.DATE, this.getValueType()})));
        }
        return this.formFieldDate;
    }

    public LocalTime asTime() {
        if (FieldValueType.TIME != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as %s from field value of type %s", new Object[]{FieldValueType.TIME, this.getValueType()})));
        }
        return this.formFieldTime;
    }

    public String asPhoneNumber() {
        if (FieldValueType.PHONE_NUMBER != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as a%s from field value of type %s", new Object[]{FieldValueType.PHONE_NUMBER, this.getValueType()})));
        }
        return this.formFieldPhoneNumber;
    }

    public List<FormField> asList() {
        if (FieldValueType.LIST != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as a %s from field value of type %s", new Object[]{FieldValueType.LIST, this.getValueType()})));
        }
        return this.formFieldList;
    }

    public Map<String, FormField> asMap() {
        if (FieldValueType.MAP != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as a %s from field value of type %s", new Object[]{FieldValueType.MAP, this.getValueType()})));
        }
        return this.formFieldMap;
    }

    public SelectionMarkState asSelectionMarkState() {
        if (FieldValueType.SELECTION_MARK_STATE != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as a %s from field value of type %s", new Object[]{FieldValueType.SELECTION_MARK_STATE, this.getValueType()})));
        }
        return this.selectionMarkState;
    }

    public String asCountryRegion() {
        if (FieldValueType.COUNTRY_REGION != this.getValueType()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get field as a %s from field value of type %s", new Object[]{FieldValueType.COUNTRY_REGION, this.getValueType()})));
        }
        return this.formFieldCountryRegion;
    }
}

