/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerAsyncClient;
import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.FormRecognizerOperationResult;
import com.azure.ai.formrecognizer.models.RecognizeBusinessCardsOptions;
import com.azure.ai.formrecognizer.models.RecognizeContentOptions;
import com.azure.ai.formrecognizer.models.RecognizeCustomFormsOptions;
import com.azure.ai.formrecognizer.models.RecognizeIdentityDocumentOptions;
import com.azure.ai.formrecognizer.models.RecognizeInvoicesOptions;
import com.azure.ai.formrecognizer.models.RecognizeReceiptsOptions;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;

@ServiceClient(builder=FormRecognizerClientBuilder.class)
public final class FormRecognizerClient {
    private final FormRecognizerAsyncClient client;

    FormRecognizerClient(FormRecognizerAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl) {
        return this.beginRecognizeCustomFormsFromUrl(modelId, formUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        return this.client.beginRecognizeCustomFormsFromUrl(formUrl, modelId, recognizeCustomFormsOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, InputStream form, long length) {
        return this.beginRecognizeCustomForms(modelId, form, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, InputStream form, long length, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(form);
        return this.client.beginRecognizeCustomForms(modelId, buffer, length, recognizeCustomFormsOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl) {
        return this.beginRecognizeContentFromUrl(formUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl, RecognizeContentOptions recognizeContentOptions, Context context) {
        return this.client.beginRecognizeContentFromUrl(formUrl, recognizeContentOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(InputStream form, long length) {
        return this.beginRecognizeContent(form, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(InputStream form, long length, RecognizeContentOptions recognizeContentOptions, Context context) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(form);
        return this.client.beginRecognizeContent(buffer, length, recognizeContentOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl) {
        return this.beginRecognizeReceiptsFromUrl(receiptUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        return this.client.beginRecognizeReceiptsFromUrl(receiptUrl, recognizeReceiptsOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(InputStream receipt, long length) {
        return this.beginRecognizeReceipts(receipt, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(InputStream receipt, long length, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(receipt);
        return this.client.beginRecognizeReceipts(buffer, length, recognizeReceiptsOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl) {
        return this.beginRecognizeBusinessCardsFromUrl(businessCardUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        return this.client.beginRecognizeBusinessCardsFromUrl(businessCardUrl, recognizeBusinessCardsOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(InputStream businessCard, long length) {
        return this.beginRecognizeBusinessCards(businessCard, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(InputStream businessCard, long length, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        return this.client.beginRecognizeBusinessCards(Utility.toFluxByteBuffer(businessCard), length, recognizeBusinessCardsOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl) {
        return this.beginRecognizeInvoicesFromUrl(invoiceUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        return this.client.beginRecognizeInvoicesFromUrl(invoiceUrl, recognizeInvoicesOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(InputStream invoice, long length) {
        return this.beginRecognizeInvoices(invoice, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(InputStream invoice, long length, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(invoice);
        return this.client.beginRecognizeInvoices(buffer, length, recognizeInvoicesOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl) {
        return this.beginRecognizeIdentityDocumentsFromUrl(identityDocumentUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        return this.client.beginRecognizeIdentityDocumentsFromUrl(identityDocumentUrl, recognizeIdentityDocumentOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(InputStream identityDocument, long length) {
        return this.beginRecognizeIdentityDocuments(identityDocument, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(InputStream identityDocument, long length, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        return this.client.beginRecognizeIdentityDocuments(Utility.toFluxByteBuffer(identityDocument), length, recognizeIdentityDocumentOptions, context).getSyncPoller();
    }
}

