/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.models.FormContentType;
import java.time.Duration;
import java.util.List;

public final class RecognizeCustomFormsOptions {
    private FormContentType contentType;
    private boolean includeFieldElements;
    private List<String> pages;
    private Duration pollInterval = Utility.DEFAULT_POLL_INTERVAL;

    public FormContentType getContentType() {
        return this.contentType;
    }

    public boolean isFieldElementsIncluded() {
        return this.includeFieldElements;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public RecognizeCustomFormsOptions setContentType(FormContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RecognizeCustomFormsOptions setFieldElementsIncluded(boolean includeFieldElements) {
        this.includeFieldElements = includeFieldElements;
        return this;
    }

    public RecognizeCustomFormsOptions setPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval == null ? Utility.DEFAULT_POLL_INTERVAL : pollInterval;
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public RecognizeCustomFormsOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }
}

