/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.administration;

import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClient;
import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.administration.DocumentModelAdministrationAsyncClient;
import com.azure.ai.formrecognizer.documentanalysis.administration.DocumentModelAdministrationClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BuildDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ComposeDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.CopyAuthorizationOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelBuildMode;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelCopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationSummary;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ResourceDetails;
import com.azure.ai.formrecognizer.documentanalysis.models.OperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import java.util.List;

@ServiceClient(builder=DocumentModelAdministrationClientBuilder.class)
public final class DocumentModelAdministrationClient {
    private final DocumentModelAdministrationAsyncClient client;

    DocumentModelAdministrationClient(DocumentModelAdministrationAsyncClient documentAnalysisTrainingAsyncClient) {
        this.client = documentAnalysisTrainingAsyncClient;
    }

    public DocumentAnalysisClient getDocumentAnalysisClient() {
        return new DocumentAnalysisClientBuilder().endpoint(this.client.getEndpoint()).pipeline(this.client.getHttpPipeline()).audience(this.client.getAudience()).buildClient();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginBuildDocumentModel(String blobContainerUrl, DocumentModelBuildMode buildMode) {
        return this.beginBuildDocumentModel(blobContainerUrl, buildMode, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginBuildDocumentModel(String blobContainerUrl, DocumentModelBuildMode buildMode, String prefix, BuildDocumentModelOptions buildDocumentModelOptions, Context context) {
        return this.client.beginBuildDocumentModel(blobContainerUrl, buildMode, prefix, buildDocumentModelOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceDetails getResourceDetails() {
        return (ResourceDetails)this.getResourceDetailsWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceDetails> getResourceDetailsWithResponse(Context context) {
        return (Response)this.client.getResourceDetailsWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDocumentModel(String modelId) {
        this.deleteDocumentModelWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDocumentModelWithResponse(String modelId, Context context) {
        return (Response)this.client.deleteDocumentModelWithResponse(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelCopyAuthorization getCopyAuthorization() {
        return (DocumentModelCopyAuthorization)this.getCopyAuthorizationWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentModelCopyAuthorization> getCopyAuthorizationWithResponse(CopyAuthorizationOptions copyAuthorizationOptions, Context context) {
        return (Response)this.client.getCopyAuthorizationWithResponse(copyAuthorizationOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginComposeDocumentModel(List<String> componentModelIds) {
        return this.beginComposeDocumentModel(componentModelIds, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginComposeDocumentModel(List<String> componentModelIds, ComposeDocumentModelOptions composeDocumentModelOptions, Context context) {
        return this.client.beginComposeDocumentModel(componentModelIds, composeDocumentModelOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginCopyDocumentModelTo(String sourceModelId, DocumentModelCopyAuthorization target) {
        return this.beginCopyDocumentModelTo(sourceModelId, target, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginCopyDocumentModelTo(String sourceModelId, DocumentModelCopyAuthorization target, Context context) {
        return this.client.beginCopyDocumentModelTo(sourceModelId, target, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listDocumentModels() {
        return new PagedIterable(this.client.listDocumentModels(Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listDocumentModels(Context context) {
        return new PagedIterable(this.client.listDocumentModels(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelDetails getDocumentModel(String modelId) {
        return (DocumentModelDetails)this.getDocumentModelWithResponse(modelId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentModelDetails> getDocumentModelWithResponse(String modelId, Context context) {
        return (Response)this.client.getDocumentModelWithResponse(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationDetails getOperation(String operationId) {
        return (OperationDetails)this.getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationDetails> getOperationWithResponse(String operationId, Context context) {
        return (Response)this.client.getOperationWithResponse(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> listOperations() {
        return new PagedIterable(this.client.listOperations(Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> listOperations(Context context) {
        return new PagedIterable(this.client.listOperations(context));
    }
}

