/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.http;

import com.aventstack.chaintest.conf.Configuration;
import com.aventstack.chaintest.domain.ChainTestEntity;
import com.aventstack.chaintest.http.HttpMethod;
import com.aventstack.chaintest.http.HttpRetryHandler;
import com.aventstack.chaintest.http.JsonMappedBodyHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainTestApiClient {
    private static final Logger log = LoggerFactory.getLogger(ChainTestApiClient.class);
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(30L);
    private static final HttpMethod DEFAULT_HTTP_METHOD = HttpMethod.POST;
    public static final String PROPERTY_SERVER_URL = "chaintest.generator.chainlp.host.url";
    public static final String CLIENT_REQUEST_TIMEOUT = "chaintest.generator.chainlp.client.request-timeout-s";
    public static final String CLIENT_EXPECT_CONTINUE = "chaintest.generator.chainlp.client.expect-continue";
    public static final String CLIENT_MAX_RETRIES = "chaintest.generator.chainlp.client.max-retries";
    public static final String CLIENT_RETRY_INTERVAL = "chaintest.generator.chainlp.client.retry-interval-ms";
    public static final String CLIENT_THROW_AFTER_RETRY_ATTEMPTS_EXCEEDED = "chaintest.generator.chainlp.client.throw-after-retry-attempts-exceeded";
    private static final String API_VERSION = "/api/v1/";
    private final HttpClient _httpClient;
    private final ObjectMapper _mapper;
    private final URI _baseURI;
    private final HttpRetryHandler _retryHandler;
    private Configuration _config;
    private Duration _requestTimeout;
    private String _serverURL;
    private boolean _expectContinue;

    public ChainTestApiClient() throws IOException {
        Builder builder = ChainTestApiClient.builder().defaultBuilder();
        this._httpClient = builder.httpClient;
        this._mapper = builder.objectMapper;
        this._requestTimeout = builder.timeout;
        this.loadConfig();
        this._baseURI = URI.create(this._serverURL).resolve(API_VERSION);
        this._retryHandler = new HttpRetryHandler(this, this._config.getConfig());
    }

    public void loadConfig() throws IOException {
        this._config = new Configuration();
        this._config.load();
        Map<String, String> config = this._config.getConfig();
        this._serverURL = config.get(PROPERTY_SERVER_URL);
        if (null == this._serverURL || this._serverURL.isBlank()) {
            throw new IllegalStateException("ChainTest endpoint was not provided by property chaintest.generator.chainlp.host.url. No such property was found in classpath resources or system env");
        }
        String timeout = config.get(CLIENT_REQUEST_TIMEOUT);
        if (null != timeout && timeout.matches("\\d+")) {
            this._requestTimeout = Duration.ofSeconds(Integer.parseInt(timeout));
        }
        String expectContinue = config.get(CLIENT_EXPECT_CONTINUE);
        this._expectContinue = Boolean.parseBoolean(expectContinue);
    }

    public ChainTestApiClient(Configuration conf) {
        this._config = conf;
        Builder builder = ChainTestApiClient.builder().defaultBuilder();
        this._httpClient = builder.httpClient;
        this._mapper = builder.objectMapper;
        this._requestTimeout = builder.timeout;
        this._baseURI = URI.create(this._serverURL).resolve(API_VERSION);
        this._retryHandler = new HttpRetryHandler(this, this._config.getConfig());
    }

    public ChainTestApiClient(Builder builder) {
        if (null == builder.uri) {
            throw new IllegalArgumentException("Missing argument: uri");
        }
        this._httpClient = null == builder.httpClient ? HttpClient.newHttpClient() : builder.httpClient;
        this._mapper = null == builder.objectMapper ? new ObjectMapper() : builder.objectMapper;
        this._requestTimeout = null == builder.timeout ? DEFAULT_REQUEST_TIMEOUT : builder.timeout;
        this._baseURI = builder.uri;
        this._expectContinue = builder.expectContinue;
        int maxRetryAttempts = builder.maxRetryAttempts == -1 ? 3 : builder.maxRetryAttempts;
        long retryIntervalMs = builder.retryIntervalMs == -1L ? 2000L : builder.retryIntervalMs;
        this._retryHandler = new HttpRetryHandler(this, maxRetryAttempts, retryIntervalMs, builder.throwAfterMaxRetryAttempts);
    }

    public ChainTestApiClient(URI uri, boolean loadExternalConfig) throws IOException {
        this(ChainTestApiClient.builder().defaultBuilder().withURI(uri));
        if (loadExternalConfig) {
            this.loadConfig();
        }
    }

    public ChainTestApiClient(URI uri) {
        this(ChainTestApiClient.builder().defaultBuilder().withURI(uri));
    }

    public ChainTestApiClient(String url, boolean loadExternalConfig) throws IOException {
        this(URI.create(url), loadExternalConfig);
    }

    public ChainTestApiClient(String url) {
        this(ChainTestApiClient.builder().defaultBuilder().withURI(URI.create(url)));
    }

    public Configuration config() {
        return this._config;
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    public HttpRetryHandler retryHandler() {
        return this._retryHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T extends ChainTestEntity> HttpResponse<String> send(T entity, HttpMethod method) throws IOException, InterruptedException {
        HttpRequest request = this.createRequest(entity, method);
        return this._httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public <T extends ChainTestEntity> HttpResponse<String> send(T entity) throws IOException, InterruptedException {
        return this.send(entity, DEFAULT_HTTP_METHOD);
    }

    public <T extends ChainTestEntity> HttpResponse<T> send(T entity, Class<T> clazz, HttpMethod method) throws IOException, InterruptedException {
        HttpRequest request = this.createRequest(entity, method);
        return this._httpClient.send(request, new JsonMappedBodyHandler<T>(clazz, this._mapper));
    }

    public <T extends ChainTestEntity> HttpResponse<T> send(T entity, Class<T> clazz) throws IOException, InterruptedException {
        return this.send(entity, clazz, DEFAULT_HTTP_METHOD);
    }

    public <T extends ChainTestEntity> CompletableFuture<HttpResponse<String>> sendAsync(T entity, HttpMethod method) throws IOException {
        HttpRequest request = this.createRequest(entity, method);
        return this._httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public <T extends ChainTestEntity> CompletableFuture<HttpResponse<String>> sendAsync(T entity) throws IOException {
        return this.sendAsync(entity, DEFAULT_HTTP_METHOD);
    }

    public <T extends ChainTestEntity> CompletableFuture<HttpResponse<T>> sendAsync(T entity, Class<T> clazz, HttpMethod method) throws IOException {
        HttpRequest request = this.createRequest(entity, method);
        return this._httpClient.sendAsync(request, new JsonMappedBodyHandler<T>(clazz, this._mapper));
    }

    public <T extends ChainTestEntity> CompletableFuture<HttpResponse<T>> sendAsync(T entity, Class<T> clazz) throws IOException {
        return this.sendAsync(entity, clazz, DEFAULT_HTTP_METHOD);
    }

    public HttpResponse<String> send(byte[] data, HttpMethod method) throws IOException, InterruptedException {
        HttpRequest request = this.createRequest(data, method);
        return this._httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> send(byte[] data) throws IOException, InterruptedException {
        return this.send(data, DEFAULT_HTTP_METHOD);
    }

    public CompletableFuture<HttpResponse<String>> sendAsync(byte[] data, HttpMethod method) {
        HttpRequest request = this.createRequest(data, method);
        return this._httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public CompletableFuture<HttpResponse<String>> sendAsync(byte[] data) {
        return this.sendAsync(data, DEFAULT_HTTP_METHOD);
    }

    private HttpRequest createRequest(byte[] data, HttpMethod method) {
        log.trace("Creating request with HTTPMethod.{}", (Object)method.getMethod());
        URI uri = this.getURI("embeds");
        log.debug("Created request with byte array of length: {}", (Object)data.length);
        return HttpRequest.newBuilder().uri(uri).expectContinue(this._expectContinue).timeout(this._requestTimeout).header("Content-Type", "application/octet-stream").header("Accept", "application/json").method(method.getMethod(), HttpRequest.BodyPublishers.ofByteArray(data)).build();
    }

    private <T extends ChainTestEntity> HttpRequest createRequest(T entity, HttpMethod method) throws IOException {
        log.trace("Creating request for entity {} with HTTPMethod.{}", (Object)entity.getClass().getName(), (Object)method.getMethod());
        URI uri = this.getURI(entity);
        String requestBody = this._mapper.writeValueAsString(entity);
        log.debug("Created request for entity {} with body: {}", (Object)entity.getClass().getSimpleName(), (Object)requestBody);
        return HttpRequest.newBuilder().uri(uri).expectContinue(this._expectContinue).timeout(this._requestTimeout).header("Content-Type", "application/json").header("Accept", "application/json").method(method.getMethod(), HttpRequest.BodyPublishers.ofString(requestBody)).build();
    }

    private <T extends ChainTestEntity> URI getURI(T entity) {
        String clz = entity.getClass().getSimpleName().toLowerCase();
        return this._baseURI.resolve(clz + "s");
    }

    private <T extends ChainTestEntity> URI getURI(String forPath) {
        return this._baseURI.resolve(forPath);
    }

    public static final class Builder {
        private HttpClient httpClient;
        private ObjectMapper objectMapper;
        private Duration timeout;
        private URI uri;
        private boolean expectContinue;
        private int maxRetryAttempts = -1;
        private long retryIntervalMs = -1L;
        private boolean throwAfterMaxRetryAttempts = true;

        public Builder withHttpClient(HttpClient client) {
            this.httpClient = client;
            return this;
        }

        public Builder withObjectMapper(ObjectMapper mapper) {
            this.objectMapper = mapper;
            return this;
        }

        public Builder withRequestTimeout(Duration duration) {
            this.timeout = duration;
            return this;
        }

        public Builder withURI(URI uri) {
            this.uri = uri.resolve(ChainTestApiClient.API_VERSION);
            return this;
        }

        public Builder withURI(String url) {
            this.withURI(URI.create(url));
            return this;
        }

        public Builder withExpectContinue(boolean expectContinue) {
            this.expectContinue = expectContinue;
            return this;
        }

        public Builder withMaxHttpRetryAttempts(int maxRetryAttempts) {
            this.maxRetryAttempts = maxRetryAttempts;
            return this;
        }

        public Builder withRetryIntervalMs(long retryIntervalMs) {
            this.retryIntervalMs = retryIntervalMs;
            return this;
        }

        public Builder withThrowAfterMaxRetryAttempts(boolean throwAfterMaxRetryAttempts) {
            this.throwAfterMaxRetryAttempts = throwAfterMaxRetryAttempts;
            return this;
        }

        public Builder defaultBuilder() {
            this.httpClient = HttpClient.newHttpClient();
            this.objectMapper = new ObjectMapper();
            this.timeout = DEFAULT_REQUEST_TIMEOUT;
            return this;
        }

        public ChainTestApiClient build() {
            return new ChainTestApiClient(this);
        }
    }
}

