/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation.behaviour;

import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.View;
import android.view.animation.Interpolator;
import com.ashokvarma.bottomnavigation.BottomNavigationBar;
import com.ashokvarma.bottomnavigation.behaviour.VerticalScrollingBehavior;
import java.lang.ref.WeakReference;
import java.util.List;

public class BottomVerticalScrollBehavior<V extends View>
extends VerticalScrollingBehavior<V> {
    private static final Interpolator INTERPOLATOR = new FastOutSlowInInterpolator();
    private int mBottomNavHeight;
    private WeakReference<BottomNavigationBar> mViewRef;

    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        parent.onLayoutChild(child, layoutDirection);
        if (child instanceof BottomNavigationBar) {
            this.mViewRef = new WeakReference<BottomNavigationBar>((BottomNavigationBar)((Object)child));
        }
        child.post(new Runnable((View)child){
            final /* synthetic */ View val$child;
            {
                this.val$child = view;
            }

            @Override
            public void run() {
                BottomVerticalScrollBehavior.this.mBottomNavHeight = this.val$child.getHeight();
            }
        });
        this.updateSnackBarPosition(parent, child, (View)this.getSnackBarInstance(parent, child));
        return super.onLayoutChild(parent, child, layoutDirection);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
        return this.isDependent(dependency) || super.layoutDependsOn(parent, child, dependency);
    }

    private boolean isDependent(View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
        if (this.isDependent(dependency)) {
            this.updateSnackBarPosition(parent, child, dependency);
            return false;
        }
        return super.onDependentViewChanged(parent, child, dependency);
    }

    private void updateSnackBarPosition(CoordinatorLayout parent, V child, View dependency) {
        this.updateSnackBarPosition(parent, child, dependency, ViewCompat.getTranslationY(child) - (float)child.getHeight());
    }

    private void updateSnackBarPosition(CoordinatorLayout parent, V child, View dependency, float translationY) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            ViewCompat.animate((View)dependency).setInterpolator(INTERPOLATOR).setDuration(80L).setStartDelay(0L).translationY(translationY).start();
        }
    }

    private Snackbar.SnackbarLayout getSnackBarInstance(CoordinatorLayout parent, V child) {
        List dependencies = parent.getDependencies(child);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout)) continue;
            return (Snackbar.SnackbarLayout)view;
        }
        return null;
    }

    @Override
    public void onNestedVerticalScrollUnconsumed(CoordinatorLayout coordinatorLayout, V child, int scrollDirection, int currentOverScroll, int totalScroll) {
    }

    @Override
    public void onNestedVerticalPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, boolean consumed, int scrollDirection) {
        return consumed;
    }

    @Override
    public void onNestedVerticalScrollConsumed(CoordinatorLayout coordinatorLayout, V child, int scrollDirection, int currentOverScroll, int totalConsumedScroll) {
        this.handleDirection(coordinatorLayout, child, scrollDirection);
    }

    private void handleDirection(CoordinatorLayout parent, V child, int scrollDirection) {
        BottomNavigationBar bottomNavigationBar = (BottomNavigationBar)((Object)this.mViewRef.get());
        if (bottomNavigationBar != null && bottomNavigationBar.isAutoHideEnabled()) {
            if (scrollDirection == -1 && bottomNavigationBar.isHidden()) {
                this.updateSnackBarPosition(parent, child, (View)this.getSnackBarInstance(parent, child), -this.mBottomNavHeight);
                bottomNavigationBar.show();
            } else if (scrollDirection == 1 && !bottomNavigationBar.isHidden()) {
                this.updateSnackBarPosition(parent, child, (View)this.getSnackBarInstance(parent, child), 0.0f);
                bottomNavigationBar.hide();
            }
        }
    }
}

