/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.ashokvarma.bottomnavigation.BottomNavigationTab;
import com.ashokvarma.bottomnavigation.R;

class ShiftingBottomNavigationTab
extends BottomNavigationTab {
    public ShiftingBottomNavigationTab(Context context) {
        super(context);
    }

    public ShiftingBottomNavigationTab(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ShiftingBottomNavigationTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ShiftingBottomNavigationTab(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    void init() {
        this.paddingTopActive = (int)this.getResources().getDimension(R.dimen.shifting_height_top_padding_active);
        this.paddingTopInActive = (int)this.getResources().getDimension(R.dimen.shifting_height_top_padding_inactive);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View view = inflater.inflate(R.layout.shifting_bottom_navigation_item, (ViewGroup)this, true);
        this.containerView = view.findViewById(R.id.shifting_bottom_navigation_container);
        this.labelView = (TextView)view.findViewById(R.id.shifting_bottom_navigation_title);
        this.iconView = (ImageView)view.findViewById(R.id.shifting_bottom_navigation_icon);
        this.textBadgeView = (TextView)view.findViewById(R.id.shifting_bottom_navigation_badge);
        this.shapeBadgeView = (FrameLayout)view.findViewById(R.id.ll_badge_container);
        super.init();
    }

    @Override
    public void select(boolean setActiveColor, int animationDuration) {
        super.select(setActiveColor, animationDuration);
        ResizeWidthAnimation anim = new ResizeWidthAnimation((View)this, this.mActiveWidth);
        anim.setDuration(animationDuration);
        this.startAnimation(anim);
        this.labelView.animate().scaleY(1.0f).scaleX(1.0f).setDuration((long)animationDuration).start();
    }

    @Override
    public void unSelect(boolean setActiveColor, int animationDuration) {
        super.unSelect(setActiveColor, animationDuration);
        ResizeWidthAnimation anim = new ResizeWidthAnimation((View)this, this.mInActiveWidth);
        anim.setDuration(animationDuration);
        this.startAnimation(anim);
        this.labelView.animate().scaleY(0.0f).scaleX(0.0f).setDuration(0L).start();
    }

    public class ResizeWidthAnimation
    extends Animation {
        private int mWidth;
        private int mStartWidth;
        private View mView;

        public ResizeWidthAnimation(View view, int width) {
            this.mView = view;
            this.mWidth = width;
            this.mStartWidth = view.getWidth();
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            this.mView.getLayoutParams().width = this.mStartWidth + (int)((float)(this.mWidth - this.mStartWidth) * interpolatedTime);
            this.mView.requestLayout();
        }

        public boolean willChangeBounds() {
            return true;
        }
    }
}

