/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import java.lang.ref.WeakReference;

public class ShapeBadgeItem {
    private int mBackgroundColorResource;
    private String mBackgroundColorCode;
    private int mBackgroundColor = -65536;
    public static int CIRCLE = 100;
    public static int SQUARE = 101;
    private int mTextColor = -1;
    private int mBorderColorResource;
    private String mBorderColorCode;
    private int mBorderColor = -1;
    private int mBorderWidth = 0;
    private int mGravity = 8388661;
    private boolean mHideOnSelect;
    private boolean mIsHidden = false;
    private int mAnimationDuration = 200;
    private int mDimen;
    private Drawable mBadgeBackground;
    private int shape;
    private int[] marginArr;
    WeakReference<FrameLayout> mFrameLayout;

    public ShapeBadgeItem setBackgroundColorResource(@ColorRes int colorResource) {
        this.mBackgroundColorResource = colorResource;
        return this;
    }

    public Drawable getBadgeBackground() {
        return this.mBadgeBackground;
    }

    public ShapeBadgeItem setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        return this;
    }

    public ShapeBadgeItem setHideOnSelect(boolean hideOnSelect) {
        this.mHideOnSelect = hideOnSelect;
        return this;
    }

    public ShapeBadgeItem setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        return this;
    }

    protected int getBackgroundColor(Context context) {
        if (this.mBackgroundColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mBackgroundColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBackgroundColorCode)) {
            return Color.parseColor((String)this.mBackgroundColorCode);
        }
        return this.mBackgroundColor;
    }

    protected int getBorderColor(Context context) {
        if (this.mBorderColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mBorderColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBorderColorCode)) {
            return Color.parseColor((String)this.mBorderColorCode);
        }
        return this.mBorderColor;
    }

    protected int getBorderWidth() {
        return this.mBorderWidth;
    }

    protected int getGravity() {
        return this.mGravity;
    }

    protected boolean isHideOnSelect() {
        return this.mHideOnSelect;
    }

    private boolean isWeakReferenceValid() {
        return this.mFrameLayout != null && this.mFrameLayout.get() != null;
    }

    void select() {
        if (this.mHideOnSelect) {
            this.hide(true);
        }
    }

    void unSelect() {
        if (this.mHideOnSelect) {
            this.show(true);
        }
    }

    public ShapeBadgeItem toggle() {
        return this.toggle(true);
    }

    public ShapeBadgeItem toggle(boolean animate) {
        if (this.mIsHidden) {
            return this.show(animate);
        }
        return this.hide(animate);
    }

    public ShapeBadgeItem show() {
        return this.show(true);
    }

    public ShapeBadgeItem show(boolean animate) {
        this.mIsHidden = false;
        if (this.isWeakReferenceValid()) {
            FrameLayout frameLayout = (FrameLayout)this.mFrameLayout.get();
            if (animate) {
                frameLayout.setScaleX(0.0f);
                frameLayout.setScaleY(0.0f);
                frameLayout.setVisibility(0);
                ViewPropertyAnimatorCompat animatorCompat = ViewCompat.animate((View)frameLayout);
                animatorCompat.cancel();
                animatorCompat.setDuration((long)this.mAnimationDuration);
                animatorCompat.scaleX(1.0f).scaleY(1.0f);
                animatorCompat.setListener(null);
                animatorCompat.start();
            } else {
                frameLayout.setScaleX(1.0f);
                frameLayout.setScaleY(1.0f);
                frameLayout.setVisibility(0);
            }
        }
        return this;
    }

    public ShapeBadgeItem hide() {
        return this.hide(true);
    }

    protected ShapeBadgeItem setFrameLayout(FrameLayout mFrameLayout) {
        this.mFrameLayout = new WeakReference<FrameLayout>(mFrameLayout);
        return this;
    }

    public ShapeBadgeItem hide(boolean animate) {
        this.mIsHidden = true;
        if (this.isWeakReferenceValid()) {
            FrameLayout textView = (FrameLayout)this.mFrameLayout.get();
            if (animate) {
                ViewPropertyAnimatorCompat animatorCompat = ViewCompat.animate((View)textView);
                animatorCompat.cancel();
                animatorCompat.setDuration((long)this.mAnimationDuration);
                animatorCompat.scaleX(0.0f).scaleY(0.0f);
                animatorCompat.setListener(new ViewPropertyAnimatorListener(){

                    public void onAnimationStart(View view) {
                    }

                    public void onAnimationEnd(View view) {
                        view.setVisibility(8);
                    }

                    public void onAnimationCancel(View view) {
                        view.setVisibility(8);
                    }
                });
                animatorCompat.start();
            } else {
                textView.setVisibility(8);
            }
        }
        return this;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public ShapeBadgeItem setDimen(int radius) {
        this.mDimen = radius;
        return this;
    }

    public int getDimen() {
        return this.mDimen;
    }

    public int getShape() {
        return this.shape;
    }

    public ShapeBadgeItem setShape(int shape) {
        this.shape = shape;
        return this;
    }

    public ShapeBadgeItem setMargins(int l, int t, int r, int b) {
        this.marginArr = new int[]{l, t, r, b};
        return this;
    }

    public int[] getMargins() {
        return this.marginArr;
    }
}

