/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.ashokvarma.bottomnavigation.BadgeItem;
import com.ashokvarma.bottomnavigation.BottomNavigationBar;
import com.ashokvarma.bottomnavigation.BottomNavigationItem;
import com.ashokvarma.bottomnavigation.BottomNavigationTab;
import com.ashokvarma.bottomnavigation.R;
import com.ashokvarma.bottomnavigation.ShapeBadgeItem;
import com.ashokvarma.bottomnavigation.utils.Utils;

class BottomNavigationHelper {
    private BottomNavigationHelper() {
    }

    public static int[] getMeasurementsForFixedMode(Context context, int screenWidth, int noOfTabs, boolean scrollable) {
        int[] result = new int[2];
        int minWidth = (int)context.getResources().getDimension(R.dimen.fixed_min_width_small_views);
        int maxWidth = (int)context.getResources().getDimension(R.dimen.fixed_min_width);
        int itemWidth = screenWidth / noOfTabs;
        if (itemWidth < minWidth && scrollable) {
            itemWidth = (int)context.getResources().getDimension(R.dimen.fixed_min_width);
        } else if (itemWidth > maxWidth) {
            itemWidth = maxWidth;
        }
        result[0] = itemWidth;
        return result;
    }

    public static int[] getMeasurementsForShiftingMode(Context context, int screenWidth, int noOfTabs, boolean scrollable) {
        int itemActiveWidth;
        int itemWidth;
        int[] result = new int[2];
        int minWidth = (int)context.getResources().getDimension(R.dimen.shifting_min_width_inactive);
        int maxWidth = (int)context.getResources().getDimension(R.dimen.shifting_max_width_inactive);
        double minPossibleWidth = (double)minWidth * ((double)noOfTabs + 0.5);
        double maxPossibleWidth = (double)maxWidth * ((double)noOfTabs + 0.75);
        if ((double)screenWidth < minPossibleWidth) {
            if (scrollable) {
                itemWidth = minWidth;
                itemActiveWidth = (int)((double)minWidth * 1.5);
            } else {
                itemWidth = (int)((double)screenWidth / ((double)noOfTabs + 0.5));
                itemActiveWidth = (int)((double)itemWidth * 1.5);
            }
        } else if ((double)screenWidth > maxPossibleWidth) {
            itemWidth = maxWidth;
            itemActiveWidth = (int)((double)itemWidth * 1.75);
        } else {
            double minPossibleWidth1 = (double)minWidth * ((double)noOfTabs + 0.625);
            double minPossibleWidth2 = (double)minWidth * ((double)noOfTabs + 0.75);
            itemWidth = (int)((double)screenWidth / ((double)noOfTabs + 0.5));
            itemActiveWidth = (int)((double)itemWidth * 1.5);
            if ((double)screenWidth > minPossibleWidth1) {
                itemWidth = (int)((double)screenWidth / ((double)noOfTabs + 0.625));
                itemActiveWidth = (int)((double)itemWidth * 1.625);
                if ((double)screenWidth > minPossibleWidth2) {
                    itemWidth = (int)((double)screenWidth / ((double)noOfTabs + 0.75));
                    itemActiveWidth = (int)((double)itemWidth * 1.75);
                }
            }
        }
        result[0] = itemWidth;
        result[1] = itemActiveWidth;
        return result;
    }

    public static void bindTabWithData(BottomNavigationItem bottomNavigationItem, BottomNavigationTab bottomNavigationTab, BottomNavigationBar bottomNavigationBar) {
        Drawable inactiveDrawable;
        Context context = bottomNavigationBar.getContext();
        if (TextUtils.isEmpty((CharSequence)bottomNavigationItem.getTitle(context))) {
            bottomNavigationTab.setLabelVisibility(8);
        } else {
            bottomNavigationTab.setLabel(bottomNavigationItem.getTitle(context));
        }
        bottomNavigationTab.setIcon(bottomNavigationItem.getIcon(context));
        int activeColor = bottomNavigationItem.getActiveColor(context);
        int inActiveColor = bottomNavigationItem.getInActiveColor(context);
        if (activeColor != 0) {
            bottomNavigationTab.setActiveColor(activeColor);
        } else {
            bottomNavigationTab.setActiveColor(bottomNavigationBar.getActiveColor());
        }
        if (inActiveColor != 0) {
            bottomNavigationTab.setInactiveColor(inActiveColor);
        } else {
            bottomNavigationTab.setInactiveColor(bottomNavigationBar.getInActiveColor());
        }
        if (bottomNavigationItem.isInActiveIconAvailable() && (inactiveDrawable = bottomNavigationItem.getInactiveIcon(context)) != null) {
            bottomNavigationTab.setInactiveIcon(inactiveDrawable);
        }
        bottomNavigationTab.setItemBackgroundColor(bottomNavigationBar.getBackgroundColor());
        if (bottomNavigationItem.getTextBadgeItem() != null) {
            BottomNavigationHelper.setTextBadgeForTab(bottomNavigationItem.getTextBadgeItem(), bottomNavigationTab);
        } else if (bottomNavigationItem.getShapeBadgeItem() != null) {
            BottomNavigationHelper.setShapeBadgeForTab(bottomNavigationItem.getShapeBadgeItem(), bottomNavigationTab);
        }
    }

    private static void setShapeBadgeForTab(ShapeBadgeItem shapeBadgeItem, BottomNavigationTab bottomNavigationTab) {
        if (shapeBadgeItem != null) {
            Context context = bottomNavigationTab.getContext();
            int radius = Utils.dp2px(context, shapeBadgeItem.getDimen());
            if (shapeBadgeItem.getShape() == ShapeBadgeItem.CIRCLE) {
                bottomNavigationTab.shapeBadgeView.setBackgroundDrawable(context.getResources().getDrawable(R.drawable.shape_circle));
            } else if (shapeBadgeItem.getShape() == ShapeBadgeItem.SQUARE) {
                bottomNavigationTab.shapeBadgeView.setBackgroundDrawable(context.getResources().getDrawable(R.drawable.shape_rect));
            } else {
                bottomNavigationTab.shapeBadgeView.setBackgroundDrawable(shapeBadgeItem.getBadgeBackground());
            }
            shapeBadgeItem.setFrameLayout(bottomNavigationTab.shapeBadgeView);
            bottomNavigationTab.setShapeBadgeItem(shapeBadgeItem);
            GradientDrawable bgShape = (GradientDrawable)bottomNavigationTab.shapeBadgeView.getBackground();
            bgShape.setColor(shapeBadgeItem.getBackgroundColor(context));
            if (shapeBadgeItem.getMargins() != null) {
                int left = Utils.dp2px(context, shapeBadgeItem.getMargins()[0]);
                int top = Utils.dp2px(context, shapeBadgeItem.getMargins()[1]);
                int right = Utils.dp2px(context, shapeBadgeItem.getMargins()[2]);
                int bottom = Utils.dp2px(context, shapeBadgeItem.getMargins()[3]);
                FrameLayout.LayoutParams fl = new FrameLayout.LayoutParams(radius, radius, shapeBadgeItem.getGravity());
                fl.setMargins(left, top, right, bottom);
                bottomNavigationTab.shapeBadgeView.setLayoutParams((ViewGroup.LayoutParams)fl);
            }
            if (shapeBadgeItem.isHidden()) {
                shapeBadgeItem.hide();
            }
        }
    }

    private static void setTextBadgeForTab(BadgeItem badgeItem, BottomNavigationTab bottomNavigationTab) {
        if (badgeItem != null) {
            Context context = bottomNavigationTab.getContext();
            GradientDrawable shape = BottomNavigationHelper.getBadgeDrawable(badgeItem, context);
            bottomNavigationTab.textBadgeView.setBackgroundDrawable((Drawable)shape);
            bottomNavigationTab.setBadgeItem(badgeItem);
            badgeItem.setTextView(bottomNavigationTab.textBadgeView);
            bottomNavigationTab.textBadgeView.setVisibility(0);
            bottomNavigationTab.textBadgeView.setTextColor(badgeItem.getTextColor(context));
            bottomNavigationTab.textBadgeView.setText(badgeItem.getText());
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)bottomNavigationTab.textBadgeView.getLayoutParams();
            layoutParams.gravity = badgeItem.getGravity();
            bottomNavigationTab.textBadgeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (badgeItem.isHidden()) {
                badgeItem.hide();
            }
        }
    }

    static GradientDrawable getBadgeDrawable(BadgeItem badgeItem, Context context) {
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(0);
        shape.setCornerRadius((float)context.getResources().getDimensionPixelSize(R.dimen.badge_corner_radius));
        shape.setColor(badgeItem.getBackgroundColor(context));
        shape.setStroke(badgeItem.getBorderWidth(), badgeItem.getBorderColor(context));
        return shape;
    }

    static GradientDrawable getShapeBadgeDrawable(ShapeBadgeItem badgeItem, Context context) {
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(0);
        shape.setColor(badgeItem.getBackgroundColor(context));
        shape.setStroke(badgeItem.getBorderWidth(), badgeItem.getBorderColor(context));
        return shape;
    }

    public static void setBackgroundWithRipple(View clickedView, final View backgroundView, final View bgOverlay, final int newColor, int animationDuration) {
        Animator circularReveal;
        int centerX = (int)(clickedView.getX() + (float)(clickedView.getMeasuredWidth() / 2));
        int centerY = clickedView.getMeasuredHeight() / 2;
        int finalRadius = backgroundView.getWidth();
        backgroundView.clearAnimation();
        bgOverlay.clearAnimation();
        if (Build.VERSION.SDK_INT >= 21) {
            circularReveal = ViewAnimationUtils.createCircularReveal((View)bgOverlay, (int)centerX, (int)centerY, (float)0.0f, (float)finalRadius);
        } else {
            bgOverlay.setAlpha(0.0f);
            circularReveal = ObjectAnimator.ofFloat((Object)bgOverlay, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        }
        circularReveal.setDuration((long)animationDuration);
        circularReveal.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                this.onCancel();
            }

            public void onAnimationCancel(Animator animation) {
                this.onCancel();
            }

            private void onCancel() {
                backgroundView.setBackgroundColor(newColor);
                bgOverlay.setVisibility(8);
            }
        });
        bgOverlay.setBackgroundColor(newColor);
        bgOverlay.setVisibility(0);
        circularReveal.start();
    }
}

