/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.mutators;

import com.groupcdg.arcmutate.spring.mutators.AnnotationMutator;
import org.pitest.bytecode.ASMVersion;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.AnnotationVisitor;
import org.pitest.reloc.asm.MethodVisitor;

class RemoveParameterAnnotationVisitor
extends MethodVisitor {
    private final AnnotationMutator factory;
    private final MutationContext context;
    private final Location location;

    public RemoveParameterAnnotationVisitor(AnnotationMutator factory, Location location, MutationContext context, MethodVisitor delegateMethodVisitor) {
        super(ASMVersion.asmVersion(), delegateMethodVisitor);
        this.factory = factory;
        this.location = location;
        this.context = context;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        ClassName annotationType = this.parseType(descriptor);
        if (this.factory.canMutate(annotationType)) {
            MutationIdentifier newId = this.factory.idEncoder().encodeForMethod(this.location, annotationType);
            this.context.registerMutation(newId, "Removed annotation " + this.factory.describeAnnotation(descriptor));
            if (this.context.shouldMutate(newId)) {
                return null;
            }
        }
        return this.mv.visitAnnotation(descriptor, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        ClassName annotationType = this.parseType(descriptor);
        if (this.factory.canMutate(annotationType)) {
            MutationIdentifier newId = this.factory.idEncoder().encodeForParameter(this.location, parameter, annotationType);
            this.context.registerMutation(newId, "Removed annotation " + this.factory.describeAnnotation(descriptor) + " from parameter " + (parameter + 1));
            if (this.context.shouldMutate(newId)) {
                return null;
            }
        }
        return this.mv.visitParameterAnnotation(parameter, descriptor, visible);
    }

    private ClassName parseType(String descriptor) {
        return ClassName.fromString((String)descriptor.substring(1).substring(0, descriptor.length() - 2));
    }
}

