/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.mutators;

import java.util.Collection;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

class AbstractAnnotationFilter
implements MutationInterceptor {
    private ClassTree currentClass;

    AbstractAnnotationFilter() {
    }

    public InterceptorType type() {
        return InterceptorType.PRE_SCAN_FILTER;
    }

    public void begin(ClassTree classTree) {
        this.currentClass = classTree;
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater mutater) {
        return mutations.stream().filter(m -> !this.isAbstract((MutationDetails)m)).collect(Collectors.toList());
    }

    private boolean isAbstract(MutationDetails mutationDetails) {
        if (!mutationDetails.getId().getMutator().startsWith("com.groupcdg.arcmutate.spring")) {
            return false;
        }
        Location loc = mutationDetails.getId().getLocation();
        return this.currentClass.method(loc).map(m -> (m.rawNode().access & 0x400) != 0).orElse(true);
    }

    public void end() {
        this.currentClass = null;
    }
}

