/*
 * Decompiled with CFR 0.152.
 */
package com.arcmutate.licence;

import com.arcmutate.licence.Licence;
import com.arcmutate.licence.LicenceType;
import java.time.Clock;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import org.pitest.mutationtest.verify.BuildMessage;
import org.pitest.mutationtest.verify.BuildVerifier;

public class LicenceVerifier
implements BuildVerifier {
    private final Clock clock;
    private final Licence licence;

    public LicenceVerifier(Clock clock, Licence licence) {
        this.clock = clock;
        this.licence = licence;
    }

    public List<BuildMessage> verifyBuild() {
        long days = ChronoUnit.DAYS.between(LocalDate.now(this.clock), this.licence.expires());
        if (days < 0L) {
            return Collections.singletonList(new BuildMessage("Warning - arcmutate licence has expired.", "https://www.arcmutate.com", 0));
        }
        if (days <= 7L) {
            return Collections.singletonList(new BuildMessage("Warning - arcmutate licence expires in " + days + " days.", "https://www.arcmutate.com", 0));
        }
        return this.standardMessage();
    }

    private List<BuildMessage> standardMessage() {
        String message = "Arcmutate licence valid until " + this.licence.expires() + " (yyyy/mm/dd)";
        if (this.licence.users().isPresent()) {
            message = message + " for up to " + this.licence.users().getAsInt() + " users";
        }
        if (this.licence.type().equals((Object)LicenceType.EVALUATION)) {
            message = message + " (evaluation use only)";
        }
        if (this.licence.type().equals((Object)LicenceType.OSSS)) {
            message = message + " (non-commercial use only)";
        }
        return Collections.singletonList(new BuildMessage(message, "https://www.arcmutate.com", 0));
    }
}

