/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.Profiler;
import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicatedDatabase;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.AbstractServerHttpHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityUser;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;

public class GetServerHandler
extends AbstractServerHttpHandler {
    public GetServerHandler(HttpServer httpServer) {
        super(httpServer);
    }

    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user, JSONObject payload) {
        JSONObject response = this.createResult(user, null);
        String mode = this.getQueryParameter(exchange, "mode", "default");
        if (!"basic".equals(mode)) {
            if ("default".equals(mode)) {
                this.exportMetrics(response);
                this.exportSettings(response);
            } else if ("cluster".equals(mode)) {
                this.exportCluster(exchange, response);
            }
        }
        Metrics.counter((String)"http.server-info", (String[])new String[0]).increment();
        return new ExecutionResponse(200, response.toString());
    }

    private void exportCluster(HttpServerExchange exchange, JSONObject response) {
        HAServer ha = this.httpServer.getServer().getHA();
        if (ha != null) {
            JSONObject haJSON = new JSONObject();
            response.put("ha", (Object)haJSON);
            haJSON.put("clusterName", ha.getClusterName());
            haJSON.put("leader", ha.getLeaderName());
            haJSON.put("electionStatus", ha.getElectionStatus().toString());
            haJSON.put("network", (Object)ha.getStats());
            if (!ha.isLeader()) {
                HttpURLConnection connection;
                try {
                    connection = (HttpURLConnection)new URL("http://" + ha.getLeader().getRemoteHTTPAddress() + "/api/v1/server?mode=cluster").openConnection();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Authorization", exchange.getRequestHeaders().get("Authorization").getFirst());
                    connection.connect();
                    JSONObject leaderResponse = new JSONObject(this.readResponse(connection));
                    JSONObject network = leaderResponse.getJSONObject("ha").getJSONObject("network");
                    haJSON.getJSONObject("network").put("replicas", (Object)network.getJSONArray("replicas"));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    connection.disconnect();
                }
            }
            JSONArray databases = new JSONArray();
            for (String dbName : this.httpServer.getServer().getDatabaseNames()) {
                ServerDatabase db = this.httpServer.getServer().getDatabase(dbName);
                ReplicatedDatabase rdb = (ReplicatedDatabase)db.getWrappedDatabaseInstance();
                JSONObject databaseJSON = new JSONObject();
                databaseJSON.put("name", rdb.getName());
                databaseJSON.put("quorum", (Object)rdb.getQuorum());
                databases.put(databaseJSON);
            }
            haJSON.put("databases", (Object)databases);
            String leaderServer = ha.isLeader() ? ha.getServer().getHttpServer().getListeningAddress() : ha.getLeader().getRemoteHTTPAddress();
            String replicaServers = ha.getReplicaServersHTTPAddressesList();
            haJSON.put("leaderAddress", leaderServer);
            haJSON.put("replicaAddresses", replicaServers);
            LogManager.instance().log((Object)this, Level.FINE, "Returning configuration leaderServer=%s replicaServers=[%s]", (Object)leaderServer, (Object)replicaServers);
        }
    }

    private void exportMetrics(JSONObject response) {
        JSONObject metricsJSON = new JSONObject();
        response.put("metrics", (Object)metricsJSON);
        metricsJSON.put("profiler", (Object)Profiler.INSTANCE.toJSON());
        JSONObject metersJSON = new JSONObject();
        metricsJSON.put("meters", (Object)metersJSON);
        CompositeMeterRegistry registry = Metrics.globalRegistry;
        registry.getMeters().stream().filter(meter -> meter.getId().getName().startsWith("http.")).forEach(meter -> metersJSON.put(meter.getId().getName(), (Object)new JSONObject().put("count", (Number)((Measurement)meter.measure().iterator().next()).getValue()).put("reqPerSecLastMinute", (Number)((Measurement)meter.measure().iterator().next()).getValue()).put("reqPerSecSinceLastTime", (Number)((Measurement)meter.measure().iterator().next()).getValue())));
        int serverEventsSummaryErrors = 0;
        int serverEventsSummaryWarnings = 0;
        int serverEventsSummaryInfo = 0;
        int serverEventsSummaryHints = 0;
        JSONArray events = this.httpServer.getServer().getEventLog().getCurrentEvents();
        block12: for (int i = 0; i < events.length(); ++i) {
            JSONObject event = events.getJSONObject(i);
            switch (event.getString("type")) {
                case "ERROR": {
                    ++serverEventsSummaryErrors;
                    continue block12;
                }
                case "WARNING": {
                    ++serverEventsSummaryWarnings;
                    continue block12;
                }
                case "INFO": {
                    ++serverEventsSummaryInfo;
                    continue block12;
                }
                case "HINT": {
                    ++serverEventsSummaryHints;
                }
            }
        }
        JSONObject eventsJSON = new JSONObject();
        eventsJSON.put("errors", (Number)serverEventsSummaryErrors);
        eventsJSON.put("warnings", (Number)serverEventsSummaryWarnings);
        eventsJSON.put("info", (Number)serverEventsSummaryInfo);
        eventsJSON.put("hints", (Number)serverEventsSummaryHints);
        metricsJSON.put("events", (Object)eventsJSON);
    }

    private void exportSettings(JSONObject response) {
        ContextConfiguration srvCfg = this.httpServer.getServer().getConfiguration();
        Set contextKeys = srvCfg.getContextKeys();
        ArrayList settings = new ArrayList();
        for (GlobalConfiguration cfg : GlobalConfiguration.values()) {
            if (cfg.getScope() == GlobalConfiguration.SCOPE.DATABASE) continue;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("key", cfg.getKey());
            map.put("value", this.convertValue(cfg.getKey(), cfg.getValue()));
            map.put("description", cfg.getDescription());
            map.put("overridden", contextKeys.contains(cfg.getKey()));
            map.put("default", this.convertValue(cfg.getKey(), cfg.getDefValue()));
            settings.add(map);
        }
        response.put("settings", settings);
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        InputStream in = connection.getInputStream();
        Scanner scanner = new Scanner(in);
        StringBuilder buffer = new StringBuilder();
        while (scanner.hasNext()) {
            buffer.append(scanner.next().replace('\n', ' '));
        }
        return buffer.toString();
    }

    private Object convertValue(String key, Object value) {
        if (key.toLowerCase(Locale.ENGLISH).contains("password")) {
            value = "*****";
        }
        if (key.equals("arcadedb.server.defaultDatabases")) {
            String defaultDatabases = (String)value;
            if (value != null && !defaultDatabases.isEmpty()) {
                String[] dbs;
                Object modified = "";
                for (String db : dbs = defaultDatabases.split(";")) {
                    String[] credentialPairs;
                    int credentialBegin = db.indexOf(91);
                    if (credentialBegin < 0) {
                        modified = (String)modified + db;
                        continue;
                    }
                    String dbName = db.substring(0, credentialBegin);
                    int credentialEnd = db.indexOf(93, credentialBegin);
                    String credentials = db.substring(credentialBegin + 1, credentialEnd);
                    for (String credential : credentialPairs = credentials.split(",")) {
                        String[] credentialParts = credential.split(":");
                        if (credentialParts.length >= 2) {
                            String userName = credentialParts[0];
                            modified = (String)modified + dbName + "[" + userName + ":*****]";
                            continue;
                        }
                        modified = (String)modified + dbName + "[" + String.valueOf(credentialParts) + "]";
                    }
                    modified = (String)modified + ";";
                }
                if (((String)modified).endsWith(";")) {
                    modified = ((String)modified).substring(0, ((String)modified).length() - 1);
                }
                value = modified;
            }
        }
        if (value instanceof Class) {
            Class class1 = (Class)value;
            value = class1.getName();
        }
        return value;
    }
}

