/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.Constants;
import com.arcadedb.database.Binary;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.AbstractServerHttpHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityUser;
import com.arcadedb.utility.FileUtils;
import io.micrometer.core.instrument.Metrics;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public class GetDynamicContentHandler
extends AbstractServerHttpHandler {
    public GetDynamicContentHandler(HttpServer httpServer) {
        super(httpServer);
    }

    @Override
    public boolean isRequireAuthentication() {
        return false;
    }

    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user, JSONObject payload) throws Exception {
        Object uri = exchange.getRequestURI();
        if (((String)uri).contains("..")) {
            return new ExecutionResponse(404, "Not Found");
        }
        if (((String)uri).isEmpty() || ((String)uri).equals("/")) {
            uri = "/index.html";
        }
        if (!((String)uri).contains(".")) {
            uri = (String)uri + ".html";
        }
        boolean processTemplate = true;
        String contentType = "plain/text";
        if (((String)uri).endsWith(".html") || ((String)uri).endsWith(".htm")) {
            contentType = "text/html";
        } else if (((String)uri).endsWith(".js")) {
            contentType = "text/javascript";
            processTemplate = false;
        } else if (((String)uri).endsWith(".json")) {
            contentType = "application/json";
            processTemplate = false;
        } else if (((String)uri).endsWith(".css")) {
            contentType = "text/css";
        } else if (((String)uri).endsWith(".svg")) {
            contentType = "image/svg+xml";
            processTemplate = false;
        } else if (((String)uri).endsWith(".ico")) {
            contentType = "image/x-icon";
            processTemplate = false;
        } else if (((String)uri).endsWith(".woff")) {
            contentType = "font/woff";
            processTemplate = false;
        } else if (((String)uri).endsWith(".woff2")) {
            contentType = "font/woff2";
            processTemplate = false;
        } else if (((String)uri).endsWith(".tff")) {
            contentType = "font/tff";
            processTemplate = false;
        } else {
            processTemplate = false;
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
        Metrics.counter((String)"http.static-content", (String[])new String[0]).increment();
        LogManager.instance().log((Object)this, Level.FINE, "Loading file %s ", (Object)("/static" + (String)uri));
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("static" + (String)uri);
        if (file == null) {
            return new ExecutionResponse(404, "Not Found");
        }
        Binary fileContent = FileUtils.readStreamAsBinary((InputStream)file);
        file.close();
        byte[] bytes = fileContent.toByteArray();
        if (processTemplate) {
            bytes = this.templating(exchange, new String(bytes, DatabaseFactory.getDefaultCharset()), new HashMap<String, Object>()).getBytes(DatabaseFactory.getDefaultCharset());
        }
        if (!processTemplate) {
            exchange.getResponseHeaders().put(Headers.CACHE_CONTROL, "max-age=86400");
        }
        return new ExecutionResponse(200, bytes);
    }

    protected String templating(HttpServerExchange exchange, String file, Map<String, Object> variables) throws IOException {
        int beginTokenPos = file.indexOf("${");
        if (beginTokenPos < 0) {
            return file;
        }
        StringBuilder buffer = new StringBuilder((int)((double)file.length() * 1.5));
        int pos = 0;
        while (pos < file.length() && beginTokenPos > -1) {
            buffer.append(file, pos, beginTokenPos);
            pos = beginTokenPos + "${".length();
            int endTokenPos = file.indexOf("}", pos);
            if (endTokenPos == -1) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Could not find end of token after position %d", (Object)beginTokenPos);
                return file;
            }
            String command = file.substring(pos, endTokenPos);
            if (command.startsWith("include:")) {
                InputStream fis;
                String include = file.substring(pos + "include:".length(), endTokenPos);
                int sep = include.indexOf(32);
                if (sep > -1) {
                    String[] parameterPairs;
                    String params = include.substring(sep).trim();
                    include = include.substring(0, sep);
                    for (String pair : parameterPairs = params.split(" ")) {
                        String[] kv = pair.split("=");
                        variables.put(kv[0].trim(), kv[1].trim());
                    }
                }
                if ((fis = this.getClass().getClassLoader().getResourceAsStream("static/" + include)) == null) {
                    LogManager.instance().log((Object)this, Level.WARNING, "Could not find file to include '%s' to include", (Object)include);
                    pos = endTokenPos + "}".length();
                    beginTokenPos = file.indexOf("${", pos);
                    continue;
                }
                byte[] includeBytes = FileUtils.readStreamAsBinary((InputStream)fis).toByteArray();
                includeBytes = this.templating(exchange, new String(includeBytes, DatabaseFactory.getDefaultCharset()), variables).getBytes(DatabaseFactory.getDefaultCharset());
                buffer.append(new String(includeBytes, DatabaseFactory.getDefaultCharset()));
            } else if (command.startsWith("var:")) {
                int assignmentPos = command.indexOf("=");
                if (assignmentPos < 0) {
                    variableName = command.substring("var:".length());
                    if (variableName.equalsIgnoreCase("swVersion")) {
                        buffer.append(Constants.getVersion());
                    } else if (variableName.equalsIgnoreCase("now")) {
                        buffer.append(System.currentTimeMillis());
                    } else if (variableName.equalsIgnoreCase("uuid")) {
                        buffer.append(UUID.randomUUID());
                    } else {
                        buffer.append(variables.get(variableName));
                    }
                } else {
                    variableName = command.substring("var:".length(), assignmentPos);
                    String variableValue = command.substring(assignmentPos + 1);
                    variables.put(variableName, variableValue);
                }
            } else if (command.startsWith("protectBegin:")) {
                String protect = file.substring(pos + "protectBegin:".length(), endTokenPos);
                pos = endTokenPos + "}".length();
                beginTokenPos = file.indexOf("${protectEnd", pos);
                endTokenPos = file.indexOf("}", beginTokenPos);
                Set currentUserRoles = exchange.getSecurityContext().getAuthenticatedAccount().getRoles();
                for (String role : protect.split(",")) {
                    if (!currentUserRoles.contains(role)) continue;
                    String subContent = file.substring(pos, beginTokenPos);
                    buffer.append(this.templating(exchange, subContent, variables));
                    break;
                }
            } else {
                buffer.append(file, beginTokenPos, endTokenPos + "}".length());
            }
            pos = endTokenPos + "}".length();
            beginTokenPos = file.indexOf("${", pos);
        }
        buffer.append(file.substring(pos));
        return buffer.toString();
    }
}

