/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http;

import com.arcadedb.database.TransactionContext;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.http.HttpSession;
import com.arcadedb.server.security.ServerSecurityUser;
import com.arcadedb.utility.RWLockContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;

public class HttpSessionManager
extends RWLockContext {
    public static final String ARCADEDB_SESSION_ID = "arcadedb-session-id";
    private final Map<String, HttpSession> sessions = new HashMap<String, HttpSession>();
    private final long transactionTimeoutInMs;
    private final Timer timer;

    public HttpSessionManager(long transactionTimeoutInMs) {
        this.transactionTimeoutInMs = transactionTimeoutInMs;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    int expired = HttpSessionManager.this.checkSessionsValidity();
                    if (expired > 0) {
                        LogManager.instance().log((Object)this, Level.FINE, "Removed %d expired sessions", null, (Object)expired);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, transactionTimeoutInMs, transactionTimeoutInMs);
    }

    public void close() {
        this.timer.cancel();
        for (Map.Entry<String, HttpSession> stringHttpSessionEntry : this.sessions.entrySet()) {
            stringHttpSessionEntry.getValue().cancel();
        }
        this.sessions.clear();
    }

    public int checkSessionsValidity() {
        if (this.sessions.isEmpty()) {
            return 0;
        }
        return (Integer)this.executeInWriteLock(() -> {
            int expired = 0;
            Iterator<Map.Entry<String, HttpSession>> it = this.sessions.entrySet().iterator();
            while (it.hasNext()) {
                HttpSession session = it.next().getValue();
                if (session.elapsedFromLastUpdate() <= this.transactionTimeoutInMs) continue;
                if (session.cancel()) {
                    LogManager.instance().log((Object)this, Level.FINE, "Canceling session %s because of timeout (%dms)", (Object)session.id, (Object)this.transactionTimeoutInMs);
                }
                it.remove();
                ++expired;
            }
            return expired;
        });
    }

    public HttpSession getSessionById(ServerSecurityUser user, String txId) {
        return (HttpSession)this.executeInReadLock(() -> this.sessions.get(txId));
    }

    public HttpSession createSession(ServerSecurityUser user, TransactionContext dbTx) {
        return (HttpSession)this.executeInWriteLock(() -> {
            String id = "AS-" + String.valueOf(UUID.randomUUID());
            HttpSession session = new HttpSession(user, id, dbTx);
            this.sessions.put(id, session);
            return session;
        });
    }

    public int getActiveSessions() {
        return this.sessions.size();
    }
}

