/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.Binary;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.network.binary.ServerIsNotTheLeaderException;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.Leader2ReplicaNetworkExecutor;
import com.arcadedb.server.ha.Replica2LeaderNetworkExecutor;
import com.arcadedb.server.ha.ReplicatedDatabase;
import com.arcadedb.server.ha.message.ServerShutdownRequest;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.AbstractServerHttpHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityException;
import com.arcadedb.server.security.ServerSecurityUser;
import com.arcadedb.utility.Callable;
import io.micrometer.core.instrument.Metrics;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.rmi.ServerException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class PostServerCommandHandler
extends AbstractServerHttpHandler {
    final String LIST_DATABASES = "list databases";
    final String SHUTDOWN = "shutdown";
    final String CREATE_DATABASE = "create database";
    final String DROP_DATABASE = "drop database";
    final String CLOSE_DATABASE = "close database";
    final String OPEN_DATABASE = "open database";
    final String CREATE_USER = "create user";
    final String DROP_USER = "drop user";
    final String CONNECT_CLUSTER = "connect cluster";
    final String DISCONNECT_CLUSTER = "disconnect cluster";
    final String SET_DATABASE_SETTING = "set database setting";
    final String SET_SERVER_SETTING = "set server setting";
    final String GET_SERVER_EVENTS = "get server events";
    final String ALIGN_DATABASE = "align database";

    public PostServerCommandHandler(HttpServer httpServer) {
        super(httpServer);
    }

    @Override
    protected boolean mustExecuteOnWorkerThread() {
        return true;
    }

    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user) throws IOException {
        String command;
        JSONObject payload = new JSONObject(this.parseRequestPayload(exchange));
        String string = command = payload.has("command") ? payload.getString("command").trim() : null;
        if (command == null) {
            return new ExecutionResponse(400, "{ \"error\" : \"Server command is null\"}");
        }
        JSONObject response = new JSONObject().put("result", "ok");
        String command_lc = command.toLowerCase(Locale.ENGLISH).trim();
        if (command_lc.equals("list databases")) {
            return this.listDatabases(user);
        }
        this.checkRootUser(user);
        if (command_lc.startsWith("shutdown")) {
            this.shutdownServer(this.extractTarget(command, "shutdown"));
        } else if (command_lc.startsWith("create database")) {
            this.createDatabase(this.extractTarget(command, "create database"));
        } else if (command_lc.startsWith("drop database")) {
            this.dropDatabase(this.extractTarget(command, "drop database"));
        } else if (command_lc.startsWith("close database")) {
            this.closeDatabase(this.extractTarget(command, "close database"));
        } else if (command_lc.startsWith("open database")) {
            this.openDatabase(this.extractTarget(command, "open database"));
        } else if (command_lc.startsWith("create user")) {
            this.createUser(this.extractTarget(command, "create user"));
        } else if (command_lc.startsWith("drop user")) {
            this.dropUser(this.extractTarget(command, "drop user"));
        } else if (command_lc.startsWith("connect cluster")) {
            if (!this.connectCluster(this.extractTarget(command, "connect cluster"), exchange)) {
                return null;
            }
        } else if (command_lc.equals("disconnect cluster")) {
            this.disconnectCluster();
        } else if (command_lc.startsWith("set database setting")) {
            this.setDatabaseSetting(this.extractTarget(command, "set database setting"));
        } else if (command_lc.startsWith("set server setting")) {
            this.setServerSetting(this.extractTarget(command, "set server setting"));
        } else if (command_lc.startsWith("get server events")) {
            response.put("result", this.getServerEvents(this.extractTarget(command, "get server events")));
        } else if (command_lc.startsWith("align database")) {
            this.alignDatabase(this.extractTarget(command, "align database"));
        } else {
            Metrics.counter((String)"http.server-command.invalid", (String[])new String[0]).increment();
            return new ExecutionResponse(400, "{ \"error\" : \"Server command not valid\"}");
        }
        return new ExecutionResponse(200, response.toString());
    }

    private String extractTarget(String command, String keyword) {
        int pos = command.indexOf(keyword);
        if (pos == -1) {
            return "";
        }
        return command.substring(pos + keyword.length()).trim();
    }

    private ExecutionResponse listDatabases(ServerSecurityUser user) {
        ArcadeDBServer server = this.httpServer.getServer();
        Metrics.counter((String)"http.list-databases", (String[])new String[0]).increment();
        HashSet<String> installedDatabases = new HashSet<String>(server.getDatabaseNames());
        Set<String> allowedDatabases = user.getAuthorizedDatabases();
        if (!allowedDatabases.contains("*")) {
            installedDatabases.retainAll(allowedDatabases);
        }
        JSONObject response = this.createResult(user, null).put("result", (Object)new JSONArray(installedDatabases));
        return new ExecutionResponse(200, response.toString());
    }

    private void shutdownServer(String serverName) throws IOException {
        Metrics.counter((String)"http.server-shutdown", (String[])new String[0]).increment();
        if (serverName.isEmpty()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    PostServerCommandHandler.this.httpServer.getServer().stop();
                    System.exit(0);
                }
            }, 1000L);
        } else {
            HAServer ha = this.getHA();
            Leader2ReplicaNetworkExecutor replica = ha.getReplica(serverName);
            if (replica == null) {
                throw new ServerException("Cannot contact server '" + serverName + "' from the current server");
            }
            Binary buffer = new Binary();
            ha.getMessageFactory().serializeCommand(new ServerShutdownRequest(), buffer, -1L);
            replica.sendMessage(buffer);
        }
    }

    private void createDatabase(String databaseName) {
        if (databaseName.isEmpty()) {
            throw new IllegalArgumentException("Database name empty");
        }
        this.checkServerIsLeaderIfInHA();
        ArcadeDBServer server = this.httpServer.getServer();
        Metrics.counter((String)"http.create-database", (String[])new String[0]).increment();
        ServerDatabase db = server.createDatabase(databaseName, ComponentFile.MODE.READ_WRITE);
        if (server.getConfiguration().getValueAsBoolean(GlobalConfiguration.HA_ENABLED)) {
            ReplicatedDatabase replicatedDatabase = (ReplicatedDatabase)db.getWrappedDatabaseInstance();
            replicatedDatabase.createInReplicas();
        }
    }

    private void dropDatabase(String databaseName) {
        if (databaseName.isEmpty()) {
            throw new IllegalArgumentException("Database name empty");
        }
        ServerDatabase database = this.httpServer.getServer().getDatabase(databaseName);
        Metrics.counter((String)"http.drop-database", (String[])new String[0]).increment();
        database.getEmbedded().drop();
        this.httpServer.getServer().removeDatabase(database.getName());
    }

    private void closeDatabase(String databaseName) {
        if (databaseName.isEmpty()) {
            throw new IllegalArgumentException("Database name empty");
        }
        ServerDatabase database = this.httpServer.getServer().getDatabase(databaseName);
        database.getEmbedded().close();
        Metrics.counter((String)"http.close-database", (String[])new String[0]).increment();
        this.httpServer.getServer().removeDatabase(database.getName());
    }

    private void openDatabase(String databaseName) {
        if (databaseName.isEmpty()) {
            throw new IllegalArgumentException("Database name empty");
        }
        this.httpServer.getServer().getDatabase(databaseName);
        Metrics.counter((String)"http.open-database", (String[])new String[0]).increment();
    }

    private void createUser(String payload) {
        JSONObject json = new JSONObject(payload);
        if (!json.has("name")) {
            throw new IllegalArgumentException("User name is null");
        }
        String userPassword = json.getString("password");
        if (userPassword.length() < 4) {
            throw new ServerSecurityException("User password must be 5 minimum characters");
        }
        if (userPassword.length() > 256) {
            throw new ServerSecurityException("User password cannot be longer than 256 characters");
        }
        json.put("password", this.httpServer.getServer().getSecurity().encodePassword(userPassword));
        Metrics.counter((String)"http.create-user", (String[])new String[0]).increment();
        this.httpServer.getServer().getSecurity().createUser(json);
    }

    private void dropUser(String userName) {
        if (userName.isEmpty()) {
            throw new IllegalArgumentException("User name was missing");
        }
        Metrics.counter((String)"http.drop-user", (String[])new String[0]).increment();
        boolean result = this.httpServer.getServer().getSecurity().dropUser(userName);
        if (!result) {
            throw new IllegalArgumentException("User '" + userName + "' not found on server");
        }
    }

    private boolean connectCluster(String serverAddress, HttpServerExchange exchange) {
        HAServer ha = this.getHA();
        Metrics.counter((String)"http.connect-cluster", (String[])new String[0]).increment();
        return ha.connectToLeader(serverAddress, (Callable<Void, Exception>)((Callable)exception -> {
            exchange.setStatusCode(500);
            exchange.getResponseSender().send("{ \"error\" : \"" + exception.getMessage() + "\"}");
            return null;
        }));
    }

    private void disconnectCluster() {
        Metrics.counter((String)"http.server-disconnect", (String[])new String[0]).increment();
        HAServer ha = this.getHA();
        Replica2LeaderNetworkExecutor leader = ha.getLeader();
        if (leader != null) {
            leader.close();
        } else {
            ha.disconnectAllReplicas();
        }
    }

    private void setDatabaseSetting(String triple) throws IOException {
        String tripleTrimmed = triple.trim();
        Integer firstSpace = tripleTrimmed.indexOf(" ");
        if (firstSpace == -1) {
            throw new IllegalArgumentException("Expected <database> <key> <value>");
        }
        String pairTrimmed = tripleTrimmed.substring(firstSpace).trim();
        Integer secondSpace = pairTrimmed.indexOf(" ");
        if (secondSpace == -1) {
            throw new IllegalArgumentException("Expected <database> <key> <value>");
        }
        String db = tripleTrimmed.substring(0, firstSpace);
        String key = pairTrimmed.substring(0, secondSpace);
        String value = pairTrimmed.substring(secondSpace);
        ServerDatabase database = this.httpServer.getServer().getDatabase(db);
        database.getConfiguration().setValue(key, (Object)value);
        database.saveConfiguration();
    }

    private void setServerSetting(String pair) {
        String pairTrimmed = pair.trim();
        Integer firstSpace = pairTrimmed.indexOf(" ");
        if (firstSpace == -1) {
            throw new IllegalArgumentException("Expected <key> <value>");
        }
        String key = pairTrimmed.substring(0, firstSpace);
        String value = pairTrimmed.substring(firstSpace);
        this.httpServer.getServer().getConfiguration().setValue(key, (Object)value);
    }

    private String getServerEvents(String fileName) {
        ArcadeDBServer server = this.httpServer.getServer();
        Metrics.counter((String)"http.get-server-events", (String[])new String[0]).increment();
        JSONArray events = fileName.isEmpty() ? server.getEventLog().getCurrentEvents() : server.getEventLog().getEvents(fileName);
        JSONArray files = server.getEventLog().getFiles();
        return "{ \"events\": " + String.valueOf(events) + ", \"files\": " + String.valueOf(files) + " }";
    }

    private void alignDatabase(String databaseName) {
        if (databaseName.isEmpty()) {
            throw new IllegalArgumentException("Database name empty");
        }
        ServerDatabase database = this.httpServer.getServer().getDatabase(databaseName);
        Metrics.counter((String)"http.align-database", (String[])new String[0]).increment();
        database.command("sql", "align database", new Object[0]);
    }

    private void checkServerIsLeaderIfInHA() {
        HAServer ha = this.httpServer.getServer().getHA();
        if (ha != null && !ha.isLeader()) {
            throw new ServerIsNotTheLeaderException("Creation of database can be executed only on the leader server", ha.getLeaderName());
        }
    }

    private HAServer getHA() {
        HAServer ha = this.httpServer.getServer().getHA();
        if (ha == null) {
            throw new CommandExecutionException("ArcadeDB is not running with High Availability module enabled. Please add this setting at startup: -Darcadedb.ha.enabled=true");
        }
        return ha;
    }
}

