/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.SocketFactory;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerException;
import com.arcadedb.server.ServerPlugin;
import com.arcadedb.server.http.HttpSessionManager;
import com.arcadedb.server.http.handler.GetDatabasesHandler;
import com.arcadedb.server.http.handler.GetDynamicContentHandler;
import com.arcadedb.server.http.handler.GetExistsDatabaseHandler;
import com.arcadedb.server.http.handler.GetQueryHandler;
import com.arcadedb.server.http.handler.GetReadyHandler;
import com.arcadedb.server.http.handler.GetServerHandler;
import com.arcadedb.server.http.handler.PostBeginHandler;
import com.arcadedb.server.http.handler.PostCommandHandler;
import com.arcadedb.server.http.handler.PostCommitHandler;
import com.arcadedb.server.http.handler.PostQueryHandler;
import com.arcadedb.server.http.handler.PostRollbackHandler;
import com.arcadedb.server.http.handler.PostServerCommandHandler;
import com.arcadedb.server.http.ssl.KeystoreType;
import com.arcadedb.server.http.ssl.SslUtils;
import com.arcadedb.server.http.ssl.TlsProtocol;
import com.arcadedb.server.http.ws.WebSocketConnectionHandler;
import com.arcadedb.server.http.ws.WebSocketEventBus;
import com.arcadedb.server.security.ServerSecurityException;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.PathHandler;
import java.io.IOException;
import java.net.BindException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.xnio.Options;

public class HttpServer
implements ServerPlugin {
    private final ArcadeDBServer server;
    private final HttpSessionManager sessionManager;
    private final WebSocketEventBus webSocketEventBus;
    private Undertow undertow;
    private volatile String listeningAddress;
    private int httpPortListening;

    public HttpServer(ArcadeDBServer server) {
        this.server = server;
        this.sessionManager = new HttpSessionManager((long)server.getConfiguration().getValueAsInteger(GlobalConfiguration.SERVER_HTTP_SESSION_EXPIRE_TIMEOUT) * 1000L);
        this.webSocketEventBus = new WebSocketEventBus(this.server);
    }

    @Override
    public void stopService() {
        this.webSocketEventBus.stop();
        if (this.undertow != null) {
            try {
                this.undertow.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sessionManager.close();
    }

    @Override
    public void startService() {
        ContextConfiguration configuration = this.server.getConfiguration();
        String host = configuration.getValueAsString(GlobalConfiguration.SERVER_HTTP_INCOMING_HOST);
        int[] httpPortRange = this.extractPortRange(configuration.getValue(GlobalConfiguration.SERVER_HTTP_INCOMING_PORT));
        int[] httpsPortRange = this.getHttpsPortRange(configuration);
        LogManager.instance().log((Object)this, Level.INFO, "- Starting HTTP Server (host=%s port=%s httpsPort=%s)...", (Object)host, (Object)httpPortRange, (Object)(httpsPortRange != null ? httpsPortRange : (int[])"-"));
        PathHandler routes = this.setupRoutes();
        int httpsPortListening = httpsPortRange != null ? httpsPortRange[0] : 0;
        this.httpPortListening = httpPortRange[0];
        while (this.httpPortListening <= httpPortRange[1]) {
            try {
                this.undertow = this.buildUndertowServer(configuration, host, routes, httpsPortListening);
                this.undertow.start();
                LogManager.instance().log((Object)this, Level.INFO, "- HTTP Server started (host=%s port=%d httpsPort=%s)", (Object)host, (Object)this.httpPortListening, httpsPortListening > 0 ? Integer.valueOf(httpsPortListening) : "-");
                this.listeningAddress = host.equals("0.0.0.0") ? this.server.getHostAddress() + ":" + this.httpPortListening : host + ":" + this.httpPortListening;
                return;
            }
            catch (Exception e) {
                this.handleServerStartException(e, httpsPortListening);
                ++this.httpPortListening;
            }
        }
        this.handleServerStartFailure(httpPortRange);
    }

    private int[] getHttpsPortRange(ContextConfiguration configuration) {
        Object configuredHTTPSPort = configuration.getValue(GlobalConfiguration.SERVER_HTTPS_INCOMING_PORT);
        return configuredHTTPSPort != null && !configuredHTTPSPort.toString().isEmpty() ? this.extractPortRange(configuredHTTPSPort) : null;
    }

    private PathHandler setupRoutes() {
        PathHandler routes = new PathHandler();
        RoutingHandler basicRoutes = Handlers.routing();
        routes.addPrefixPath("/ws", (HttpHandler)new WebSocketConnectionHandler(this, this.webSocketEventBus));
        routes.addPrefixPath("/api/v1", (HttpHandler)basicRoutes.post("/begin/{database}", (HttpHandler)new PostBeginHandler(this)).post("/command/{database}", (HttpHandler)new PostCommandHandler(this)).post("/commit/{database}", (HttpHandler)new PostCommitHandler(this)).get("/databases", (HttpHandler)new GetDatabasesHandler(this)).get("/exists/{database}", (HttpHandler)new GetExistsDatabaseHandler(this)).get("/query/{database}/{language}/{command}", (HttpHandler)new GetQueryHandler(this)).post("/query/{database}", (HttpHandler)new PostQueryHandler(this)).post("/rollback/{database}", (HttpHandler)new PostRollbackHandler(this)).get("/server", (HttpHandler)new GetServerHandler(this)).post("/server", (HttpHandler)new PostServerCommandHandler(this)).get("/ready", (HttpHandler)new GetReadyHandler(this)));
        if (!"production".equals(GlobalConfiguration.SERVER_MODE.getValueAsString())) {
            routes.addPrefixPath("/", (HttpHandler)Handlers.routing().setFallbackHandler((HttpHandler)new GetDynamicContentHandler(this)));
        }
        for (ServerPlugin plugin : this.server.getPlugins()) {
            plugin.registerAPI(this, routes);
        }
        return routes;
    }

    private Undertow buildUndertowServer(ContextConfiguration configuration, String host, PathHandler routes, int httpsPortListening) throws Exception {
        Undertow.Builder builder = Undertow.builder().setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).addHttpListener(this.httpPortListening, host).setHandler((HttpHandler)routes).setSocketOption(Options.READ_TIMEOUT, (Object)configuration.getValueAsInteger(GlobalConfiguration.NETWORK_SOCKET_TIMEOUT)).setIoThreads(configuration.getValueAsInteger(GlobalConfiguration.SERVER_HTTP_IO_THREADS)).setWorkerThreads(500).setServerOption(UndertowOptions.SHUTDOWN_TIMEOUT, (Object)5000);
        if (configuration.getValueAsBoolean(GlobalConfiguration.NETWORK_USE_SSL)) {
            SSLContext sslContext = this.createSSLContext();
            builder.addHttpsListener(httpsPortListening, host, sslContext).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
        }
        return builder.build();
    }

    private void handleServerStartException(Exception e, int httpsPortListening) {
        this.undertow = null;
        if (e.getCause() instanceof BindException) {
            LogManager.instance().log((Object)this, Level.WARNING, "- HTTP Port %s not available", (Object)this.httpPortListening);
            if (httpsPortListening > 0) {
                ++httpsPortListening;
            }
        } else {
            throw new ServerException("Error on starting HTTP Server", e);
        }
    }

    private void handleServerStartFailure(int[] httpPortRange) {
        this.httpPortListening = -1;
        String msg = "Unable to listen to a HTTP port in the configured port range %d - %d".formatted(httpPortRange[0], httpPortRange[1]);
        LogManager.instance().log((Object)this, Level.SEVERE, msg);
        throw new ServerException("Error on starting HTTP Server: " + msg);
    }

    private int[] extractPortRange(Object configuredPort) {
        int portFrom;
        int portTo;
        if (configuredPort instanceof Number) {
            Number number = (Number)configuredPort;
            portFrom = portTo = number.intValue();
        } else {
            String[] parts = configuredPort.toString().split("-");
            if (parts.length > 2) {
                throw new IllegalArgumentException("Invalid format for http server port range");
            }
            if (parts.length == 1) {
                portFrom = portTo = Integer.parseInt(parts[0]);
            } else {
                portFrom = Integer.parseInt(parts[0]);
                portTo = Integer.parseInt(parts[1]);
            }
        }
        return new int[]{portFrom, portTo};
    }

    public HttpSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public ArcadeDBServer getServer() {
        return this.server;
    }

    public String getListeningAddress() {
        return this.listeningAddress;
    }

    public int getPort() {
        return this.httpPortListening;
    }

    public WebSocketEventBus getWebSocketEventBus() {
        return this.webSocketEventBus;
    }

    private SSLContext createSSLContext() throws Exception {
        ContextConfiguration configuration = this.server.getConfiguration();
        String keystorePath = this.validateStoreProperty(configuration, GlobalConfiguration.NETWORK_SSL_KEYSTORE, "SSL key store path is empty");
        String keystorePassword = this.validateStoreProperty(configuration, GlobalConfiguration.NETWORK_SSL_KEYSTORE_PASSWORD, "SSL key store password is empty");
        String truststorePath = this.validateStoreProperty(configuration, GlobalConfiguration.NETWORK_SSL_TRUSTSTORE, "SSL trust store path is empty");
        String truststorePassword = this.validateStoreProperty(configuration, GlobalConfiguration.NETWORK_SSL_TRUSTSTORE_PASSWORD, "SSL trust store password is empty");
        KeyStore keyStore = this.configureSSLForKeystore(keystorePath, keystorePassword);
        KeyStore trustStore = this.configureSSLForTruststore(truststorePath, truststorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance(TlsProtocol.getLatestTlsVersion().getTlsVersion());
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private KeyStore configureSSLForKeystore(String keystorePath, String keystorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        return SslUtils.loadKeystoreFromStream(SocketFactory.getAsStream((String)keystorePath), keystorePassword, SslUtils.getDefaultKeystoreTypeForKeystore(() -> KeystoreType.PKCS12));
    }

    private KeyStore configureSSLForTruststore(String truststorePath, String truststorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        return SslUtils.loadKeystoreFromStream(SocketFactory.getAsStream((String)truststorePath), truststorePassword, SslUtils.getDefaultKeystoreTypeForTruststore(() -> KeystoreType.JKS));
    }

    private String validateStoreProperty(ContextConfiguration contextConfiguration, GlobalConfiguration configurationKey, String errorMessage) {
        String storePropertyValue = contextConfiguration.getValueAsString(configurationKey);
        if (storePropertyValue == null || storePropertyValue.isEmpty()) {
            throw new ServerSecurityException(errorMessage);
        }
        return storePropertyValue;
    }

    public boolean isConnected() {
        return this.undertow != null && this.listeningAddress != null;
    }
}

