/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.compression.CompressionFactory;
import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.RID;
import com.arcadedb.database.TransactionContext;
import com.arcadedb.database.TransactionIndexContext;
import com.arcadedb.engine.WALFile;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.index.Index;
import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.BinarySerializer;
import com.arcadedb.serializer.BinaryTypes;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.message.ErrorResponse;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.server.ha.message.TxForwardResponse;
import com.arcadedb.server.ha.message.TxRequestAbstract;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class TxForwardRequest
extends TxRequestAbstract {
    private int isolationLevelIndex;
    private int uniqueKeysUncompressedLength;
    private Binary uniqueKeysBuffer;

    public TxForwardRequest() {
    }

    public TxForwardRequest(DatabaseInternal database, Database.TRANSACTION_ISOLATION_LEVEL transactionIsolationLevel, Map<Integer, Integer> bucketRecordDelta, Binary bufferChanges, Map<String, TreeMap<TransactionIndexContext.ComparableKey, Map<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>>> keysTx) {
        super(database.getName(), bucketRecordDelta, bufferChanges);
        this.isolationLevelIndex = transactionIsolationLevel.ordinal();
        this.writeIndexKeysToBuffer(database, keysTx);
    }

    @Override
    public void toStream(Binary stream) {
        super.toStream(stream);
        stream.putByte((byte)this.isolationLevelIndex);
        stream.putInt(this.uniqueKeysUncompressedLength);
        stream.putBytes(this.uniqueKeysBuffer.getContent(), this.uniqueKeysBuffer.size());
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        super.fromStream(server, stream);
        this.isolationLevelIndex = stream.getByte();
        this.uniqueKeysUncompressedLength = stream.getInt();
        this.uniqueKeysBuffer = CompressionFactory.getDefault().decompress(new Binary(stream.getBytes()), this.uniqueKeysUncompressedLength);
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        ServerDatabase db = server.getServer().getDatabase(this.databaseName);
        if (!db.isOpen()) {
            throw new ReplicationException("Database '" + this.databaseName + "' is closed");
        }
        if (db.isTransactionActive()) {
            throw new ReplicationException("Transaction already begun in database '" + this.databaseName + "'");
        }
        try {
            WALFile.WALTransaction walTx = this.readTxFromBuffer();
            Map<String, TreeMap<TransactionIndexContext.ComparableKey, Map<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>>> keysTx = this.readIndexKeysFromBuffer(db);
            db.begin(Database.TRANSACTION_ISOLATION_LEVEL.values()[this.isolationLevelIndex]);
            TransactionContext tx = db.getTransaction();
            tx.commitFromReplica(walTx, keysTx, this.bucketRecordDelta);
            if (db.isTransactionActive()) {
                throw new ReplicationException("Error on committing transaction in database '" + this.databaseName + "': a nested transaction occurred");
            }
        }
        catch (NeedRetryException | TransactionException e) {
            return new ErrorResponse((Exception)e);
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error with the execution of the forwarded message %d", (Throwable)e, (Object)messageNumber);
            return new ErrorResponse(e);
        }
        return new TxForwardResponse();
    }

    public String toString() {
        return "tx-forward(" + this.databaseName + ")";
    }

    protected void writeIndexKeysToBuffer(DatabaseInternal database, Map<String, TreeMap<TransactionIndexContext.ComparableKey, Map<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>>> indexesChanges) {
        BinarySerializer serializer = database.getSerializer();
        this.uniqueKeysBuffer = new Binary();
        this.uniqueKeysBuffer.putUnsignedNumber((long)indexesChanges.size());
        for (Map.Entry<String, TreeMap<TransactionIndexContext.ComparableKey, Map<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>>> entry : indexesChanges.entrySet()) {
            this.uniqueKeysBuffer.putString(entry.getKey());
            Map indexChanges = entry.getValue();
            this.uniqueKeysBuffer.putUnsignedNumber((long)indexChanges.size());
            for (Map.Entry keyChange : indexChanges.entrySet()) {
                TransactionIndexContext.ComparableKey entryKey = (TransactionIndexContext.ComparableKey)keyChange.getKey();
                this.uniqueKeysBuffer.putUnsignedNumber((long)entryKey.values.length);
                for (int k = 0; k < entryKey.values.length; ++k) {
                    byte keyType = BinaryTypes.getTypeFromValue((Object)entryKey.values[k], null);
                    this.uniqueKeysBuffer.putByte(keyType);
                    serializer.serializeValue((Database)database, this.uniqueKeysBuffer, keyType, entryKey.values[k]);
                }
                Map entryValue = (Map)keyChange.getValue();
                this.uniqueKeysBuffer.putUnsignedNumber((long)entryValue.size());
                for (TransactionIndexContext.IndexKey key : entryValue.values()) {
                    this.uniqueKeysBuffer.putByte((byte)key.operation.ordinal());
                    this.uniqueKeysBuffer.putUnsignedNumber((long)key.rid.getBucketId());
                    this.uniqueKeysBuffer.putUnsignedNumber(key.rid.getPosition());
                }
            }
        }
        this.uniqueKeysUncompressedLength = this.uniqueKeysBuffer.size();
        this.uniqueKeysBuffer.rewind();
        this.uniqueKeysBuffer = CompressionFactory.getDefault().compress(this.uniqueKeysBuffer);
    }

    protected Map<String, TreeMap<TransactionIndexContext.ComparableKey, Map<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>>> readIndexKeysFromBuffer(DatabaseInternal database) {
        BinarySerializer serializer = database.getSerializer();
        this.uniqueKeysBuffer.position(0);
        int totalIndexes = (int)this.uniqueKeysBuffer.getUnsignedNumber();
        HashMap<String, TreeMap<TransactionIndexContext.ComparableKey, Map<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>>> indexesMap = new HashMap<String, TreeMap<TransactionIndexContext.ComparableKey, Map<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>>>(totalIndexes);
        for (int indexIdx = 0; indexIdx < totalIndexes; ++indexIdx) {
            String indexName = this.uniqueKeysBuffer.getString();
            Index index = database.getSchema().getIndexByName(indexName);
            int totalIndexEntries = (int)this.uniqueKeysBuffer.getUnsignedNumber();
            TreeMap indexMap = new TreeMap();
            indexesMap.put(indexName, indexMap);
            for (int entryIndex = 0; entryIndex < totalIndexEntries; ++entryIndex) {
                int keyEntryCount = (int)this.uniqueKeysBuffer.getUnsignedNumber();
                Object[] keyValues = new Object[keyEntryCount];
                for (int k = 0; k < keyEntryCount; ++k) {
                    byte keyType = this.uniqueKeysBuffer.getByte();
                    keyValues[k] = serializer.deserializeValue((Database)database, this.uniqueKeysBuffer, keyType, null);
                }
                int totalKeyEntries = (int)this.uniqueKeysBuffer.getUnsignedNumber();
                HashMap<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey> values = new HashMap<TransactionIndexContext.IndexKey, TransactionIndexContext.IndexKey>(totalKeyEntries);
                indexMap.put(new TransactionIndexContext.ComparableKey(keyValues), values);
                for (int i = 0; i < totalKeyEntries; ++i) {
                    TransactionIndexContext.IndexKey.IndexKeyOperation operation = TransactionIndexContext.IndexKey.IndexKeyOperation.values()[this.uniqueKeysBuffer.getByte()];
                    RID rid = new RID((BasicDatabase)database, (int)this.uniqueKeysBuffer.getUnsignedNumber(), this.uniqueKeysBuffer.getUnsignedNumber());
                    TransactionIndexContext.IndexKey v = new TransactionIndexContext.IndexKey(index.isUnique(), operation, keyValues, rid);
                    values.put(v, v);
                }
            }
        }
        return indexesMap;
    }
}

