/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseContext;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.message.DatabaseChangeStructureResponse;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class DatabaseChangeStructureRequest
extends HAAbstractCommand {
    private String databaseName;
    private String schemaJson;
    private Map<Integer, String> filesToAdd;
    private Map<Integer, String> filesToRemove;

    public DatabaseChangeStructureRequest() {
    }

    public DatabaseChangeStructureRequest(String databaseName, String schemaJson, Map<Integer, String> filesToAdd, Map<Integer, String> filesToRemove) {
        this.databaseName = databaseName;
        this.schemaJson = schemaJson;
        this.filesToAdd = filesToAdd;
        this.filesToRemove = filesToRemove;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
        stream.putString(this.schemaJson);
        stream.putUnsignedNumber((long)this.filesToAdd.size());
        for (Map.Entry<Integer, String> file : this.filesToAdd.entrySet()) {
            stream.putInt(file.getKey().intValue());
            stream.putByte((byte)(file.getValue() != null ? 1 : 0));
            if (file.getValue() == null) continue;
            stream.putString(file.getValue());
        }
        stream.putUnsignedNumber((long)this.filesToRemove.size());
        for (Map.Entry<Integer, String> file : this.filesToRemove.entrySet()) {
            stream.putInt(file.getKey().intValue());
            stream.putByte((byte)(file.getValue() != null ? 1 : 0));
            if (file.getValue() == null) continue;
            stream.putString(file.getValue());
        }
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        boolean notNull;
        int fileId;
        int i;
        this.databaseName = stream.getString();
        this.schemaJson = stream.getString();
        this.filesToAdd = new HashMap<Integer, String>();
        int fileCount = (int)stream.getUnsignedNumber();
        for (i = 0; i < fileCount; ++i) {
            fileId = stream.getInt();
            boolean bl = notNull = stream.getByte() == 1;
            if (notNull) {
                this.filesToAdd.put(fileId, stream.getString());
                continue;
            }
            this.filesToAdd.put(fileId, null);
        }
        this.filesToRemove = new HashMap<Integer, String>();
        fileCount = (int)stream.getUnsignedNumber();
        for (i = 0; i < fileCount; ++i) {
            fileId = stream.getInt();
            boolean bl = notNull = stream.getByte() == 1;
            if (notNull) {
                this.filesToRemove.put(fileId, stream.getString());
                continue;
            }
            this.filesToRemove.put(fileId, null);
        }
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        try {
            ServerDatabase db = server.getServer().getDatabase(this.databaseName);
            DatabaseContext.INSTANCE.init((DatabaseInternal)db);
            this.updateFiles(db);
            db.getSchema().getEmbedded().load(ComponentFile.MODE.READ_WRITE, true);
            return new DatabaseChangeStructureResponse();
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on changing database structure request from the leader node", (Throwable)e);
            throw new ReplicationException("Error on changing database structure request from the leader node", e);
        }
    }

    public void updateFiles(DatabaseInternal db) throws IOException {
        String databasePath = db.getDatabasePath();
        for (Map.Entry<Integer, String> entry : this.filesToAdd.entrySet()) {
            db.getFileManager().getOrCreateFile(entry.getKey().intValue(), databasePath + File.separator + entry.getValue());
        }
        for (Map.Entry<Integer, String> entry : this.filesToRemove.entrySet()) {
            db.getPageManager().deleteFile((Database)db, entry.getKey().intValue());
            db.getFileManager().dropFile(entry.getKey().intValue());
            db.getSchema().getEmbedded().removeFile(entry.getKey().intValue());
        }
        if (!this.schemaJson.isEmpty()) {
            db.getSchema().getEmbedded().update(new JSONObject(this.schemaJson));
        }
    }

    public String toString() {
        return "dbchangestructure add=" + String.valueOf(this.filesToAdd) + " remove=" + String.valueOf(this.filesToRemove);
    }
}

