/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.Binary;
import com.arcadedb.exception.ConcurrentModificationException;
import com.arcadedb.exception.ConfigurationException;
import com.arcadedb.exception.TimeoutException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.HostUtil;
import com.arcadedb.network.binary.ChannelBinaryClient;
import com.arcadedb.network.binary.ConnectionException;
import com.arcadedb.network.binary.QuorumNotReachedException;
import com.arcadedb.network.binary.ServerIsNotTheLeaderException;
import com.arcadedb.query.sql.executor.InternalResultSet;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ReplicationCallback;
import com.arcadedb.server.ServerException;
import com.arcadedb.server.ServerPlugin;
import com.arcadedb.server.ha.Leader2ReplicaNetworkExecutor;
import com.arcadedb.server.ha.LeaderNetworkListener;
import com.arcadedb.server.ha.Replica2LeaderNetworkExecutor;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.ReplicationLogException;
import com.arcadedb.server.ha.ReplicationLogFile;
import com.arcadedb.server.ha.ReplicationMessage;
import com.arcadedb.server.ha.message.ErrorResponse;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.server.ha.message.HAMessageFactory;
import com.arcadedb.server.ha.message.UpdateClusterConfiguration;
import com.arcadedb.server.ha.network.DefaultServerSocketFactory;
import com.arcadedb.utility.Callable;
import com.arcadedb.utility.CodeUtils;
import com.arcadedb.utility.DateUtils;
import com.arcadedb.utility.Pair;
import com.arcadedb.utility.RecordTableFormatter;
import com.arcadedb.utility.TableFormatter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class HAServer
implements ServerPlugin {
    public static final String DEFAULT_PORT = "2424";
    private final HAMessageFactory messageFactory;
    private final ArcadeDBServer server;
    private final ContextConfiguration configuration;
    private final String bucketName;
    private final long startedOn;
    private volatile int configuredServers = 1;
    private final Map<String, Leader2ReplicaNetworkExecutor> replicaConnections = new ConcurrentHashMap<String, Leader2ReplicaNetworkExecutor>();
    private final AtomicLong lastDistributedOperationNumber = new AtomicLong(-1L);
    private final AtomicLong lastForwardOperationNumber = new AtomicLong(0L);
    protected final String replicationPath;
    protected ReplicationLogFile replicationLogFile;
    private final AtomicReference<Replica2LeaderNetworkExecutor> leaderConnection = new AtomicReference();
    private LeaderNetworkListener listener;
    private final Map<Long, QuorumMessage> messagesWaitingForQuorum = new ConcurrentHashMap<Long, QuorumMessage>(1024);
    private final Map<Long, ForwardedMessage> forwardMessagesWaitingForResponse = new ConcurrentHashMap<Long, ForwardedMessage>(1024);
    private long lastConfigurationOutputHash = 0L;
    private final Object sendingLock = new Object();
    private String serverAddress;
    private final Set<String> serverAddressList = new HashSet<String>();
    private String replicasHTTPAddresses;
    protected Pair<Long, String> lastElectionVote;
    private volatile ELECTION_STATUS electionStatus = ELECTION_STATUS.DONE;
    private boolean started;
    private final SERVER_ROLE serverRole;
    private Thread electionThread;

    public HAServer(ArcadeDBServer server, ContextConfiguration configuration) {
        if (!configuration.getValueAsBoolean(GlobalConfiguration.TX_WAL)) {
            throw new ConfigurationException("Cannot start HA service without using WAL. Please enable the TX_WAL setting.");
        }
        this.server = server;
        this.messageFactory = new HAMessageFactory(server);
        this.configuration = configuration;
        this.bucketName = configuration.getValueAsString(GlobalConfiguration.HA_CLUSTER_NAME);
        this.startedOn = System.currentTimeMillis();
        this.replicationPath = server.getRootPath() + "/replication";
        this.serverRole = SERVER_ROLE.valueOf(configuration.getValueAsString(GlobalConfiguration.HA_SERVER_ROLE).toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void startService() {
        if (this.started) {
            return;
        }
        while (!this.server.getHttpServer().isConnected()) {
            CodeUtils.sleep((long)200L);
        }
        this.started = true;
        String fileName = this.replicationPath + "/replication_" + this.server.getServerName() + ".rlog";
        try {
            this.replicationLogFile = new ReplicationLogFile(fileName);
            this.lastDistributedOperationNumber.set(this.replicationLogFile.getLastMessageNumber());
            if (this.lastDistributedOperationNumber.get() > -1L) {
                LogManager.instance().log((Object)this, Level.FINE, "Found an existent replication log. Starting messages from %d", (Object)this.lastDistributedOperationNumber.get());
            }
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on creating replication file '%s' for remote server '%s'", (Object)fileName, (Object)this.server.getServerName());
            this.stopService();
            throw new ReplicationLogException("Error on creating replication file '" + fileName + "'", e);
        }
        this.listener = new LeaderNetworkListener(this, new DefaultServerSocketFactory(), this.configuration.getValueAsString(GlobalConfiguration.HA_REPLICATION_INCOMING_HOST), this.configuration.getValueAsString(GlobalConfiguration.HA_REPLICATION_INCOMING_PORTS));
        this.serverAddress = this.server.getHostAddress() + ":" + this.listener.getPort();
        String cfgServerList = this.configuration.getValueAsString(GlobalConfiguration.HA_SERVER_LIST).trim();
        if (!cfgServerList.isEmpty()) {
            String[] serverEntries = cfgServerList.split(",");
            this.configuredServers = serverEntries.length;
            LogManager.instance().log((Object)this, Level.FINE, "Connecting to servers %s (cluster=%s configuredServers=%d)", (Object)cfgServerList, (Object)this.bucketName, (Object)this.configuredServers);
            HAServer.checkAllOrNoneAreLocalhosts(serverEntries);
            this.serverAddressList.clear();
            this.serverAddressList.addAll(Arrays.asList(serverEntries));
            for (String serverEntry : serverEntries) {
                if (!this.isCurrentServer(serverEntry) && this.connectToLeader(serverEntry, null)) break;
            }
        }
        if (this.leaderConnection.get() == null) {
            int majorityOfVotes = this.configuredServers / 2 + 1;
            LogManager.instance().log((Object)this, Level.INFO, "Unable to find any Leader, start election (cluster=%s configuredServers=%d majorityOfVotes=%d)", (Object)this.bucketName, (Object)this.configuredServers, (Object)majorityOfVotes);
            if (this.serverRole != SERVER_ROLE.REPLICA) {
                this.startElection(false);
            }
        }
    }

    protected boolean isCurrentServer(String serverEntry) {
        if (this.serverAddress.equals(serverEntry)) {
            return true;
        }
        String[] localServerParts = HostUtil.parseHostAddress((String)this.serverAddress, (String)DEFAULT_PORT);
        try {
            String[] serverParts = HostUtil.parseHostAddress((String)serverEntry, (String)DEFAULT_PORT);
            if (localServerParts[0].equals(serverParts[0]) && localServerParts[1].equals(serverParts[1])) {
                return true;
            }
            InetAddress localhostAddress = InetAddress.getLocalHost();
            if (localhostAddress.getHostAddress().equals(serverParts[0]) && localServerParts[1].equals(serverParts[1])) {
                return true;
            }
            if (localhostAddress.getHostName().equals(serverParts[0]) && localServerParts[1].equals(serverParts[1])) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void stopService() {
        Replica2LeaderNetworkExecutor lc;
        this.started = false;
        if (this.listener != null) {
            this.listener.close();
        }
        if ((lc = this.leaderConnection.get()) != null) {
            lc.close();
            this.leaderConnection.set(null);
        }
        if (!this.replicaConnections.isEmpty()) {
            for (Leader2ReplicaNetworkExecutor r : this.replicaConnections.values()) {
                r.close();
            }
            this.replicaConnections.clear();
        }
        if (this.replicationLogFile != null) {
            this.replicationLogFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElection(boolean waitForCompletion) {
        HAServer hAServer = this;
        synchronized (hAServer) {
            if (this.electionThread == null) {
                this.electionThread = new Thread(this::startElection, this.getServerName() + " election");
                this.electionThread.start();
                if (waitForCompletion) {
                    try {
                        this.electionThread.join(60000L);
                    }
                    catch (InterruptedException e) {
                        LogManager.instance().log((Object)this, Level.SEVERE, "Timeout on election process");
                    }
                }
            }
        }
    }

    private boolean checkForExistentLeaderConnection(long electionTurn) {
        Replica2LeaderNetworkExecutor lc = this.leaderConnection.get();
        if (lc != null) {
            LogManager.instance().log((Object)this, Level.INFO, "Abort election process, a Leader (%s) has been already found (turn=%d)", (Object)lc.getRemoteServerName(), (Object)electionTurn);
            return true;
        }
        return false;
    }

    private void sendNewLeadershipToOtherNodes() {
        this.lastDistributedOperationNumber.set(this.replicationLogFile.getLastMessageNumber());
        this.setElectionStatus(ELECTION_STATUS.LEADER_WAITING_FOR_QUORUM);
        LogManager.instance().log((Object)this, Level.INFO, "Contacting all the servers for the new leadership (turn=%d)...", this.lastElectionVote.getFirst());
        for (String serverAddress : this.serverAddressList) {
            if (this.isCurrentServer(serverAddress)) continue;
            try {
                String[] parts = HostUtil.parseHostAddress((String)serverAddress, (String)DEFAULT_PORT);
                LogManager.instance().log((Object)this, Level.INFO, "- Sending new Leader to server '%s'...", (Object)serverAddress);
                ChannelBinaryClient channel = this.createNetworkConnection(parts[0], Integer.parseInt(parts[1]), (short)2);
                channel.writeLong(((Long)this.lastElectionVote.getFirst()).longValue());
                channel.flush();
            }
            catch (Exception e) {
                LogManager.instance().log((Object)this, Level.INFO, "Error contacting server %s for election", (Object)serverAddress);
            }
        }
    }

    public Leader2ReplicaNetworkExecutor getReplica(String replicaName) {
        return this.replicaConnections.get(replicaName);
    }

    public void disconnectAllReplicas() {
        ArrayList<Leader2ReplicaNetworkExecutor> replicas = new ArrayList<Leader2ReplicaNetworkExecutor>(this.replicaConnections.values());
        this.replicaConnections.clear();
        for (Leader2ReplicaNetworkExecutor replica : replicas) {
            try {
                replica.close();
                this.setReplicaStatus(replica.getRemoteServerName(), false);
            }
            catch (Exception exception) {}
        }
        this.configuredServers = 1;
    }

    public void setReplicaStatus(String remoteServerName, boolean online) {
        Leader2ReplicaNetworkExecutor c = this.replicaConnections.get(remoteServerName);
        if (c == null) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Replica '%s' was not registered", (Object)remoteServerName);
            return;
        }
        c.setStatus(online ? Leader2ReplicaNetworkExecutor.STATUS.ONLINE : Leader2ReplicaNetworkExecutor.STATUS.OFFLINE);
        try {
            this.server.lifecycleEvent(online ? ReplicationCallback.TYPE.REPLICA_ONLINE : ReplicationCallback.TYPE.REPLICA_OFFLINE, remoteServerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.electionStatus == ELECTION_STATUS.LEADER_WAITING_FOR_QUORUM && this.getOnlineServers() >= this.configuredServers / 2 + 1) {
            this.setElectionStatus(ELECTION_STATUS.DONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedResponse(String remoteServerName, long messageNumber, Object payload) {
        long receivedOn = System.currentTimeMillis();
        QuorumMessage msg = this.messagesWaitingForQuorum.get(messageNumber);
        if (msg == null) {
            return;
        }
        if (payload != null) {
            QuorumMessage quorumMessage = msg;
            synchronized (quorumMessage) {
                if (msg.payloads == null) {
                    msg.payloads = new ArrayList<Object>();
                }
                msg.payloads.add(payload);
            }
        }
        msg.semaphore.countDown();
        Leader2ReplicaNetworkExecutor c = this.replicaConnections.get(remoteServerName);
        if (c != null) {
            c.updateStats(msg.sentOn, receivedOn);
        }
    }

    public void receivedResponseFromForward(long messageNumber, Object result, ErrorResponse error) {
        ForwardedMessage msg = this.forwardMessagesWaitingForResponse.get(messageNumber);
        if (msg == null) {
            return;
        }
        LogManager.instance().log((Object)this, Level.FINE, "Forwarded message %d has been executed", (Object)messageNumber);
        msg.result = result;
        msg.error = error;
        msg.semaphore.countDown();
    }

    public ReplicationLogFile getReplicationLogFile() {
        return this.replicationLogFile;
    }

    public ArcadeDBServer getServer() {
        return this.server;
    }

    public boolean isLeader() {
        return this.leaderConnection.get() == null;
    }

    public String getLeaderName() {
        return this.leaderConnection.get() == null ? this.getServerName() : this.leaderConnection.get().getRemoteServerName();
    }

    public Replica2LeaderNetworkExecutor getLeader() {
        return this.leaderConnection.get();
    }

    public String getServerName() {
        return this.server.getServerName();
    }

    public String getClusterName() {
        return this.bucketName;
    }

    public void registerIncomingConnection(String replicaServerName, Leader2ReplicaNetworkExecutor connection) {
        int totReplicas;
        Leader2ReplicaNetworkExecutor previousConnection = this.replicaConnections.put(replicaServerName, connection);
        if (previousConnection != null && previousConnection != connection) {
            connection.mergeFrom(previousConnection);
        }
        if (1 + (totReplicas = this.replicaConnections.size()) > this.configuredServers) {
            this.configuredServers = 1 + totReplicas;
        }
        this.sendCommandToReplicasNoLog(new UpdateClusterConfiguration(this.getServerAddressList(), this.getReplicaServersHTTPAddressesList()));
        this.printClusterConfiguration();
    }

    public ELECTION_STATUS getElectionStatus() {
        return this.electionStatus;
    }

    protected void setElectionStatus(ELECTION_STATUS status) {
        LogManager.instance().log((Object)this, Level.INFO, "Change election status from %s to %s", (Object)this.electionStatus, (Object)status);
        this.electionStatus = status;
    }

    public HAMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setServerAddresses(String serverAddress) {
        if (serverAddress != null && !serverAddress.isEmpty()) {
            this.serverAddressList.clear();
            String[] servers = serverAddress.split(",");
            this.serverAddressList.addAll(Arrays.asList(servers));
            this.configuredServers = this.serverAddressList.size();
        } else {
            this.configuredServers = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object forwardCommandToLeader(HACommand command, long timeout) {
        ForwardedMessage forwardedMessage;
        block14: {
            LogManager.instance().setContext(this.getServerName());
            Binary buffer = new Binary();
            String leaderName = this.getLeaderName();
            long opNumber = this.lastForwardOperationNumber.decrementAndGet();
            LogManager.instance().log((Object)this, Level.FINE, "Forwarding request %d (%s) to Leader server '%s'", (Object)opNumber, (Object)command, (Object)leaderName);
            forwardedMessage = new ForwardedMessage();
            if (this.leaderConnection.get() == null) {
                throw new ReplicationException("Leader not available");
            }
            this.forwardMessagesWaitingForResponse.put(opNumber, forwardedMessage);
            try {
                this.leaderConnection.get().sendCommandToLeader(buffer, command, opNumber);
                if (timeout > 0L) {
                    try {
                        if (forwardedMessage.semaphore.await(timeout, TimeUnit.MILLISECONDS)) {
                            if (forwardedMessage.error != null) {
                                if (forwardedMessage.error.exceptionClass.equals(ConcurrentModificationException.class.getName())) {
                                    throw new ConcurrentModificationException(forwardedMessage.error.exceptionMessage);
                                }
                                if (forwardedMessage.error.exceptionClass.equals(TransactionException.class.getName())) {
                                    throw new TransactionException(forwardedMessage.error.exceptionMessage);
                                }
                                if (forwardedMessage.error.exceptionClass.equals(QuorumNotReachedException.class.getName())) {
                                    throw new QuorumNotReachedException(forwardedMessage.error.exceptionMessage);
                                }
                                LogManager.instance().log((Object)this, Level.WARNING, "Unexpected error received from forwarding a transaction to the Leader");
                                throw new ReplicationException("Unexpected error received from forwarding a transaction to the Leader");
                            }
                            break block14;
                        }
                        throw new TimeoutException("Error on forwarding transaction to the Leader server");
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ReplicationException("No response received from the Leader for request " + opNumber + " because the thread was interrupted");
                    }
                }
                forwardedMessage.result = new InternalResultSet(new ResultInternal(Map.of("operation", "forwarded to the leader")));
            }
            catch (TimeoutException | IOException e) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Leader server '%s' does not respond, starting election...", (Object)leaderName);
                this.startElection(false);
            }
            finally {
                this.forwardMessagesWaitingForResponse.remove(opNumber);
            }
        }
        return forwardedMessage.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommandToReplicasNoLog(HACommand command) {
        this.checkCurrentNodeIsTheLeader();
        Binary buffer = new Binary();
        ArrayList<Leader2ReplicaNetworkExecutor> replicas = new ArrayList<Leader2ReplicaNetworkExecutor>(this.replicaConnections.values());
        Object object = this.sendingLock;
        synchronized (object) {
            this.messageFactory.serializeCommand(command, buffer, -1L);
            LogManager.instance().log((Object)this, Level.FINE, "Sending request (%s) to %s", (Object)-1, (Object)command, replicas);
            for (Leader2ReplicaNetworkExecutor replicaConnection : replicas) {
                try {
                    replicaConnection.enqueueMessage(-1L, buffer.slice(0));
                }
                catch (ReplicationException e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Replica '%s' does not respond, setting it as OFFLINE", (Object)replicaConnection.getRemoteServerName());
                    this.setReplicaStatus(replicaConnection.getRemoteServerName(), false);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public List<Object> sendCommandToReplicasWithQuorum(HACommand command, int quorum, long timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 18[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getMessagesInQueue() {
        int total = 0;
        for (Leader2ReplicaNetworkExecutor r : this.replicaConnections.values()) {
            total += r.getMessagesInQueue();
        }
        return total;
    }

    public void setReplicasHTTPAddresses(String replicasHTTPAddresses) {
        this.replicasHTTPAddresses = replicasHTTPAddresses;
    }

    public String getReplicaServersHTTPAddressesList() {
        if (this.isLeader()) {
            StringBuilder list = new StringBuilder();
            for (Leader2ReplicaNetworkExecutor r : this.replicaConnections.values()) {
                String addr = r.getRemoteServerHTTPAddress();
                if (addr == null) continue;
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(addr);
            }
            return list.toString();
        }
        return this.replicasHTTPAddresses;
    }

    public void removeServer(String remoteServerName) {
        Leader2ReplicaNetworkExecutor c = this.replicaConnections.remove(remoteServerName);
        if (c != null) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Replica '%s' seems not active, removing it from the cluster", (Object)remoteServerName);
            c.close();
        }
        this.configuredServers = 1 + this.replicaConnections.size();
    }

    public int getOnlineServers() {
        return 1 + this.getOnlineReplicas();
    }

    public int getOnlineReplicas() {
        int total = 0;
        for (Leader2ReplicaNetworkExecutor c : this.replicaConnections.values()) {
            if (c.getStatus() != Leader2ReplicaNetworkExecutor.STATUS.ONLINE) continue;
            ++total;
        }
        return total;
    }

    public int getConfiguredServers() {
        return this.configuredServers;
    }

    public String getServerAddressList() {
        StringBuilder list = new StringBuilder();
        for (String s : this.serverAddressList) {
            if (list.length() > 0) {
                list.append(',');
            }
            list.append(s);
        }
        return list.toString();
    }

    public void printClusterConfiguration() {
        StringBuilder buffer = new StringBuilder("NEW CLUSTER CONFIGURATION\n");
        TableFormatter table = new TableFormatter((text, args) -> buffer.append(text.formatted(args)));
        ArrayList<RecordTableFormatter.TableRecordRow> list = new ArrayList<RecordTableFormatter.TableRecordRow>();
        ResultInternal line = new ResultInternal();
        list.add(new RecordTableFormatter.TableRecordRow((Result)line));
        Date date = new Date(this.startedOn);
        String dateFormatted = this.startedOn > 0L ? (DateUtils.areSameDay((Date)date, (Date)new Date()) ? DateUtils.format((Object)date, (String)"HH:mm:ss") : DateUtils.format((Object)date, (String)"yyyy-MM-dd HH:mm:ss")) : "";
        line.setProperty("SERVER", (Object)this.getServerName());
        line.setProperty("HOST:PORT", (Object)this.getServerAddress());
        line.setProperty("ROLE", (Object)"Leader");
        line.setProperty("STATUS", (Object)"ONLINE");
        line.setProperty("JOINED ON", (Object)dateFormatted);
        line.setProperty("LEFT ON", (Object)"");
        line.setProperty("THROUGHPUT", (Object)"");
        line.setProperty("LATENCY", (Object)"");
        for (Leader2ReplicaNetworkExecutor c : this.replicaConnections.values()) {
            line = new ResultInternal();
            list.add(new RecordTableFormatter.TableRecordRow((Result)line));
            Leader2ReplicaNetworkExecutor.STATUS status = c.getStatus();
            line.setProperty("SERVER", (Object)c.getRemoteServerName());
            line.setProperty("HOST:PORT", (Object)c.getRemoteServerAddress());
            line.setProperty("ROLE", (Object)"Replica");
            line.setProperty("STATUS", (Object)status);
            date = new Date(c.getJoinedOn());
            dateFormatted = c.getJoinedOn() > 0L ? (DateUtils.areSameDay((Date)date, (Date)new Date()) ? DateUtils.format((Object)date, (String)"HH:mm:ss") : DateUtils.format((Object)date, (String)"yyyy-MM-dd HH:mm:ss")) : "";
            line.setProperty("JOINED ON", (Object)dateFormatted);
            date = new Date(c.getLeftOn());
            dateFormatted = c.getLeftOn() > 0L ? (DateUtils.areSameDay((Date)date, (Date)new Date()) ? DateUtils.format((Object)date, (String)"HH:mm:ss") : DateUtils.format((Object)date, (String)"yyyy-MM-dd HH:mm:ss")) : "";
            line.setProperty("LEFT ON", (Object)dateFormatted);
            line.setProperty("THROUGHPUT", (Object)c.getThroughputStats());
            line.setProperty("LATENCY", (Object)c.getLatencyStats());
        }
        table.writeRows(list, -1);
        String output = buffer.toString();
        int hash = 7;
        for (int i = 0; i < output.length(); ++i) {
            hash = hash * 31 + output.charAt(i);
        }
        if (this.lastConfigurationOutputHash == (long)hash) {
            return;
        }
        this.lastConfigurationOutputHash = hash;
        LogManager.instance().log((Object)this, Level.INFO, output + "\n");
    }

    public JSONObject getStats() {
        String dateTimeFormat = GlobalConfiguration.DATE_TIME_FORMAT.getValueAsString();
        JSONObject result = new JSONObject().setDateTimeFormat(dateTimeFormat).setDateFormat(GlobalConfiguration.DATE_FORMAT.getValueAsString());
        JSONObject current = new JSONObject().setDateTimeFormat(dateTimeFormat).setDateFormat(GlobalConfiguration.DATE_FORMAT.getValueAsString());
        current.put("name", this.getServerName());
        current.put("address", this.getServerAddress());
        current.put("role", this.isLeader() ? "Leader" : "Replica");
        current.put("status", "ONLINE");
        Date date = new Date(this.startedOn);
        String dateFormatted = DateUtils.areSameDay((Date)date, (Date)new Date()) ? DateUtils.format((Object)date, (String)"HH:mm:ss") : DateUtils.format((Object)date, (String)"yyyy-MM-dd HH:mm:ss");
        current.put("joinedOn", dateFormatted);
        result.put("current", (Object)current);
        if (this.isLeader()) {
            JSONArray replicas = new JSONArray();
            for (Leader2ReplicaNetworkExecutor c : this.replicaConnections.values()) {
                Leader2ReplicaNetworkExecutor.STATUS status = c.getStatus();
                JSONObject replica = new JSONObject().setDateFormat(dateTimeFormat);
                replicas.put(replica);
                replica.put("name", c.getRemoteServerName());
                replica.put("address", c.getRemoteServerAddress());
                replica.put("role", "Replica");
                replica.put("status", (Object)status);
                date = new Date(c.getJoinedOn());
                dateFormatted = c.getJoinedOn() > 0L ? (DateUtils.areSameDay((Date)date, (Date)new Date()) ? DateUtils.format((Object)date, (String)"HH:mm:ss") : DateUtils.format((Object)date, (String)"yyyy-MM-dd HH:mm:ss")) : "";
                replica.put("joinedOn", dateFormatted);
                date = new Date(c.getLeftOn());
                dateFormatted = c.getLeftOn() > 0L ? (DateUtils.areSameDay((Date)date, (Date)new Date()) ? DateUtils.format((Object)date, (String)"HH:mm:ss") : DateUtils.format((Object)date, (String)"yyyy-MM-dd HH:mm:ss")) : "";
                replica.put("leftOn", dateFormatted);
                replica.put("throughput", c.getThroughputStats());
                replica.put("latency", c.getLatencyStats());
            }
            result.put("replicas", (Object)replicas);
        }
        return result;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return this.getServerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendMessagesToReplica(long fromMessageNumber, String replicaName) {
        Leader2ReplicaNetworkExecutor replica = this.replicaConnections.get(replicaName);
        if (replica == null) {
            throw new ReplicationException("Server '" + this.getServerName() + "' cannot sync replica '" + replicaName + "' because it is offline");
        }
        long fromPositionInLog = this.replicationLogFile.findMessagePosition(fromMessageNumber);
        AtomicInteger totalSentMessages = new AtomicInteger();
        long min = -1L;
        long max = -1L;
        Object object = this.sendingLock;
        synchronized (object) {
            long pos = fromPositionInLog;
            while (pos < this.replicationLogFile.getSize()) {
                Pair<ReplicationMessage, Long> entry = this.replicationLogFile.getMessage(pos);
                try {
                    LogManager.instance().log((Object)this, Level.FINE, "Resending message (%s) to replica '%s'...", entry.getFirst(), (Object)replica.getRemoteServerName());
                    if (min == -1L) {
                        min = ((ReplicationMessage)entry.getFirst()).messageNumber;
                    }
                    max = ((ReplicationMessage)entry.getFirst()).messageNumber;
                    replica.sendMessage(((ReplicationMessage)entry.getFirst()).payload);
                    totalSentMessages.incrementAndGet();
                    pos = (Long)entry.getSecond();
                }
                catch (Exception e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Replica '%s' does not respond, setting it as OFFLINE (error=%s)", (Object)replica.getRemoteServerName(), (Object)e.toString());
                    this.setReplicaStatus(replica.getRemoteServerName(), false);
                    throw new ReplicationException("Cannot resend messages to replica '" + replicaName + "'", e);
                }
            }
        }
        LogManager.instance().log((Object)this, Level.INFO, "Recovering completed. Sent %d message(s) to replica '%s' (%d-%d)", (Object)totalSentMessages.get(), (Object)replicaName, (Object)min, (Object)max);
    }

    public boolean connectToLeader(String serverEntry, Callable<Void, Exception> errorCallback) {
        String[] serverParts = HostUtil.parseHostAddress((String)serverEntry, (String)DEFAULT_PORT);
        try {
            this.connectToLeader(serverParts[0], Integer.parseInt(serverParts[1]));
            return true;
        }
        catch (ServerIsNotTheLeaderException e) {
            String leaderAddress = e.getLeaderAddress();
            LogManager.instance().log((Object)this, Level.INFO, "Remote server %s:%d is not the Leader, connecting to %s", (Object)serverParts[0], (Object)Integer.parseInt(serverParts[1]), (Object)leaderAddress);
            String[] leader = HostUtil.parseHostAddress((String)leaderAddress, (String)DEFAULT_PORT);
            this.connectToLeader(leader[0], Integer.parseInt(leader[1]));
            return true;
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.INFO, "Error connecting to the remote Leader server %s:%d (error=%s)", (Object)serverParts[0], (Object)Integer.parseInt(serverParts[1]), (Object)e);
            if (errorCallback != null) {
                errorCallback.call((Object)e);
            }
            return false;
        }
    }

    private void connectToLeader(String host, int port) {
        Replica2LeaderNetworkExecutor lc = this.leaderConnection.get();
        if (lc != null) {
            lc.kill();
            this.leaderConnection.set(null);
        }
        for (Leader2ReplicaNetworkExecutor r : this.replicaConnections.values()) {
            r.close();
        }
        this.replicaConnections.clear();
        this.leaderConnection.set(new Replica2LeaderNetworkExecutor(this, host, port));
        this.leaderConnection.get().startup();
        this.leaderConnection.get().start();
    }

    protected ChannelBinaryClient createNetworkConnection(String host, int port, short commandId) throws IOException {
        try {
            this.server.lifecycleEvent(ReplicationCallback.TYPE.NETWORK_CONNECTION, host + ":" + port);
        }
        catch (Exception e) {
            throw new ConnectionException(host + ":" + port, (Throwable)e);
        }
        ChannelBinaryClient channel = new ChannelBinaryClient(host, port, this.configuration);
        String clusterName = this.configuration.getValueAsString(GlobalConfiguration.HA_CLUSTER_NAME);
        channel.writeLong(20986405762943483L);
        channel.writeShort((short)0);
        channel.writeString(clusterName);
        channel.writeString(this.getServerName());
        channel.writeString(this.getServerAddress());
        channel.writeString(this.server.getHttpServer().getListeningAddress());
        channel.writeShort(commandId);
        return channel;
    }

    private boolean waitAndRetryDuringElection(int quorum) {
        if (this.electionStatus == ELECTION_STATUS.DONE) {
            throw new QuorumNotReachedException("Quorum " + quorum + " not reached because only " + this.getOnlineServers() + " server(s) are online");
        }
        LogManager.instance().log((Object)this, Level.INFO, "Waiting during election (quorum=%d onlineReplicas=%d)", (Object)quorum, (Object)this.getOnlineReplicas());
        for (int retry = 0; retry < 10 && this.electionStatus != ELECTION_STATUS.DONE; ++retry) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        LogManager.instance().log((Object)this, Level.INFO, "Waiting is over (electionStatus=%s quorum=%d onlineReplicas=%d)", (Object)this.electionStatus, (Object)quorum, (Object)this.getOnlineReplicas());
        return this.electionStatus == ELECTION_STATUS.DONE;
    }

    private void checkCurrentNodeIsTheLeader() {
        if (!this.isLeader()) {
            throw new ServerIsNotTheLeaderException("Cannot execute command", this.getLeader().getRemoteServerName());
        }
    }

    private static void checkAllOrNoneAreLocalhosts(String[] serverEntries) {
        int localHostServers = 0;
        for (int i = 0; i < serverEntries.length; ++i) {
            String serverEntry = serverEntries[i];
            if (!serverEntry.startsWith("localhost") && !serverEntry.startsWith("127.0.0.1")) continue;
            ++localHostServers;
        }
        if (localHostServers > 0 && localHostServers < serverEntries.length) {
            throw new ServerException("Found a localhost (127.0.0.1) in the server list among non-localhost servers. Please fix the server list configuration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startElection() {
        try {
            if (this.electionStatus == ELECTION_STATUS.VOTING_FOR_ME) {
                return;
            }
            this.setElectionStatus(ELECTION_STATUS.VOTING_FOR_ME);
            long lastReplicationMessage = this.replicationLogFile.getLastMessageNumber();
            long electionTurn = this.lastElectionVote == null ? 1L : (Long)this.lastElectionVote.getFirst() + 1L;
            Replica2LeaderNetworkExecutor lc = this.leaderConnection.get();
            if (lc != null) {
                lc.close();
                this.leaderConnection.set(null);
            }
            int retry = 0;
            while (!this.checkForExistentLeaderConnection(electionTurn) && this.started) {
                int majorityOfVotes = this.configuredServers / 2 + 1;
                int totalVotes = 1;
                this.lastElectionVote = new Pair((Object)electionTurn, (Object)this.getServerName());
                LogManager.instance().log((Object)this, Level.INFO, "Starting election of local server asking for votes from %s (turn=%d retry=%d lastReplicationMessage=%d configuredServers=%d majorityOfVotes=%d)", this.serverAddressList, (Object)electionTurn, (Object)retry, (Object)lastReplicationMessage, (Object)this.configuredServers, (Object)majorityOfVotes);
                HashMap<String, Integer> otherLeaders = new HashMap<String, Integer>();
                boolean electionAborted = false;
                HashSet<String> serverAddressListCopy = new HashSet<String>(this.serverAddressList);
                for (String string : serverAddressListCopy) {
                    if (this.isCurrentServer(string)) continue;
                    try {
                        String[] parts = HostUtil.parseHostAddress((String)string, (String)DEFAULT_PORT);
                        ChannelBinaryClient channel = this.createNetworkConnection(parts[0], Integer.parseInt(parts[1]), (short)1);
                        channel.writeLong(electionTurn);
                        channel.writeLong(lastReplicationMessage);
                        channel.flush();
                        byte vote = channel.readByte();
                        if (vote == 0) {
                            LogManager.instance().log((Object)this, Level.INFO, "Received the vote from server %s (turn=%d totalVotes=%d majority=%d)", (Object)string, (Object)electionTurn, (Object)(++totalVotes), (Object)majorityOfVotes);
                        } else {
                            String otherLeaderName = channel.readString();
                            if (!otherLeaderName.isEmpty()) {
                                Integer counter = (Integer)otherLeaders.get(otherLeaderName);
                                otherLeaders.put(otherLeaderName, counter == null ? 1 : counter + 1);
                            }
                            if (vote == 1) {
                                LogManager.instance().log((Object)this, Level.INFO, "Did not receive the vote from server %s (turn=%d totalVotes=%d majority=%d itsLeader=%s)", (Object)string, (Object)electionTurn, (Object)totalVotes, (Object)majorityOfVotes, (Object)otherLeaderName);
                            } else if (vote == 2) {
                                electionAborted = true;
                                LogManager.instance().log((Object)this, Level.INFO, "Aborting election because server %s has a higher LSN (turn=%d lastReplicationMessage=%d totalVotes=%d majority=%d)", (Object)string, (Object)electionTurn, (Object)lastReplicationMessage, (Object)totalVotes, (Object)majorityOfVotes);
                            }
                        }
                        channel.close();
                    }
                    catch (Exception e) {
                        LogManager.instance().log((Object)this, Level.INFO, "Error contacting server %s for election: %s", (Object)string, (Object)e.getMessage());
                    }
                }
                if (this.checkForExistentLeaderConnection(electionTurn)) {
                    break;
                }
                if (!electionAborted && totalVotes >= majorityOfVotes) {
                    LogManager.instance().log((Object)this, Level.INFO, "Current server elected as new $ANSI{green Leader} (turn=%d totalVotes=%d majority=%d)", (Object)electionTurn, (Object)totalVotes, (Object)majorityOfVotes);
                    this.sendNewLeadershipToOtherNodes();
                    break;
                }
                if (!otherLeaders.isEmpty()) {
                    LogManager.instance().log((Object)this, Level.INFO, "Other leaders found %s (turn=%d totalVotes=%d majority=%d)", otherLeaders, (Object)electionTurn, (Object)totalVotes, (Object)majorityOfVotes);
                    for (Map.Entry entry : otherLeaders.entrySet()) {
                        if ((Integer)entry.getValue() < majorityOfVotes) continue;
                        LogManager.instance().log((Object)this, Level.INFO, "Trying to connect to the existing leader '%s' (turn=%d totalVotes=%d majority=%d)", entry.getKey(), (Object)electionTurn, entry.getValue(), (Object)majorityOfVotes);
                        if (this.isCurrentServer((String)entry.getKey()) || !this.connectToLeader((String)entry.getKey(), null)) continue;
                        break;
                    }
                }
                if (this.checkForExistentLeaderConnection(electionTurn)) {
                    break;
                }
                try {
                    long timeout = 1000 + new Random().nextInt(1000);
                    if (electionAborted) {
                        timeout *= 3L;
                    }
                    LogManager.instance().log((Object)this, Level.INFO, "Not able to be elected as Leader, waiting %dms and retry (turn=%d totalVotes=%d majority=%d)", (Object)timeout, (Object)electionTurn, (Object)totalVotes, (Object)majorityOfVotes);
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (this.checkForExistentLeaderConnection(electionTurn)) {
                    break;
                }
                ++electionTurn;
                ++retry;
            }
        }
        finally {
            HAServer hAServer = this;
            synchronized (hAServer) {
                this.electionThread = null;
            }
        }
    }

    public static enum ELECTION_STATUS {
        DONE,
        VOTING_FOR_ME,
        VOTING_FOR_OTHERS,
        LEADER_WAITING_FOR_QUORUM;

    }

    public static enum SERVER_ROLE {
        ANY,
        REPLICA;

    }

    private static class QuorumMessage {
        public final long sentOn = System.currentTimeMillis();
        public final CountDownLatch semaphore;
        public List<Object> payloads;

        public QuorumMessage(CountDownLatch quorumSemaphore) {
            this.semaphore = quorumSemaphore;
        }
    }

    private static class ForwardedMessage {
        public final CountDownLatch semaphore = new CountDownLatch(1);
        public ErrorResponse error;
        public Object result;
    }

    public static enum QUORUM {
        NONE,
        ONE,
        TWO,
        THREE,
        MAJORITY,
        ALL;


        public int quorum(int numberOfServers) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 0;
                case 1 -> 1;
                case 2 -> 2;
                case 3 -> 3;
                case 4 -> numberOfServers / 2 + 1;
                case 5 -> numberOfServers;
            };
        }
    }
}

