/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.security;

import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.log.LogManager;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.security.SecurityDatabaseUser;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.security.ServerSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public class ServerSecurityDatabaseUser
implements SecurityDatabaseUser {
    private static final JSONObject NO_ACCESS_GROUP = new JSONObject().put("types", (Object)new JSONObject().put("*", (Object)new JSONObject().put("access", (Object)new JSONArray())));
    private final String databaseName;
    private final String userName;
    private String[] groups;
    private volatile boolean[][] fileAccessMap = null;
    private long resultSetLimit = -1L;
    private long readTimeout = -1L;
    private final boolean[] databaseAccessMap = new boolean[SecurityDatabaseUser.DATABASE_ACCESS.values().length];

    public ServerSecurityDatabaseUser(String databaseName, String userName, String[] groups) {
        this.databaseName = databaseName;
        this.userName = userName;
        this.groups = groups;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void addGroup(String group) {
        HashSet<String> set = new HashSet<String>(List.of(this.groups));
        if (set.add(group)) {
            this.groups = set.toArray(new String[set.size()]);
        }
    }

    public String getName() {
        return this.userName;
    }

    public long getResultSetLimit() {
        return this.resultSetLimit;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean requestAccessOnDatabase(SecurityDatabaseUser.DATABASE_ACCESS access) {
        return this.databaseAccessMap[access.ordinal()];
    }

    public boolean requestAccessOnFile(int fileId, SecurityDatabaseUser.ACCESS access) {
        if (fileId >= this.fileAccessMap.length) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on requesting access to fileId %d because not found in security configuration (registeredFiles=%d)", (Object)fileId, (Object)this.fileAccessMap.length);
            return false;
        }
        boolean[] permissions = this.fileAccessMap[fileId];
        int index = access.ordinal();
        if (permissions != null) {
            if (index >= permissions.length) {
                throw new ServerSecurityException("Attempt to access to a profiled resources while the security map was refreshing");
            }
            return permissions[index];
        }
        return true;
    }

    public void updateDatabaseConfiguration(JSONObject configuredGroups) {
        for (int i = 0; i < SecurityDatabaseUser.DATABASE_ACCESS.values().length; ++i) {
            this.databaseAccessMap[i] = false;
        }
        if (configuredGroups == null) {
            return;
        }
        JSONArray access = null;
        for (String groupName : this.groups) {
            long value;
            if (!configuredGroups.has(groupName)) continue;
            JSONObject group = configuredGroups.getJSONObject(groupName);
            if (group.has("access")) {
                access = group.getJSONArray("access");
            }
            if (group.has("resultSetLimit") && (value = group.getLong("resultSetLimit")) > -1L && (this.resultSetLimit == -1L || value < this.resultSetLimit)) {
                this.resultSetLimit = value;
            }
            if (!group.has("readTimeout") || (value = group.getLong("readTimeout")) <= -1L || this.readTimeout != -1L && value >= this.readTimeout) continue;
            this.readTimeout = value;
        }
        if (access == null && configuredGroups.has("*")) {
            long value;
            long value2;
            JSONObject defaultGroup = configuredGroups.getJSONObject("*");
            if (defaultGroup.has("access")) {
                access = defaultGroup.getJSONArray("access");
            }
            if (defaultGroup.has("resultSetLimit") && (value2 = defaultGroup.getLong("resultSetLimit")) > -1L && (this.resultSetLimit == -1L || value2 < this.resultSetLimit)) {
                this.resultSetLimit = value2;
            }
            if (defaultGroup.has("readTimeout") && (value = defaultGroup.getLong("readTimeout")) > -1L && (this.readTimeout == -1L || value < this.readTimeout)) {
                this.readTimeout = value;
            }
        }
        if (access != null) {
            for (int i = 0; i < access.length(); ++i) {
                this.databaseAccessMap[SecurityDatabaseUser.DATABASE_ACCESS.getByName((String)access.getString((int)i)).ordinal()] = true;
            }
        }
    }

    public synchronized void updateFileAccess(DatabaseInternal database, JSONObject configuredGroups) {
        if (configuredGroups == null) {
            return;
        }
        List files = database.getFileManager().getFiles();
        boolean[][] newFileAccessMap = new boolean[files.size()][];
        JSONObject defaultGroup = configuredGroups.has("*") ? configuredGroups.getJSONObject("*") : NO_ACCESS_GROUP;
        JSONObject defaultType = defaultGroup.getJSONObject("types").getJSONObject("*");
        for (int i = 0; i < newFileAccessMap.length; ++i) {
            DocumentType type = database.getSchema().getInvolvedTypeByBucketId(i);
            if (type == null) continue;
            String typeName = type.getName();
            for (String groupName : this.groups) {
                JSONObject groupType;
                JSONObject group;
                if (!configuredGroups.has(groupName) || !(group = configuredGroups.getJSONObject(groupName)).has("types")) continue;
                JSONObject types = group.getJSONObject("types");
                JSONObject jSONObject = groupType = types.has(typeName) ? types.getJSONObject(typeName) : null;
                if (groupType == null) {
                    JSONObject jSONObject2 = groupType = types.has("*") ? types.getJSONObject("*") : null;
                }
                if (groupType == null) continue;
                if (newFileAccessMap[i] == null) {
                    newFileAccessMap[i] = new boolean[]{false, false, false, false};
                }
                ServerSecurityDatabaseUser.updateAccessArray(newFileAccessMap[i], groupType.getJSONArray("access"));
            }
            if (newFileAccessMap[i] != null) continue;
            newFileAccessMap[i] = new boolean[]{false, false, false, false};
            JSONObject t = defaultGroup.has(typeName) ? defaultGroup.getJSONObject(typeName) : defaultType;
            ServerSecurityDatabaseUser.updateAccessArray(newFileAccessMap[i], t.getJSONArray("access"));
        }
        this.fileAccessMap = newFileAccessMap;
    }

    private static boolean[] updateAccessArray(boolean[] array, JSONArray access) {
        block12: for (int i = 0; i < access.length(); ++i) {
            switch (access.getString(i)) {
                case "createRecord": {
                    array[0] = true;
                    continue block12;
                }
                case "readRecord": {
                    array[1] = true;
                    continue block12;
                }
                case "updateRecord": {
                    array[2] = true;
                    continue block12;
                }
                case "deleteRecord": {
                    array[3] = true;
                }
            }
        }
        return array;
    }
}

