/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ws;

import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.AbstractServerHttpHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.http.ws.WebSocketEventBus;
import com.arcadedb.server.http.ws.WebSocketReceiveListener;
import com.arcadedb.server.security.ServerSecurityUser;
import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import java.util.UUID;
import org.xnio.ChannelListener;

public class WebSocketConnectionHandler
extends AbstractServerHttpHandler {
    private final WebSocketEventBus webSocketEventBus;

    public WebSocketConnectionHandler(HttpServer httpServer, WebSocketEventBus webSocketEventBus) {
        super(httpServer);
        this.webSocketEventBus = webSocketEventBus;
    }

    @Override
    protected ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user) throws Exception {
        WebSocketProtocolHandshakeHandler handler = new WebSocketProtocolHandshakeHandler((webSocketHttpExchange, channel) -> {
            channel.getReceiveSetter().set((ChannelListener)new WebSocketReceiveListener(this.httpServer, this.webSocketEventBus));
            channel.setAttribute("ID", (Object)UUID.randomUUID());
            channel.resumeReceives();
        });
        handler.handleRequest(exchange);
        return null;
    }
}

