/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ws;

import com.arcadedb.database.Database;
import com.arcadedb.event.AfterRecordCreateListener;
import com.arcadedb.event.AfterRecordDeleteListener;
import com.arcadedb.event.AfterRecordUpdateListener;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.http.ws.ChangeEvent;
import com.arcadedb.server.http.ws.WebSocketEventBus;
import com.arcadedb.server.http.ws.WebSocketEventListener;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class DatabaseEventWatcherThread
extends Thread {
    private final WebSocketEventBus eventBus;
    private final ArrayBlockingQueue<ChangeEvent> eventQueue;
    private final Database database;
    private volatile boolean running = true;
    private final CountDownLatch runningLock;
    private final WebSocketEventListener listener;

    public DatabaseEventWatcherThread(WebSocketEventBus eventBus, Database database, int queueSize) {
        super("WS-Events-" + database.getName());
        this.eventBus = eventBus;
        this.eventQueue = new ArrayBlockingQueue(queueSize);
        this.database = database;
        this.listener = new WebSocketEventListener(this);
        this.runningLock = new CountDownLatch(1);
        this.database.getEvents().registerListener((AfterRecordCreateListener)this.listener).registerListener((AfterRecordUpdateListener)this.listener).registerListener((AfterRecordDeleteListener)this.listener);
    }

    public void push(ChangeEvent event) {
        if (!this.running) {
            return;
        }
        if (!this.eventQueue.offer(event)) {
            LogManager.instance().log((Object)this, Level.WARNING, "Skipping event for database %s as eventQueue is full. Consider increasing eventBusQueueSize", null, (Object)this.database.getName());
        }
    }

    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.runningLock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                ChangeEvent event = this.eventQueue.poll(500L, TimeUnit.MILLISECONDS);
                if (event == null) continue;
                this.eventBus.publish(event);
            }
        }
        catch (InterruptedException interruptedException) {
            try {
                this.database.getEvents().unregisterListener((AfterRecordCreateListener)this.listener).unregisterListener((AfterRecordUpdateListener)this.listener).unregisterListener((AfterRecordDeleteListener)this.listener);
                this.eventQueue.clear();
            }
            finally {
                this.runningLock.countDown();
            }
        }
        finally {
            try {
                this.database.getEvents().unregisterListener((AfterRecordCreateListener)this.listener).unregisterListener((AfterRecordUpdateListener)this.listener).unregisterListener((AfterRecordDeleteListener)this.listener);
                this.eventQueue.clear();
            }
            finally {
                this.runningLock.countDown();
            }
        }
    }
}

