/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ssl;

import java.util.Arrays;

public enum KeystoreType {
    PKCS12("PKCS12"),
    JKS("JKS");

    private final String keystoreType;

    private KeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public static KeystoreType validateFromString(String keystoreType) {
        return Arrays.stream(KeystoreType.values()).filter(enumValue -> enumValue.getKeystoreType().equalsIgnoreCase(keystoreType)).findFirst().orElseThrow(() -> new RuntimeException("Specified key store type is not valid"));
    }

    public static KeystoreType getFromStringWithDefault(String keystoreType, KeystoreType defaultKeystoreType) {
        return Arrays.stream(KeystoreType.values()).filter(enumValue -> enumValue.getKeystoreType().equalsIgnoreCase(keystoreType)).findFirst().orElse(defaultKeystoreType);
    }
}

