/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.AbstractServerHttpHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityUser;
import io.micrometer.core.instrument.Metrics;
import io.undertow.server.HttpServerExchange;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class GetExistsDatabaseHandler
extends AbstractServerHttpHandler {
    public GetExistsDatabaseHandler(HttpServer httpServer) {
        super(httpServer);
    }

    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user) {
        Deque databaseName = (Deque)exchange.getQueryParameters().get("database");
        if (databaseName.isEmpty()) {
            return new ExecutionResponse(400, "{ \"error\" : \"Database parameter is null\"}");
        }
        ArcadeDBServer server = this.httpServer.getServer();
        Metrics.counter((String)"http.exists-database", (String[])new String[0]).increment();
        HashSet<String> installedDatabases = new HashSet<String>(server.getDatabaseNames());
        Set<String> allowedDatabases = user.getAuthorizedDatabases();
        if (!allowedDatabases.contains("*")) {
            installedDatabases.retainAll(allowedDatabases);
        }
        boolean existsDatabase = installedDatabases.contains(databaseName.getFirst());
        JSONObject response = this.createResult(user, null);
        response.put("result", Boolean.valueOf(existsDatabase));
        return new ExecutionResponse(200, response.toString());
    }
}

