/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.DatabaseAlignResponse;
import com.arcadedb.server.ha.message.FileContentRequest;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class DatabaseAlignRequest
extends HAAbstractCommand {
    private String databaseName;
    private String schemaJson;
    private Map<Integer, Long> fileChecksums;
    private Map<Integer, Long> fileSizes;

    public DatabaseAlignRequest() {
    }

    public DatabaseAlignRequest(String databaseName, String schemaJson, Map<Integer, Long> fileChecksums, Map<Integer, Long> fileSizes) {
        this.databaseName = databaseName;
        this.schemaJson = schemaJson;
        this.fileChecksums = fileChecksums;
        this.fileSizes = fileSizes;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
        stream.putString(this.schemaJson);
        stream.putUnsignedNumber((long)this.fileChecksums.size());
        for (Map.Entry<Integer, Long> file : this.fileChecksums.entrySet()) {
            stream.putInt(file.getKey().intValue());
            stream.putLong(file.getValue().longValue());
        }
        stream.putUnsignedNumber((long)this.fileSizes.size());
        for (Map.Entry<Integer, Long> file : this.fileSizes.entrySet()) {
            stream.putInt(file.getKey().intValue());
            stream.putLong(file.getValue().longValue());
        }
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        int fileId;
        int i;
        this.databaseName = stream.getString();
        this.schemaJson = stream.getString();
        this.fileChecksums = new HashMap<Integer, Long>();
        int fileCount = (int)stream.getUnsignedNumber();
        for (i = 0; i < fileCount; ++i) {
            fileId = stream.getInt();
            this.fileChecksums.put(fileId, stream.getLong());
        }
        this.fileSizes = new HashMap<Integer, Long>();
        fileCount = (int)stream.getUnsignedNumber();
        for (i = 0; i < fileCount; ++i) {
            fileId = stream.getInt();
            this.fileSizes.put(fileId, stream.getLong());
        }
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        ServerDatabase database = server.getServer().getDatabase(this.databaseName);
        ArrayList<int[]> pagesToAlign = new ArrayList<int[]>();
        database.executeInReadLock(() -> {
            database.getPageManager().suspendFlushAndExecute((Database)database, () -> {
                for (Map.Entry<Integer, Long> entry : this.fileSizes.entrySet()) {
                    long localFileChecksum;
                    Integer fileId = entry.getKey();
                    ComponentFile file = database.getFileManager().getFile(fileId.intValue());
                    Long leaderFileSize = entry.getValue();
                    if (file.getSize() < leaderFileSize) {
                        pagesToAlign.add(new int[]{fileId, 0, -1});
                        LogManager.instance().log((Object)this, Level.INFO, "File %d size %s <> leader %s: requesting the entire file from the leader", null, (Object)fileId, (Object)file.getSize(), (Object)leaderFileSize);
                        continue;
                    }
                    Long leaderFileChecksum = this.fileChecksums.get(fileId);
                    if (leaderFileChecksum == null || (localFileChecksum = file.calculateChecksum()) == leaderFileChecksum) continue;
                    pagesToAlign.add(new int[]{fileId, 0, -1});
                    LogManager.instance().log((Object)this, Level.INFO, "File %d checksum %s <> leader %s: requesting the entire file from the leader", null, (Object)fileId, (Object)localFileChecksum, (Object)leaderFileChecksum);
                }
                Binary buffer = new Binary();
                for (int[] entry : pagesToAlign) {
                    FileContentRequest fileAlign = new FileContentRequest(this.databaseName, entry[0], entry[1], entry[2]);
                    server.getLeader().sendCommandToLeader(buffer, fileAlign, -1L);
                }
            });
            return null;
        });
        return new DatabaseAlignResponse(pagesToAlign);
    }

    public String toString() {
        return "DatabaseAlignRequest{" + this.databaseName + " fileChecksum=" + String.valueOf(this.fileChecksums) + " fileSizes=" + String.valueOf(this.fileSizes) + "}";
    }
}

