/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.security;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.log.LogManager;
import com.arcadedb.security.SecurityManager;
import com.arcadedb.serializer.json.JSONException;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.DefaultConsoleReader;
import com.arcadedb.server.ServerException;
import com.arcadedb.server.ServerPlugin;
import com.arcadedb.server.security.SecurityGroupFileRepository;
import com.arcadedb.server.security.SecurityUserFileRepository;
import com.arcadedb.server.security.ServerSecurityDatabaseUser;
import com.arcadedb.server.security.ServerSecurityException;
import com.arcadedb.server.security.ServerSecurityUser;
import com.arcadedb.server.security.credential.CredentialsValidator;
import com.arcadedb.server.security.credential.DefaultCredentialsValidator;
import com.arcadedb.utility.AnsiCode;
import com.arcadedb.utility.Callable;
import com.arcadedb.utility.LRUCache;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class ServerSecurity
implements ServerPlugin,
SecurityManager {
    public static final int LATEST_VERSION = 1;
    private final ArcadeDBServer server;
    private final SecurityUserFileRepository usersRepository;
    private final SecurityGroupFileRepository groupRepository;
    private final String algorithm;
    private final SecretKeyFactory secretKeyFactory;
    private final Map<String, String> saltCache;
    private final int saltIteration;
    private final Map<String, ServerSecurityUser> users = new HashMap<String, ServerSecurityUser>();
    private final int checkConfigReloadEveryMs;
    private CredentialsValidator credentialsValidator = new DefaultCredentialsValidator();
    private static final Random RANDOM = new SecureRandom();
    public static final int SALT_SIZE = 32;
    private Timer reloadConfigurationTimer;

    public ServerSecurity(ArcadeDBServer server, ContextConfiguration configuration, String configPath) {
        this.server = server;
        this.algorithm = configuration.getValueAsString(GlobalConfiguration.SERVER_SECURITY_ALGORITHM);
        this.checkConfigReloadEveryMs = configuration.getValueAsInteger(GlobalConfiguration.SERVER_SECURITY_RELOAD_EVERY);
        int cacheSize = configuration.getValueAsInteger(GlobalConfiguration.SERVER_SECURITY_SALT_CACHE_SIZE);
        this.saltCache = cacheSize > 0 ? Collections.synchronizedMap(new LRUCache(cacheSize)) : Collections.emptyMap();
        this.saltIteration = configuration.getValueAsInteger(GlobalConfiguration.SERVER_SECURITY_SALT_ITERATIONS);
        this.usersRepository = new SecurityUserFileRepository(configPath);
        this.groupRepository = new SecurityGroupFileRepository(configPath, this.checkConfigReloadEveryMs).onReload((Callable<Void, JSONObject>)((Callable)latestConfiguration -> {
            for (String databaseName : server.getDatabaseNames()) {
                this.updateSchema(server.getDatabase(databaseName));
            }
            return null;
        }));
        try {
            this.secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Security algorithm '%s' not available (error=%s)", (Throwable)e, (Object)this.algorithm);
            throw new ServerSecurityException("Security algorithm '" + this.algorithm + "' not available", e);
        }
    }

    @Override
    public void configure(ArcadeDBServer arcadeDBServer, ContextConfiguration configuration) {
    }

    @Override
    public void startService() {
    }

    public void loadUsers() {
        try {
            long fileLastModified;
            this.users.clear();
            try {
                for (JSONObject userJson : this.usersRepository.getUsers()) {
                    ServerSecurityUser user = new ServerSecurityUser(this.server, userJson);
                    this.users.put(user.getName(), user);
                }
            }
            catch (JSONException e) {
                this.groupRepository.saveInError((Exception)((Object)e));
                for (JSONObject userJson : SecurityUserFileRepository.createDefault()) {
                    ServerSecurityUser user = new ServerSecurityUser(this.server, userJson);
                    this.users.put(user.getName(), user);
                }
            }
            if (this.users.isEmpty() || this.users.containsKey("root") && this.users.get("root").getPassword() == null) {
                this.askForRootPassword();
            }
            if ((fileLastModified = this.usersRepository.getFileLastModified()) > -1L && this.reloadConfigurationTimer == null) {
                this.reloadConfigurationTimer = new Timer();
                this.reloadConfigurationTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (ServerSecurity.this.usersRepository.isUserFileChanged()) {
                            LogManager.instance().log((Object)this, Level.INFO, "Reloading user files...");
                            ServerSecurity.this.loadUsers();
                        }
                    }
                }, this.checkConfigReloadEveryMs, (long)this.checkConfigReloadEveryMs);
            }
        }
        catch (IOException e) {
            throw new ServerException("Error on starting Security service", e);
        }
    }

    @Override
    public void stopService() {
        if (this.reloadConfigurationTimer != null) {
            this.reloadConfigurationTimer.cancel();
        }
        this.users.clear();
        if (this.groupRepository != null) {
            this.groupRepository.stop();
        }
    }

    public ServerSecurityUser authenticate(String userName, String userPassword, String databaseName) {
        Set<String> allowedDatabases;
        ServerSecurityUser su = this.users.get(userName);
        if (su == null) {
            throw new ServerSecurityException("User/Password not valid");
        }
        if (!this.passwordMatch(userPassword, su.getPassword())) {
            throw new ServerSecurityException("User/Password not valid");
        }
        if (databaseName != null && !(allowedDatabases = su.getAuthorizedDatabases()).contains("*") && !su.getAuthorizedDatabases().contains(databaseName)) {
            throw new ServerSecurityException("User has not access to database '" + databaseName + "'");
        }
        return su;
    }

    public void setCredentialsValidator(CredentialsValidator credentialsValidator) {
        this.credentialsValidator = credentialsValidator;
    }

    public boolean existsUser(String userName) {
        return this.users.containsKey(userName);
    }

    public Set<String> getUsers() {
        return this.users.keySet();
    }

    public ServerSecurityUser getUser(String userName) {
        return this.users.get(userName);
    }

    public ServerSecurityUser createUser(JSONObject userConfiguration) {
        String name = userConfiguration.getString("name");
        if (this.users.containsKey(name)) {
            throw new SecurityException("User '" + name + "' already exists");
        }
        ServerSecurityUser user = new ServerSecurityUser(this.server, userConfiguration);
        this.users.put(name, user);
        this.saveUsers();
        return user;
    }

    public boolean dropUser(String userName) {
        if (this.users.remove(userName) != null) {
            this.saveUsers();
            return true;
        }
        return false;
    }

    public void updateSchema(DatabaseInternal database) {
        if (database == null) {
            return;
        }
        for (ServerSecurityUser user : this.users.values()) {
            JSONObject groupConfiguration;
            ServerSecurityDatabaseUser databaseUser = user.getDatabaseUser((Database)database);
            if (databaseUser == null || (groupConfiguration = this.getDatabaseGroupsConfiguration(database.getName())) == null) continue;
            databaseUser.updateFileAccess(database, groupConfiguration);
        }
    }

    public String getEncodedHash(String password, String salt, int iterations) {
        SecretKey secret;
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt.getBytes(StandardCharsets.UTF_8), iterations, 256);
        try {
            secret = this.secretKeyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new ServerSecurityException("Error on generating security key", e);
        }
        byte[] rawHash = secret.getEncoded();
        byte[] hashBase64 = Base64.getEncoder().encode(rawHash);
        return new String(hashBase64, DatabaseFactory.getDefaultCharset());
    }

    protected String encodePassword(String password, String salt) {
        return this.encodePassword(password, salt, this.saltIteration);
    }

    public String encodePassword(String userPassword) {
        return this.encodePassword(userPassword, ServerSecurity.generateRandomSalt());
    }

    public boolean passwordMatch(String password, String hashedPassword) {
        String[] parts = hashedPassword.split("\\$");
        if (parts.length != 4) {
            return false;
        }
        int iterations = Integer.parseInt(parts[1]);
        String salt = parts[2];
        String hash = this.encodePassword(password, salt, iterations);
        return hash.equals(hashedPassword);
    }

    protected static String generateRandomSalt() {
        byte[] salt = new byte[32];
        RANDOM.nextBytes(salt);
        return new String(Base64.getEncoder().encode(salt), DatabaseFactory.getDefaultCharset());
    }

    protected String encodePassword(String password, String salt, int iterations) {
        String encoded;
        if (!this.saltCache.isEmpty() && (encoded = this.saltCache.get(password + "$" + salt + "$" + iterations)) != null) {
            return encoded;
        }
        String hash = this.getEncodedHash(password, salt, iterations);
        String encoded2 = "%s$%d$%s$%s".formatted(this.algorithm, iterations, salt, hash);
        this.saltCache.put(password + "$" + salt + "$" + iterations, encoded2);
        return encoded2;
    }

    public List<JSONObject> usersToJSON() {
        ArrayList<JSONObject> jsonl = new ArrayList<JSONObject>(this.users.size());
        for (ServerSecurityUser user : this.users.values()) {
            jsonl.add(user.toJSON());
        }
        return jsonl;
    }

    public JSONObject groupsToJSON() {
        JSONObject json = new JSONObject();
        json.put("databases", (Object)this.groupRepository.getGroups().getJSONObject("databases"));
        json.put("version", (Number)1);
        return json;
    }

    public void saveUsers() {
        try {
            this.usersRepository.save(this.usersToJSON());
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on saving security configuration to file '%s'", (Throwable)e, (Object)"server-users.jsonl");
        }
    }

    public void saveGroups() {
        try {
            this.groupRepository.save(this.groupsToJSON());
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on saving security configuration to file '%s'", (Throwable)e, (Object)"server-groups.json");
        }
    }

    protected void askForRootPassword() throws IOException {
        String rootPassword;
        String string = rootPassword = this.server != null ? this.server.getConfiguration().getValueAsString(GlobalConfiguration.SERVER_ROOT_PASSWORD) : GlobalConfiguration.SERVER_ROOT_PASSWORD.getValueAsString();
        if (rootPassword == null) {
            String rootPasswordPath;
            String string2 = rootPasswordPath = this.server != null ? this.server.getConfiguration().getValueAsString(GlobalConfiguration.SERVER_ROOT_PASSWORD_PATH) : GlobalConfiguration.SERVER_ROOT_PASSWORD_PATH.getValueAsString();
            if (rootPasswordPath != null) {
                if (Files.isReadable(Path.of(rootPasswordPath, new String[0]))) {
                    rootPassword = Files.readString(Path.of(rootPasswordPath, new String[0]));
                } else {
                    throw new ServerSecurityException("Error reading password file at path '" + rootPasswordPath + "'");
                }
            }
        }
        if (rootPassword == null) {
            if (this.server != null ? this.server.getConfiguration().getValueAsBoolean(GlobalConfiguration.HA_K8S) : GlobalConfiguration.HA_K8S.getValueAsBoolean()) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Unable to start a server under Kubernetes if the environment variable `arcadedb.server.rootPassword` is not set");
                throw new ServerSecurityException("Unable to start a server under Kubernetes if the environment variable `arcadedb.server.rootPassword` is not set");
            }
            LogManager.instance().flush();
            System.err.flush();
            System.out.flush();
            System.out.println();
            System.out.println();
            System.out.println(AnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------+}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow |                WARNING: FIRST RUN CONFIGURATION                    |}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------+}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow | This is the first time the server is running. Please type a        |}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow | password of your choice for the 'root' user or leave it blank      |}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow | to auto-generate it.                                               |}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow |                                                                    |}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow | To avoid this message set the environment variable or JVM          |}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow | setting `arcadedb.server.rootPassword` to the root password to use.|}"));
            System.out.println(AnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------+}"));
            DefaultConsoleReader console = new DefaultConsoleReader();
            do {
                System.out.print(AnsiCode.format((String)"\n$ANSI{yellow Root password [BLANK=auto generate it]: }"));
                rootPassword = console.readPassword();
                if (rootPassword != null && (rootPassword = rootPassword.trim()).isEmpty()) {
                    rootPassword = null;
                }
                if (rootPassword == null) {
                    rootPassword = this.credentialsValidator.generateRandomPassword();
                    System.out.print(AnsiCode.format((String)("Automatic generated password: $ANSI{green " + rootPassword + "}. Please save it in a safe place.\n")));
                }
                if (rootPassword == null) continue;
                System.out.print(AnsiCode.format((String)"$ANSI{yellow Please type the root password for confirmation (copy and paste will not work): }"));
                String rootConfirmPassword = console.readPassword();
                if (rootConfirmPassword != null && (rootConfirmPassword = rootConfirmPassword.trim()).isEmpty()) {
                    rootConfirmPassword = null;
                }
                if (!rootPassword.equals(rootConfirmPassword)) {
                    System.out.println(AnsiCode.format((String)"$ANSI{red ERROR: Passwords do not match, please reinsert both of them, or press ENTER to auto generate it}"));
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    rootPassword = null;
                    continue;
                }
                try {
                    this.credentialsValidator.validateCredentials("root", rootPassword);
                    break;
                }
                catch (ServerSecurityException ex) {
                    System.out.println(AnsiCode.format((String)("$ANSI{red ERROR: Root password does not match the password policies" + (String)(ex.getMessage() != null ? ": " + ex.getMessage() : "") + "}")));
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    rootPassword = null;
                }
            } while (rootPassword == null);
        } else {
            LogManager.instance().log((Object)this, Level.INFO, "Creating root user with the provided password");
        }
        this.credentialsValidator.validateCredentials("root", rootPassword);
        String encodedPassword = this.encodePassword(rootPassword, ServerSecurity.generateRandomSalt());
        if (this.existsUser("root")) {
            this.getUser("root").setPassword(encodedPassword);
            this.saveUsers();
        } else {
            this.createUser(new JSONObject().put("name", "root").put("password", encodedPassword));
        }
    }

    protected JSONObject getDatabaseGroupsConfiguration(String databaseName) {
        JSONObject databaseConfiguration;
        JSONObject groupDatabases = this.groupRepository.getGroups().getJSONObject("databases");
        JSONObject jSONObject = databaseConfiguration = groupDatabases.has(databaseName) ? groupDatabases.getJSONObject(databaseName) : null;
        if (databaseConfiguration == null) {
            JSONObject jSONObject2 = databaseConfiguration = groupDatabases.has("*") ? groupDatabases.getJSONObject("*") : null;
        }
        if (databaseConfiguration == null || !databaseConfiguration.has("groups")) {
            return null;
        }
        return databaseConfiguration.getJSONObject("groups");
    }
}

