/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.database.Database;
import com.arcadedb.database.async.AsyncResultsetCallback;
import com.arcadedb.log.LogManager;
import com.arcadedb.query.sql.executor.ExecutionPlan;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.AbstractQueryHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityUser;
import io.micrometer.core.instrument.Metrics;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class PostCommandHandler
extends AbstractQueryHandler {
    public PostCommandHandler(HttpServer httpServer) {
        super(httpServer);
    }

    @Override
    protected boolean mustExecuteOnWorkerThread() {
        return true;
    }

    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user, Database database) throws IOException {
        String commandLC;
        String payload = this.parseRequestPayload(exchange);
        if (payload == null || payload.isEmpty()) {
            return new ExecutionResponse(400, "{ \"error\" : \"Command text is null\"}");
        }
        JSONObject json = new JSONObject(payload);
        Map requestMap = json.toMap();
        if (requestMap.get("command") == null) {
            throw new IllegalArgumentException("command missing");
        }
        String language = (String)requestMap.get("language");
        Object command = this.decode((String)requestMap.get("command"));
        int limit = requestMap.getOrDefault("limit", 20000);
        String serializer = requestMap.getOrDefault("serializer", "record");
        String profileExecution = requestMap.getOrDefault("profileExecution", null);
        if (command == null || ((String)command).isEmpty()) {
            return new ExecutionResponse(400, "{ \"error\" : \"Command text is null\"}");
        }
        if (language == null || language.isEmpty()) {
            return new ExecutionResponse(400, "{ \"error\" : \"Language is null\"}");
        }
        command = ((String)command).trim();
        HashMap<String, Object> paramMap = (HashMap<String, Object>)requestMap.get("params");
        if (paramMap == null) {
            paramMap = new HashMap<String, Object>();
        }
        if (limit != -1 && (language.equalsIgnoreCase("sql") || language.equalsIgnoreCase("sqlScript")) && ((commandLC = ((String)command).toLowerCase(Locale.ENGLISH).trim()).startsWith("select") || commandLC.startsWith("match")) && !commandLC.endsWith(";")) {
            if (!commandLC.contains(" limit ") && !commandLC.contains("\nlimit ")) {
                command = (String)command + " limit " + limit;
            } else {
                String[] lines = commandLC.split("\\R");
                String[] words = lines[lines.length - 1].split(" ");
                if (!(words.length <= 1 || "limit".equals(words[words.length - 2]) || words.length >= 5 && "limit".equals(words[words.length - 4]))) {
                    command = (String)command + " limit " + limit;
                }
            }
        }
        if (language.equalsIgnoreCase("sqlScript") && !((String)command).endsWith(";")) {
            command = (String)command + ";";
        }
        if ("detailed".equalsIgnoreCase(profileExecution)) {
            paramMap.put("$profileExecution", true);
        }
        boolean awaitResponse = true;
        if (requestMap.containsKey("awaitResponse") && requestMap.get("awaitResponse") instanceof Boolean) {
            awaitResponse = (Boolean)requestMap.get("awaitResponse");
        }
        if (!awaitResponse) {
            this.executeCommandAsync(database, language, (String)command, paramMap);
            return new ExecutionResponse(202, "{ \"result\": \"Command accepted for asynchronous execution\"}");
        }
        ResultSet qResult = this.executeCommand(database, language, (String)command, paramMap);
        JSONObject response = this.createResult(user, database);
        this.serializeResultSet(database, serializer, limit, response, qResult);
        if (qResult != null && profileExecution != null && qResult.getExecutionPlan().isPresent()) {
            qResult.getExecutionPlan().ifPresent(x -> response.put("explain", ((ExecutionPlan)qResult.getExecutionPlan().get()).prettyPrint(0, 2)));
        }
        Metrics.counter((String)"http.command", (String[])new String[0]).increment();
        return new ExecutionResponse(200, response.toString());
    }

    protected ResultSet executeCommand(Database database, String language, String command, Map<String, Object> paramMap) {
        Object params = this.mapParams(paramMap);
        if (params instanceof Object[]) {
            Object[] objects = (Object[])params;
            return database.command(language, command, this.httpServer.getServer().getConfiguration(), objects);
        }
        return database.command(language, command, this.httpServer.getServer().getConfiguration(), (Map)params);
    }

    protected void executeCommandAsync(final Database database, String language, String command, Map<String, Object> paramMap) {
        Object[] os;
        Object params = this.mapParams(paramMap);
        database.async().command(language, command, new AsyncResultsetCallback(){

            public void onComplete(ResultSet rs) {
                LogManager.instance().log((Object)this, Level.INFO, "Async command in database \"%s\" completed.", null, (Object)database.getName());
            }

            public void onError(Exception exception) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Async command in database \"%s\" failed.", null, (Object)database.getName());
                LogManager.instance().log((Object)this, Level.SEVERE, "", (Throwable)exception);
            }
        }, new Object[]{params instanceof Object[] ? (os = (Object[])params) : (Object[])params});
    }
}

