/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.server.ha.message.ReplicaConnectFullResyncResponse;
import com.arcadedb.server.ha.message.ReplicaConnectHotResyncResponse;
import java.util.logging.Level;

public class ReplicaConnectRequest
extends HAAbstractCommand {
    private long lastReplicationMessageNumber = -1L;

    public ReplicaConnectRequest() {
    }

    public ReplicaConnectRequest(long lastReplicationMessageNumber) {
        this.lastReplicationMessageNumber = lastReplicationMessageNumber;
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        if (this.lastReplicationMessageNumber > -1L) {
            LogManager.instance().log((Object)this, Level.INFO, "Hot backup with Replica server '%s' is possible (lastReplicationMessageNumber=%d)", (Object)remoteServerName, (Object)this.lastReplicationMessageNumber);
            return new ReplicaConnectHotResyncResponse(this.lastReplicationMessageNumber);
        }
        return new ReplicaConnectFullResyncResponse(server.getServer().getDatabaseNames());
    }

    @Override
    public void toStream(Binary stream) {
        stream.putLong(this.lastReplicationMessageNumber);
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.lastReplicationMessageNumber = stream.getLong();
    }

    public String toString() {
        return "connect(" + this.lastReplicationMessageNumber + ")";
    }
}

