/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Binary;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.engine.LocalBucket;
import com.arcadedb.engine.MutablePage;
import com.arcadedb.engine.PageId;
import com.arcadedb.engine.PageManager;
import com.arcadedb.engine.PaginatedComponent;
import com.arcadedb.engine.PaginatedComponentFile;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.ReplicationException;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.utility.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class FileContentResponse
extends HAAbstractCommand {
    private String databaseName;
    private int fileId;
    private String fileName;
    private int pageFromInclusive;
    private Binary pagesContent;
    private int totalPages;
    private boolean last;

    public FileContentResponse() {
    }

    public FileContentResponse(String databaseName, int fileId, String fileName, int pageFromInclusive, Binary pagesContent, int totalPages, boolean last) {
        this.databaseName = databaseName;
        this.fileId = fileId;
        this.fileName = fileName;
        this.pageFromInclusive = pageFromInclusive;
        this.pagesContent = pagesContent;
        this.totalPages = totalPages;
        this.last = last;
    }

    public Binary getPagesContent() {
        return this.pagesContent;
    }

    public int getPages() {
        return this.totalPages;
    }

    public boolean isLast() {
        return this.last;
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        ServerDatabase database = server.getServer().getDatabase(this.databaseName);
        PageManager pageManager = database.getPageManager();
        try {
            ComponentFile file = database.getFileManager().getOrCreateFile(this.fileId, database.getDatabasePath() + File.separator + this.fileName);
            if (this.totalPages == 0) {
                return null;
            }
            if (file instanceof PaginatedComponentFile) {
                PaginatedComponentFile pFile = (PaginatedComponentFile)file;
                int pageSize = pFile.getPageSize();
                if (this.pagesContent.size() != this.totalPages * pageSize) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Error on received chunk for file '%s': size=%s, expected=%s (totalPages=%d)", (Object)file.getFileName(), (Object)FileUtils.getSizeAsString((long)this.pagesContent.size()), (Object)FileUtils.getSizeAsString((long)((long)this.totalPages * (long)pageSize)), (Object)this.totalPages);
                    throw new ReplicationException("Invalid file chunk");
                }
                for (int i = 0; i < this.totalPages; ++i) {
                    PageId pageId = new PageId((BasicDatabase)database, file.getFileId(), this.pageFromInclusive + i);
                    MutablePage page = new MutablePage(pageId, pageSize);
                    System.arraycopy(this.pagesContent.getContent(), i * pageSize, page.getTrackable().getContent(), 0, pageSize);
                    page.loadMetadata();
                    pageManager.overwritePage(page);
                    LogManager.instance().log((Object)this, Level.FINE, "Overwritten page %s v%d from the leader", null, (Object)pageId, (Object)page.getVersion());
                }
                PaginatedComponent component = (PaginatedComponent)database.getSchema().getFileByIdIfExists(file.getFileId());
                if (component != null) {
                    int lastPageNumber = this.pageFromInclusive + this.totalPages;
                    if (lastPageNumber > component.getTotalPages()) {
                        component.setPageCount(lastPageNumber);
                        database.getFileManager().setVirtualFileSize(Integer.valueOf(file.getFileId()), (long)component.getTotalPages() * (long)((PaginatedComponentFile)database.getFileManager().getFile(file.getFileId())).getPageSize());
                    }
                    if (component instanceof LocalBucket) {
                        LocalBucket bucket = (LocalBucket)component;
                        bucket.setCachedRecordCount(-1L);
                    }
                }
            } else {
                LogManager.instance().log((Object)this, Level.SEVERE, "Cannot write not paginated file %s from the leader", (Object)this.fileName);
            }
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on installing file content from leader server", (Throwable)e);
            throw new ReplicationException("Error on installing file content from leader server", e);
        }
        return null;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
        stream.putInt(this.fileId);
        stream.putString(this.fileName);
        stream.putInt(this.pageFromInclusive);
        stream.putUnsignedNumber((long)this.totalPages);
        stream.putBytes(this.pagesContent.getContent(), this.pagesContent.size());
        stream.putByte((byte)(this.last ? 1 : 0));
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.databaseName = stream.getString();
        this.fileId = stream.getInt();
        this.fileName = stream.getString();
        this.pageFromInclusive = stream.getInt();
        this.totalPages = (int)stream.getUnsignedNumber();
        this.pagesContent = new Binary(stream.getBytes());
        this.last = stream.getByte() == 1;
    }

    public String toString() {
        return "file=" + this.totalPages + " pages (" + this.pagesContent.size() + " bytes)";
    }
}

