/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.util.HashMap;
import java.util.Map;

public class DatabaseStructureResponse
extends HAAbstractCommand {
    private String schemaJson;
    private Map<Integer, String> fileNames;
    private long currentLogNumber;

    public DatabaseStructureResponse() {
    }

    public DatabaseStructureResponse(String schemaJson, Map<Integer, String> fileNames, long currentLogNumber) {
        this.schemaJson = schemaJson;
        this.fileNames = fileNames;
        this.currentLogNumber = currentLogNumber;
    }

    public Map<Integer, String> getFileNames() {
        return this.fileNames;
    }

    public String getSchemaJson() {
        return this.schemaJson;
    }

    public long getCurrentLogNumber() {
        return this.currentLogNumber;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.schemaJson);
        stream.putLong(this.currentLogNumber);
        stream.putUnsignedNumber((long)this.fileNames.size());
        for (Map.Entry<Integer, String> file : this.fileNames.entrySet()) {
            stream.putInt(file.getKey().intValue());
            stream.putByte((byte)(file.getValue() != null ? 1 : 0));
            if (file.getValue() == null) continue;
            stream.putString(file.getValue());
        }
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.schemaJson = stream.getString();
        this.currentLogNumber = stream.getLong();
        this.fileNames = new HashMap<Integer, String>();
        int fileCount = (int)stream.getUnsignedNumber();
        for (int i = 0; i < fileCount; ++i) {
            boolean notNull;
            int fileId = stream.getInt();
            boolean bl = notNull = stream.getByte() == 1;
            if (notNull) {
                this.fileNames.put(fileId, stream.getString());
                continue;
            }
            this.fileNames.put(fileId, null);
        }
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        return null;
    }

    public String toString() {
        return "dbstructure=" + this.fileNames + " initialLogNumber=" + this.currentLogNumber;
    }
}

