/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha;

import com.arcadedb.exception.ArcadeDBException;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.ChannelBinaryServer;
import com.arcadedb.network.binary.ConnectionException;
import com.arcadedb.server.ReplicationCallback;
import com.arcadedb.server.ServerException;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.Leader2ReplicaNetworkExecutor;
import com.arcadedb.server.ha.Replica2LeaderNetworkExecutor;
import com.arcadedb.server.ha.network.ServerSocketFactory;
import com.arcadedb.utility.Pair;
import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;

public class LeaderNetworkListener
extends Thread {
    private final HAServer ha;
    private final ServerSocketFactory socketFactory;
    private ServerSocket serverSocket;
    private volatile boolean active = true;
    private static final int protocolVersion = -1;
    private final String hostName;
    private int port;

    public LeaderNetworkListener(HAServer ha, ServerSocketFactory iSocketFactory, String iHostName, String iHostPortRange) {
        super(ha.getServerName() + " replication listen at " + iHostName + ":" + iHostPortRange);
        this.ha = ha;
        this.hostName = iHostName;
        this.socketFactory = iSocketFactory;
        this.listen(iHostName, iHostPortRange);
        this.start();
    }

    @Override
    public void run() {
        LogManager.instance().setContext(this.ha.getServerName());
        try {
            while (this.active) {
                try {
                    Socket socket = this.serverSocket.accept();
                    socket.setPerformancePreferences(0, 2, 1);
                    this.handleConnection(socket);
                }
                catch (Exception e) {
                    if (!this.active) continue;
                    String message = e.getMessage() != null ? e.getMessage() : e.toString();
                    LogManager.instance().log((Object)this, Level.FINE, "Error on connection from another server (error=%s)", (Object)message);
                }
            }
        }
        finally {
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getHost() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void close() {
        this.active = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        return this.serverSocket.getLocalSocketAddress().toString();
    }

    private void listen(String hostName, String hostPortRange) {
        for (int tryPort : LeaderNetworkListener.getPorts(hostPortRange)) {
            InetSocketAddress inboundAddr = new InetSocketAddress(hostName, tryPort);
            try {
                this.serverSocket = this.socketFactory.createServerSocket(tryPort, 0, InetAddress.getByName(hostName));
                if (!this.serverSocket.isBound()) continue;
                LogManager.instance().log((Object)this, Level.INFO, "Listening for replication connections on $ANSI{green " + inboundAddr.getAddress().getHostAddress() + ":" + inboundAddr.getPort() + "} " + (String)(this.ha.getServerAddress() != null ? "current host $ANSI{green " + this.ha.getServerAddress() + "} " : "") + "(protocol v.-1)");
                this.port = tryPort;
                this.setName(this.ha.getServerName() + " replication listen at " + hostName + ":" + this.port);
                return;
            }
            catch (BindException be) {
                LogManager.instance().log((Object)this, Level.WARNING, "Port %s:%d busy, trying the next available...", (Object)hostName, (Object)tryPort);
            }
            catch (SocketException se) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Unable to create socket", (Throwable)se);
                throw new ArcadeDBException((Throwable)se);
            }
            catch (IOException ioe) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Unable to read data from an open socket", (Throwable)ioe);
                throw new ArcadeDBException((Throwable)ioe);
            }
        }
        LogManager.instance().log((Object)this, Level.SEVERE, "Unable to listen for connections using the configured ports '%s' on host '%s'", null, (Object)hostPortRange, (Object)hostName);
        throw new ServerException("Unable to listen for connections using the configured ports '" + hostPortRange + "' on host '" + hostName + "'");
    }

    private void handleConnection(Socket socket) throws IOException {
        ChannelBinaryServer channel = new ChannelBinaryServer(socket, this.ha.getServer().getConfiguration());
        long mn = 0L;
        try {
            mn = channel.readLong();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (mn != 20986405762943483L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            socket.close();
            throw new ConnectionException(socket.getInetAddress().toString(), "Bad replication protocol. The connected server is not an ArcadeDB Server");
        }
        this.readProtocolVersion(socket, channel);
        this.readClusterName(socket, channel);
        String remoteServerName = channel.readString();
        String remoteServerAddress = channel.readString();
        String remoteServerHTTPAddress = channel.readString();
        short command = channel.readShort();
        switch (command) {
            case 0: {
                this.connect(channel, remoteServerName, remoteServerAddress, remoteServerHTTPAddress);
                break;
            }
            case 1: {
                this.voteForMe(channel, remoteServerName);
                break;
            }
            case 2: {
                this.electionComplete(channel, remoteServerName, remoteServerAddress);
                break;
            }
            default: {
                throw new ConnectionException(channel.socket.getInetAddress().toString(), "Replication command '" + command + "' not supported");
            }
        }
    }

    private void electionComplete(ChannelBinaryServer channel, String remoteServerName, String remoteServerAddress) throws IOException {
        long voteTurn = channel.readLong();
        this.ha.lastElectionVote = new Pair((Object)voteTurn, (Object)remoteServerName);
        channel.close();
        LogManager.instance().log((Object)this, Level.INFO, "Received new leadership from server '%s' (turn=%d)", (Object)remoteServerName, (Object)voteTurn);
        if (this.ha.connectToLeader(remoteServerAddress, null)) {
            this.ha.setElectionStatus(HAServer.ELECTION_STATUS.DONE);
            try {
                this.ha.getServer().lifecycleEvent(ReplicationCallback.TYPE.LEADER_ELECTED, remoteServerName);
            }
            catch (Exception e) {
                throw new ArcadeDBException("Error on propagating election status", (Throwable)e);
            }
        } else {
            this.ha.startElection(false);
        }
    }

    private void voteForMe(ChannelBinaryServer channel, String remoteServerName) throws IOException {
        long voteTurn = channel.readLong();
        long lastReplicationMessage = channel.readLong();
        long localServerLastMessageNumber = this.ha.getReplicationLogFile().getLastMessageNumber();
        if (localServerLastMessageNumber > lastReplicationMessage) {
            LogManager.instance().log((Object)this, Level.INFO, "Server '%s' asked for election (lastReplicationMessage=%d my=%d) on turn %d, but cannot give my vote because my LSN is higher", (Object)remoteServerName, (Object)lastReplicationMessage, (Object)localServerLastMessageNumber, (Object)voteTurn);
            channel.writeByte((byte)2);
            this.ha.lastElectionVote = new Pair((Object)voteTurn, (Object)"-");
            Replica2LeaderNetworkExecutor leader = this.ha.getLeader();
            channel.writeString(leader != null ? leader.getRemoteAddress() : this.ha.getServerAddress());
            if (leader == null || remoteServerName.equals(leader.getRemoteServerName())) {
                this.ha.startElection(false);
            }
        } else if (this.ha.lastElectionVote == null || (Long)this.ha.lastElectionVote.getFirst() < voteTurn) {
            LogManager.instance().log((Object)this, Level.INFO, "Server '%s' asked for election (lastReplicationMessage=%d my=%d) on turn %d, giving my vote", (Object)remoteServerName, (Object)lastReplicationMessage, (Object)localServerLastMessageNumber, (Object)voteTurn);
            channel.writeByte((byte)0);
            this.ha.lastElectionVote = new Pair((Object)voteTurn, (Object)remoteServerName);
            this.ha.setElectionStatus(HAServer.ELECTION_STATUS.VOTING_FOR_OTHERS);
        } else {
            LogManager.instance().log((Object)this, Level.INFO, "Server '%s' asked for election (lastReplicationMessage=%d my=%d) on turn %d, but cannot give my vote (votedFor='%s' on turn %d)", (Object)remoteServerName, (Object)lastReplicationMessage, (Object)localServerLastMessageNumber, (Object)voteTurn, this.ha.lastElectionVote.getSecond(), this.ha.lastElectionVote.getFirst());
            channel.writeByte((byte)1);
            Replica2LeaderNetworkExecutor leader = this.ha.getLeader();
            channel.writeString(leader != null ? leader.getRemoteAddress() : this.ha.getServerAddress());
        }
        channel.flush();
    }

    private void connect(ChannelBinaryServer channel, String remoteServerName, String remoteServerAddress, String remoteServerHTTPAddress) throws IOException {
        if (remoteServerName.equals(this.ha.getServerName())) {
            channel.writeBoolean(false);
            channel.writeByte((byte)4);
            channel.writeString("Remote server is attempting to connect with the same server name '" + this.ha.getServerName() + "'");
            throw new ConnectionException(channel.socket.getInetAddress().toString(), "Remote server is attempting to connect with the same server name '" + this.ha.getServerName() + "'");
        }
        Leader2ReplicaNetworkExecutor connection = new Leader2ReplicaNetworkExecutor(this.ha, channel, remoteServerName, remoteServerAddress, remoteServerHTTPAddress);
        this.ha.registerIncomingConnection(connection.getRemoteServerName(), connection);
        connection.start();
    }

    private void readClusterName(Socket socket, ChannelBinaryServer channel) throws IOException {
        String remoteClusterName = channel.readString();
        if (!remoteClusterName.equals(this.ha.getClusterName())) {
            channel.writeBoolean(false);
            channel.writeByte((byte)3);
            channel.writeString("Cluster name '" + remoteClusterName + "' does not match");
            channel.flush();
            throw new ConnectionException(socket.getInetAddress().toString(), "Cluster name '" + remoteClusterName + "' does not match");
        }
    }

    private void readProtocolVersion(Socket socket, ChannelBinaryServer channel) throws IOException {
        short remoteProtocolVersion = channel.readShort();
        if (remoteProtocolVersion != 0) {
            channel.writeBoolean(false);
            channel.writeByte((byte)2);
            channel.writeString("Network protocol version " + remoteProtocolVersion + " is different than local server 0");
            channel.flush();
            throw new ConnectionException(socket.getInetAddress().toString(), "Network protocol version " + remoteProtocolVersion + " is different than local server 0");
        }
    }

    private static int[] getPorts(String iHostPortRange) {
        int[] ports;
        if (iHostPortRange.contains(",")) {
            String[] portValues = iHostPortRange.split(",");
            ports = new int[portValues.length];
            for (int i = 0; i < portValues.length; ++i) {
                ports[i] = Integer.parseInt(portValues[i]);
            }
        } else if (iHostPortRange.contains("-")) {
            String[] limits = iHostPortRange.split("-");
            int lowerLimit = Integer.parseInt(limits[0]);
            int upperLimit = Integer.parseInt(limits[1]);
            ports = new int[upperLimit - lowerLimit + 1];
            for (int i = 0; i < upperLimit - lowerLimit + 1; ++i) {
                ports[i] = lowerLimit + i;
            }
        } else {
            ports = new int[]{Integer.parseInt(iHostPortRange)};
        }
        return ports;
    }
}

