/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.Document;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.Record;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableEdge;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.EdgeType;
import com.arcadedb.serializer.json.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class RemoteMutableEdge
extends MutableEdge {
    protected final RemoteDatabase remoteDatabase;

    protected RemoteMutableEdge(RemoteImmutableEdge source) {
        super(null, (EdgeType)source.getType(), source.getIdentity());
        this.remoteDatabase = source.remoteDatabase;
        this.map.putAll(source.map);
        this.out = source.getOut();
        this.in = source.getIn();
    }

    public MutableEdge save() {
        this.dirty = true;
        if (this.rid != null) {
            this.remoteDatabase.command("sql", "update " + String.valueOf(this.rid) + " content " + String.valueOf(this.toJSON()), new Object[0]);
        } else {
            this.remoteDatabase.command("sql", "insert into " + this.getTypeName() + " content " + String.valueOf(this.toJSON()), new Object[0]);
        }
        this.dirty = false;
        return this;
    }

    public MutableEdge save(String bucketName) {
        this.dirty = true;
        if (this.rid != null) {
            throw new IllegalStateException("Cannot update a record in a custom bucket");
        }
        this.remoteDatabase.command("sql", "insert into " + this.getTypeName() + " bucket " + bucketName + " content " + String.valueOf(this.toJSON()), new Object[0]);
        this.dirty = false;
        return this;
    }

    public void delete() {
        this.remoteDatabase.deleteRecord((Record)this);
    }

    public void reload() {
        ResultSet resultSet = this.remoteDatabase.query("sql", "select from " + String.valueOf(this.rid), new Object[0]);
        if (!resultSet.hasNext()) {
            throw new RecordNotFoundException("Record " + String.valueOf(this.rid) + " not found", this.rid);
        }
        Document document = resultSet.next().toElement();
        this.map.clear();
        this.map.putAll(document.propertiesAsMap());
        this.dirty = false;
    }

    public Map<String, Object> toMap(boolean includeMetadata) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        if (includeMetadata) {
            result.put("@cat", "e");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public JSONObject toJSON(boolean includeMetadata) {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map, this.type, includeMetadata, new String[0]);
        if (includeMetadata) {
            result.put("@cat", "e");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public DocumentType getType() {
        throw new UnsupportedOperationException("Schema API are not supported in remote database");
    }

    public Database getDatabase() {
        throw new UnsupportedOperationException("Embedded Database API not supported in remote database");
    }

    public Binary getBuffer() {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    public void setBuffer(Binary buffer) {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    protected void checkForLazyLoadingProperties() {
    }

    protected Object convertValueToSchemaType(String name, Object value, DocumentType type) {
        return value;
    }

    public Edge asEdge() {
        return this;
    }

    public Edge asEdge(boolean loadContent) {
        return this;
    }
}

