/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Document;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RecordEvents;
import com.arcadedb.database.bucketselectionstrategy.BucketSelectionStrategy;
import com.arcadedb.engine.Bucket;
import com.arcadedb.index.Index;
import com.arcadedb.index.IndexInternal;
import com.arcadedb.index.TypeIndex;
import com.arcadedb.index.lsm.LSMTreeIndexAbstract;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteMutableDocument;
import com.arcadedb.remote.RemoteProperty;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.Property;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.serializer.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoteDocumentType
implements DocumentType {
    protected final RemoteDatabase remoteDatabase;
    protected final String name;
    private int count;
    private List<String> buckets;
    private String bucketSelectionStrategy;
    private List<String> parentTypes;
    private Map<String, RemoteProperty> properties;
    private Set<String> aliases = Collections.emptySet();
    private Map<String, Object> custom = new HashMap<String, Object>();

    RemoteDocumentType(RemoteDatabase remoteDatabase, Result record) {
        this.remoteDatabase = remoteDatabase;
        this.name = (String)record.getProperty("name");
        this.reload(record);
    }

    void reload(Result record) {
        this.count = (Integer)record.getProperty("records");
        this.buckets = (List)record.getProperty("buckets");
        this.bucketSelectionStrategy = (String)record.getProperty("bucketSelectionStrategy");
        this.parentTypes = (List)record.getProperty("parentTypes");
        if (record.hasProperty("aliases")) {
            this.aliases = new HashSet<String>((Collection)record.getProperty("aliases"));
        }
        List propertiesMap = (List)record.getProperty("properties");
        if (this.properties == null) {
            this.properties = new HashMap<String, RemoteProperty>(propertiesMap.size());
        }
        for (Map entry : propertiesMap) {
            String propertyName = (String)entry.get("name");
            RemoteProperty p = this.properties.get(propertyName);
            if (p == null) {
                p = new RemoteProperty(this, entry);
                this.properties.put(propertyName, p);
                continue;
            }
            p.reload(entry);
        }
        if (record.hasProperty("custom")) {
            this.custom = (Map)record.getProperty("custom");
        }
    }

    public Schema getSchema() {
        return this.remoteDatabase.getSchema();
    }

    public String toString() {
        return this.name;
    }

    public boolean isTheSameAs(Object o) {
        return this.equals(o);
    }

    public boolean equals(Object o) {
        RemoteDocumentType rdt;
        return o instanceof RemoteDocumentType && (rdt = (RemoteDocumentType)o).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void rename(String newName) {
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` name `" + newName + "`", new Object[0]);
        this.remoteDatabase.getSchema().reload();
    }

    public MutableDocument newRecord() {
        return new RemoteMutableDocument(this.remoteDatabase, this.name);
    }

    public int count() {
        return this.count;
    }

    public Property createProperty(String propertyName, String propertyType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` " + propertyType, new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property createProperty(String propertyName, Class<?> propertyType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` " + Type.getTypeByClass(propertyType).name(), new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property createProperty(String propertyName, Type propertyType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` " + propertyType.name(), new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property createProperty(String propertyName, Type propertyType, String ofType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` " + propertyType.name() + " of " + ofType, new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property getOrCreateProperty(String propertyName, String propertyType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` if not exists " + propertyType, new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property getOrCreateProperty(String propertyName, String propertyType, String ofType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` if not exists " + propertyType + " of " + ofType, new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property getOrCreateProperty(String propertyName, Class<?> propertyType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` if not exists " + Type.getTypeByClass(propertyType).name(), new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property getOrCreateProperty(String propertyName, Type propertyType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` if not exists " + propertyType.name(), new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property getOrCreateProperty(String propertyName, Type propertyType, String ofType) {
        this.remoteDatabase.command("sql", "create property `" + this.name + "`.`" + propertyName + "` if not exists " + propertyType.name() + " of " + ofType, new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this.getProperty(propertyName);
    }

    public Property dropProperty(String propertyName) {
        Property p = this.getProperty(propertyName);
        this.remoteDatabase.command("sql", "drop property `" + this.name + "`.`" + propertyName + "`", new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return p;
    }

    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String ... propertyNames) {
        this.remoteDatabase.getSchema().createTypeIndex(indexType, unique, this.name, propertyNames);
        this.remoteDatabase.getSchema().invalidateSchema();
        return null;
    }

    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String ... propertyNames) {
        this.remoteDatabase.getSchema().getOrCreateTypeIndex(indexType, unique, this.name, propertyNames);
        this.remoteDatabase.getSchema().invalidateSchema();
        return null;
    }

    public DocumentType addSuperType(String superName) {
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` supertype +`" + superName + "`", new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this;
    }

    public DocumentType addSuperType(DocumentType superType) {
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` supertype +`" + superType.getName() + "`", new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this;
    }

    public DocumentType removeSuperType(String superTypeName) {
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` supertype -`" + superTypeName + "`", new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this;
    }

    public DocumentType removeSuperType(DocumentType superType) {
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` supertype -`" + superType.getName() + "`", new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public DocumentType setAliases(Set<String> aliases) {
        String aliasesAsString = aliases.stream().map(a -> "`" + a + "`").collect(Collectors.joining(","));
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` aliases " + aliasesAsString, new Object[0]);
        this.remoteDatabase.getSchema().reload();
        return this;
    }

    public boolean existsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public boolean existsPolymorphicProperty(String propertyName) {
        if (this.existsProperty(propertyName)) {
            return true;
        }
        for (DocumentType s : this.getSuperTypes()) {
            if (!s.existsProperty(propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubTypeOf(String type) {
        if (this.parentTypes != null) {
            if (this.parentTypes.contains(type)) {
                return true;
            }
            for (DocumentType s : this.getSuperTypes()) {
                if (!s.isSubTypeOf(type)) continue;
                return true;
            }
        }
        return false;
    }

    public List<DocumentType> getSuperTypes() {
        return this.parentTypes.stream().map(p -> this.remoteDatabase.getSchema().getType((String)p)).collect(Collectors.toList());
    }

    public Property getPropertyIfExists(String propertyName) {
        return (Property)this.properties.get(propertyName);
    }

    public boolean isSuperTypeOf(String type) {
        return this.remoteDatabase.getSchema().getType(type).isSubTypeOf(this.name);
    }

    public List<Bucket> getBuckets(boolean polymorphic) {
        if (!polymorphic) {
            return this.buckets.stream().map(bucketName -> this.getSchema().getBucketByName(bucketName)).collect(Collectors.toList());
        }
        ArrayList<Bucket> result = new ArrayList<Bucket>();
        result.addAll(this.buckets.stream().map(bucketName -> this.getSchema().getBucketByName(bucketName)).collect(Collectors.toList()));
        for (String parent : this.parentTypes) {
            result.addAll(this.getSchema().getType(parent).getBuckets(true));
        }
        return result;
    }

    public List<TypeIndex> getIndexesByProperties(Collection<String> properties) {
        return Collections.emptyList();
    }

    public TypeIndex getPolymorphicIndexByProperties(String ... properties) {
        return null;
    }

    public TypeIndex getPolymorphicIndexByProperties(List<String> properties) {
        return null;
    }

    public boolean hasBucket(String bucketName) {
        return this.buckets.contains(bucketName);
    }

    public boolean instanceOf(String type) {
        throw new UnsupportedOperationException();
    }

    public List<DocumentType> getSubTypes() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String[] propertyNames, int pageSize) {
        throw new UnsupportedOperationException();
    }

    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String[] propertyNames, int pageSize, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String[] propertyNames, int pageSize, LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String[] propertyNames, int pageSize) {
        throw new UnsupportedOperationException();
    }

    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String[] propertyNames, int pageSize, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String[] propertyNames, int pageSize, LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    public RecordEvents getEvents() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPolymorphicPropertiesWithDefaultDefined() {
        throw new UnsupportedOperationException();
    }

    public DocumentType setSuperTypes(List<DocumentType> newSuperTypes) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Property> getProperties() {
        return this.properties.values();
    }

    public Collection<? extends Property> getPolymorphicProperties() {
        if (this.parentTypes.isEmpty()) {
            return this.getProperties();
        }
        HashSet<? extends Property> allProperties = new HashSet<Property>(this.getProperties());
        for (String parentName : this.parentTypes) {
            allProperties.addAll(this.getSchema().getType(parentName).getPolymorphicProperties());
        }
        return allProperties;
    }

    public Set<String> getPolymorphicPropertyNames() {
        if (this.parentTypes.isEmpty()) {
            return this.getPropertyNames();
        }
        HashSet<String> allProperties = new HashSet<String>(this.getPropertyNames());
        for (String parentName : this.parentTypes) {
            allProperties.addAll(this.getSchema().getType(parentName).getPropertyNames());
        }
        return allProperties;
    }

    public List<Bucket> getInvolvedBuckets() {
        throw new UnsupportedOperationException();
    }

    public List<Integer> getBucketIds(boolean polymorphic) {
        throw new UnsupportedOperationException();
    }

    public DocumentType addBucket(Bucket bucket) {
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` bucket +`" + bucket.getName() + "`", new Object[0]);
        return this.remoteDatabase.getSchema().reload().getType(this.name);
    }

    public DocumentType removeBucket(Bucket bucket) {
        throw new UnsupportedOperationException();
    }

    public Bucket getBucketIdByRecord(Document record, boolean async) {
        throw new UnsupportedOperationException();
    }

    public int getBucketIndexByKeys(Object[] keys, boolean async) {
        throw new UnsupportedOperationException();
    }

    public BucketSelectionStrategy getBucketSelectionStrategy() {
        throw new UnsupportedOperationException();
    }

    public DocumentType setBucketSelectionStrategy(BucketSelectionStrategy selectionStrategy) {
        throw new UnsupportedOperationException();
    }

    public DocumentType setBucketSelectionStrategy(String selectionStrategyName, Object ... args) {
        throw new UnsupportedOperationException();
    }

    public Collection<TypeIndex> getAllIndexes(boolean polymorphic) {
        throw new UnsupportedOperationException();
    }

    public List<IndexInternal> getPolymorphicBucketIndexByBucketId(int bucketId, List<String> filterByProperties) {
        throw new UnsupportedOperationException();
    }

    public List<TypeIndex> getIndexesByProperties(String property1, String ... propertiesN) {
        throw new UnsupportedOperationException();
    }

    public int getFirstBucketId() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getCustomKeys() {
        return this.custom.keySet();
    }

    public Object getCustomValue(String key) {
        return this.custom.get(key);
    }

    public Object setCustomValue(String key, Object value) {
        this.remoteDatabase.command("sql", "alter type `" + this.name + "` custom " + key + " = ?", value);
        return this.custom.put(key, value);
    }

    public JSONObject toJSON() {
        throw new UnsupportedOperationException();
    }
}

