/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Database;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RID;
import com.arcadedb.database.Record;
import com.arcadedb.database.async.ErrorCallback;
import com.arcadedb.database.async.OkCallback;
import com.arcadedb.exception.ConcurrentModificationException;
import com.arcadedb.exception.DatabaseIsClosedException;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.exception.DuplicatedKeyException;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.log.LogManager;
import com.arcadedb.query.sql.executor.InternalResultSet;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteException;
import com.arcadedb.remote.RemoteHttpComponent;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.remote.RemoteImmutableEdge;
import com.arcadedb.remote.RemoteImmutableVertex;
import com.arcadedb.remote.RemoteMutableDocument;
import com.arcadedb.remote.RemoteMutableVertex;
import com.arcadedb.remote.RemoteSchema;
import com.arcadedb.remote.RemoteTransactionExplicitLock;
import com.arcadedb.serializer.BinarySerializer;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import java.lang.invoke.CallSite;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class RemoteDatabase
extends RemoteHttpComponent
implements BasicDatabase {
    public static final String ARCADEDB_SESSION_ID = "arcadedb-session-id";
    private final String databaseName;
    private BinarySerializer serializer;
    private String sessionId;
    private Database.TRANSACTION_ISOLATION_LEVEL transactionIsolationLevel = Database.TRANSACTION_ISOLATION_LEVEL.READ_COMMITTED;
    private final RemoteSchema schema = new RemoteSchema(this);
    private boolean open = true;
    private RemoteTransactionExplicitLock explicitLock;

    public RemoteDatabase(String server, int port, String databaseName, String userName, String userPassword) {
        this(server, port, databaseName, userName, userPassword, new ContextConfiguration());
    }

    public RemoteDatabase(String server, int port, String databaseName, String userName, String userPassword, ContextConfiguration configuration) {
        super(server, port, userName, userPassword, configuration);
        this.databaseName = databaseName;
        try {
            this.serializer = new BinarySerializer(configuration);
        }
        catch (ClassNotFoundException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error creating BinarySerializer", (Throwable)e);
        }
    }

    public String getName() {
        return this.databaseName;
    }

    public String getDatabasePath() {
        return this.protocol + "://" + this.currentServer + ":" + this.currentPort + "/" + this.databaseName;
    }

    public boolean isOpen() {
        return this.open;
    }

    public RemoteSchema getSchema() {
        return this.schema;
    }

    @Override
    public void close() {
        super.close();
        this.setSessionId(null);
        this.open = false;
    }

    public void drop() {
        this.checkDatabaseIsOpen();
        try {
            JSONObject jsonRequest = new JSONObject().put("command", "drop database " + this.databaseName);
            String payload = this.getRequestPayload(jsonRequest);
            HttpRequest request = this.createRequestBuilder("POST", this.getUrl("server")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("Content-Type", "application/json").build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                Exception detail = this.manageException(response, "drop database");
                throw new RemoteException("Error on deleting database", detail);
            }
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on deleting database", (Throwable)e);
        }
        this.close();
    }

    public MutableDocument newDocument(String typeName) {
        this.checkDatabaseIsOpen();
        if (typeName == null) {
            throw new IllegalArgumentException("Type is null");
        }
        return new RemoteMutableDocument(this, typeName);
    }

    public RemoteMutableVertex newVertex(String typeName) {
        this.checkDatabaseIsOpen();
        if (typeName == null) {
            throw new IllegalArgumentException("Type is null");
        }
        return new RemoteMutableVertex(this, typeName);
    }

    public void transaction(BasicDatabase.TransactionScope txBlock) {
        this.transaction(txBlock, true, this.configuration.getValueAsInteger(GlobalConfiguration.TX_RETRIES), null, null);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTransaction) {
        return this.transaction(txBlock, joinCurrentTransaction, this.configuration.getValueAsInteger(GlobalConfiguration.TX_RETRIES), null, null);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTransaction, int attempts) {
        return this.transaction(txBlock, joinCurrentTransaction, attempts, null, null);
    }

    public boolean transaction(BasicDatabase.TransactionScope txBlock, boolean joinCurrentTransaction, int attempts, OkCallback ok, ErrorCallback error) {
        this.checkDatabaseIsOpen();
        if (txBlock == null) {
            throw new IllegalArgumentException("Transaction block is null");
        }
        Throwable lastException = null;
        if (attempts < 1) {
            attempts = 1;
        }
        for (int retry = 0; retry < attempts; ++retry) {
            boolean createdNewTx = true;
            try {
                if (joinCurrentTransaction && this.isTransactionActive()) {
                    createdNewTx = false;
                } else {
                    this.begin();
                }
                txBlock.execute();
                if (createdNewTx) {
                    this.commit();
                }
                if (ok != null) {
                    ok.call();
                }
                return createdNewTx;
            }
            catch (DuplicatedKeyException | NeedRetryException e) {
                lastException = e;
                this.setSessionId(null);
                if (error == null) continue;
                error.call(e);
                continue;
            }
            catch (Exception e) {
                this.setSessionId(null);
                if (error != null) {
                    error.call((Throwable)e);
                }
                throw e;
            }
        }
        throw lastException;
    }

    public boolean isTransactionActive() {
        return this.getSessionId() != null;
    }

    public int getNestedTransactions() {
        return this.isTransactionActive() ? 1 : 0;
    }

    public RemoteTransactionExplicitLock acquireLock() {
        if (this.explicitLock == null) {
            this.explicitLock = new RemoteTransactionExplicitLock(this);
        }
        return this.explicitLock;
    }

    public void begin() {
        this.begin(this.transactionIsolationLevel);
    }

    public void begin(Database.TRANSACTION_ISOLATION_LEVEL isolationLevel) {
        this.checkDatabaseIsOpen();
        if (this.getSessionId() != null) {
            throw new TransactionException("Transaction already begun");
        }
        try {
            JSONObject jsonRequest = new JSONObject().put("isolationLevel", (Object)isolationLevel);
            String payload = this.getRequestPayload(jsonRequest);
            HttpRequest request = this.createRequestBuilder("POST", this.getUrl("begin", this.databaseName)).POST(HttpRequest.BodyPublishers.ofString(payload)).header("Content-Type", "application/json").build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 204) {
                Exception detail = this.manageException(response, "begin transaction");
                throw new TransactionException("Error on transaction begin", (Throwable)detail);
            }
            this.setSessionId(response.headers().firstValue(ARCADEDB_SESSION_ID).orElse(null));
        }
        catch (Exception e) {
            throw new TransactionException("Error on transaction begin", (Throwable)e);
        }
    }

    public void commit() {
        this.checkDatabaseIsOpen();
        this.stats.txCommits.incrementAndGet();
        if (this.getSessionId() == null) {
            throw new TransactionException("Transaction not begun");
        }
        try {
            HttpRequest request = this.createRequestBuilder("POST", this.getUrl("commit", this.databaseName)).POST(HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 204) {
                Exception detail = this.manageException(response, "commit transaction");
                if (detail instanceof DuplicatedKeyException || detail instanceof ConcurrentModificationException) {
                    throw detail;
                }
                throw new TransactionException("Error on transaction commit", (Throwable)detail);
            }
        }
        catch (ConcurrentModificationException | DuplicatedKeyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionException("Error on transaction commit", (Throwable)e);
        }
        finally {
            this.setSessionId(null);
        }
    }

    public void rollback() {
        this.checkDatabaseIsOpen();
        this.stats.txRollbacks.incrementAndGet();
        if (this.getSessionId() == null) {
            throw new TransactionException("Transaction not begun");
        }
        try {
            HttpRequest request = this.createRequestBuilder("POST", this.getUrl("rollback", this.databaseName)).POST(HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 204) {
                Exception detail = this.manageException(response, "rollback transaction");
                throw new TransactionException("Error on transaction rollback", (Throwable)detail);
            }
        }
        catch (Exception e) {
            throw new TransactionException("Error on transaction rollback", (Throwable)e);
        }
        finally {
            this.setSessionId(null);
        }
    }

    public long countBucket(String bucketName) {
        this.checkDatabaseIsOpen();
        this.stats.countBucket.incrementAndGet();
        return ((Number)((ResultSet)this.databaseCommand("query", "sql", "select count(*) as count from bucket:" + bucketName, null, false, (connection, response) -> this.createResultSet(response))).nextIfAvailable().getProperty("count")).longValue();
    }

    public long countType(String typeName, boolean polymorphic) {
        this.checkDatabaseIsOpen();
        this.stats.countType.incrementAndGet();
        Object appendix = polymorphic ? "" : " where @type = '" + typeName + "'";
        return ((Number)((ResultSet)this.databaseCommand("query", "sql", "select count(*) as count from " + typeName + (String)appendix, null, false, (connection, response) -> this.createResultSet(response))).nextIfAvailable().getProperty("count")).longValue();
    }

    public Record lookupByRID(RID rid) {
        this.stats.readRecord.incrementAndGet();
        if (rid == null) {
            throw new IllegalArgumentException("Record is null");
        }
        return this.lookupByRID(rid, true);
    }

    public boolean existsRecord(RID rid) {
        this.stats.existsRecord.incrementAndGet();
        if (rid == null) {
            throw new IllegalArgumentException("Record is null");
        }
        try {
            return this.lookupByRID(rid, false) != null;
        }
        catch (RecordNotFoundException e) {
            return false;
        }
    }

    public Record lookupByRID(RID rid, boolean loadContent) {
        this.checkDatabaseIsOpen();
        this.stats.readRecord.incrementAndGet();
        if (rid == null) {
            throw new IllegalArgumentException("Record is null");
        }
        ResultSet result = this.query("sql", "select from " + String.valueOf(rid), new Object[0]);
        if (!result.hasNext()) {
            throw new RecordNotFoundException("Record " + String.valueOf(rid) + " not found", rid);
        }
        return (Record)result.next().getRecord().get();
    }

    public void deleteRecord(Record record) {
        this.checkDatabaseIsOpen();
        this.stats.deleteRecord.incrementAndGet();
        if (record.getIdentity() == null) {
            throw new IllegalArgumentException("Cannot delete a non persistent record");
        }
        this.command("SQL", "delete from " + String.valueOf(record.getIdentity()), new Object[0]);
    }

    public Iterator<Record> iterateType(String typeName, boolean polymorphic) {
        String query = "select from `" + typeName + "`";
        if (!polymorphic) {
            query = query + " where @type = '" + typeName + "'";
        }
        final ResultSet resultSet = this.query("sql", query, new Object[0]);
        return new Iterator<Record>(this){

            @Override
            public boolean hasNext() {
                return resultSet.hasNext();
            }

            @Override
            public Record next() {
                return (Record)resultSet.next().getElement().get();
            }
        };
    }

    public Iterator<Record> iterateBucket(String bucketName) {
        final ResultSet resultSet = this.query("sql", "select from bucket:`" + bucketName + "`", new Object[0]);
        return new Iterator<Record>(this){

            @Override
            public boolean hasNext() {
                return resultSet.hasNext();
            }

            @Override
            public Record next() {
                return (Record)resultSet.next().getElement().get();
            }
        };
    }

    public ResultSet command(String language, String command, Map<String, Object> params) {
        return this.command(language, command, null, params);
    }

    public ResultSet command(String language, String command, ContextConfiguration configuration, Object ... args) {
        return this.command(language, command, args);
    }

    public ResultSet command(String language, String command, ContextConfiguration configuration, Map<String, Object> params) {
        this.checkDatabaseIsOpen();
        this.stats.commands.incrementAndGet();
        return (ResultSet)this.databaseCommand("command", language, command, params, true, (connection, response) -> this.createResultSet(response));
    }

    public ResultSet command(String language, String command, Object ... args) {
        this.checkDatabaseIsOpen();
        this.stats.commands.incrementAndGet();
        Map<String, Object> params = this.mapArgs(args);
        return (ResultSet)this.databaseCommand("command", language, command, params, true, (connection, response) -> this.createResultSet(response));
    }

    public ResultSet query(String language, String query, Object ... args) {
        this.checkDatabaseIsOpen();
        this.stats.queries.incrementAndGet();
        Map<String, Object> params = this.mapArgs(args);
        return (ResultSet)this.databaseCommand("query", language, query, params, false, (connection, response) -> this.createResultSet(response));
    }

    public ResultSet query(String language, String query, Map<String, Object> params) {
        this.checkDatabaseIsOpen();
        this.stats.commands.incrementAndGet();
        return (ResultSet)this.databaseCommand("query", language, query, params, false, (connection, response) -> this.createResultSet(response));
    }

    @Deprecated
    public ResultSet execute(String language, String command, Object ... args) {
        this.checkDatabaseIsOpen();
        this.stats.commands.incrementAndGet();
        Map<String, Object> params = this.mapArgs(args);
        return (ResultSet)this.databaseCommand("command", language, command, params, false, (connection, response) -> this.createResultSet(response));
    }

    public Database.TRANSACTION_ISOLATION_LEVEL getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(Database.TRANSACTION_ISOLATION_LEVEL transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public String toString() {
        return this.databaseName;
    }

    private Object databaseCommand(String operation, String language, String payloadCommand, Map<String, Object> params, boolean requiresLeader, RemoteHttpComponent.Callback callback) {
        this.checkDatabaseIsOpen();
        return this.httpCommand("POST", this.databaseName, operation, language, payloadCommand, params, requiresLeader, true, callback);
    }

    String getSessionId() {
        return this.sessionId;
    }

    void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    HttpRequest.Builder createRequestBuilder(String httpMethod, String url) {
        HttpRequest.Builder builder = super.createRequestBuilder(httpMethod, url);
        if (this.getSessionId() != null) {
            builder.header(ARCADEDB_SESSION_ID, this.getSessionId());
        }
        return builder;
    }

    private String getUrl(String command, String databaseName) {
        return this.getUrl(command) + "/" + databaseName;
    }

    protected ResultSet createResultSet(JSONObject response) {
        InternalResultSet resultSet = new InternalResultSet();
        JSONArray resultArray = response.getJSONArray("result");
        for (int i = 0; i < resultArray.length(); ++i) {
            JSONObject result = resultArray.getJSONObject(i);
            resultSet.add(this.json2Result(result));
        }
        return resultSet;
    }

    protected Result json2Result(JSONObject result) {
        Record record = this.json2Record(result);
        if (record == null) {
            return new ResultInternal(result.toMap());
        }
        return new ResultInternal((Identifiable)record);
    }

    protected Record json2Record(JSONObject result) {
        Map map = result.toMap();
        if (map.containsKey("@cat")) {
            String cat;
            return switch (cat = result.getString("@cat")) {
                case "d" -> new RemoteImmutableDocument(this, map);
                case "v" -> new RemoteImmutableVertex(this, map);
                case "e" -> new RemoteImmutableEdge(this, map);
                default -> null;
            };
        }
        return null;
    }

    RID saveRecord(MutableDocument record) {
        this.stats.createRecord.incrementAndGet();
        RID rid = record.getIdentity();
        if (rid != null) {
            this.command("sql", "update " + String.valueOf(rid) + " content " + String.valueOf(record.toJSON()), new Object[0]);
        } else {
            ResultSet result = this.command("sql", "insert into " + record.getTypeName() + " content " + String.valueOf(record.toJSON()), new Object[0]);
            rid = (RID)result.next().getIdentity().get();
        }
        return rid;
    }

    RID saveRecord(MutableDocument record, String bucketName) {
        this.stats.createRecord.incrementAndGet();
        RID rid = record.getIdentity();
        if (rid != null) {
            throw new IllegalStateException("Cannot update a record in a custom bucket");
        }
        ResultSet result = this.command("sql", "insert into " + record.getTypeName() + " bucket " + bucketName + " content " + String.valueOf(record.toJSON()), new Object[0]);
        return (RID)result.next().getIdentity().get();
    }

    protected Map<String, Object> mapArgs(Object[] args) {
        Map<CallSite, Object> params = null;
        if (args != null && args.length > 0) {
            if (args.length == 1 && args[0] instanceof Map) {
                params = (Map)args[0];
            } else {
                params = new HashMap();
                for (Object o : args) {
                    params.put((CallSite)((Object)("" + params.size())), o);
                }
            }
        }
        return params;
    }

    protected void checkDatabaseIsOpen() {
        if (!this.open) {
            throw new DatabaseIsClosedException(this.databaseName);
        }
    }

    public BinarySerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(BinarySerializer serializer) {
        this.serializer = serializer;
    }
}

