/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.network.binary;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.exception.ConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SocketFactory {
    private javax.net.SocketFactory socketFactory;
    private boolean useSSL = false;
    private SSLContext context = null;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyStoreType = KeyStore.getDefaultType();
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String trustStoreType = KeyStore.getDefaultType();

    private SocketFactory(ContextConfiguration iConfig) {
        this.useSSL = iConfig.getValueAsBoolean(GlobalConfiguration.NETWORK_USE_SSL);
        this.keyStorePath = iConfig.getValueAsString(GlobalConfiguration.NETWORK_SSL_KEYSTORE);
        this.keyStorePassword = iConfig.getValueAsString(GlobalConfiguration.NETWORK_SSL_KEYSTORE_PASSWORD);
        this.trustStorePath = iConfig.getValueAsString(GlobalConfiguration.NETWORK_SSL_TRUSTSTORE);
        this.trustStorePassword = iConfig.getValueAsString(GlobalConfiguration.NETWORK_SSL_TRUSTSTORE_PASSWORD);
    }

    public static SocketFactory instance(ContextConfiguration iConfig) {
        return new SocketFactory(iConfig);
    }

    private javax.net.SocketFactory getBackingFactory() {
        if (this.socketFactory == null) {
            this.socketFactory = this.useSSL ? this.getSSLContext().getSocketFactory() : javax.net.SocketFactory.getDefault();
        }
        return this.socketFactory;
    }

    protected SSLContext getSSLContext() {
        if (this.context == null) {
            this.context = this.createSSLContext();
        }
        return this.context;
    }

    protected SSLContext createSSLContext() {
        try {
            if (this.keyStorePath != null && this.trustStorePath != null) {
                if (this.keyStorePassword == null || this.keyStorePassword.isEmpty()) {
                    throw new ConfigurationException("Please provide a keystore password");
                }
                if (this.trustStorePassword == null || this.trustStorePassword.isEmpty()) {
                    throw new ConfigurationException("Please provide a truststore password");
                }
                SSLContext context = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
                char[] keyStorePass = this.keyStorePassword.toCharArray();
                keyStore.load(SocketFactory.getAsStream(this.keyStorePath), keyStorePass);
                kmf.init(keyStore, keyStorePass);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
                char[] trustStorePass = this.trustStorePassword.toCharArray();
                trustStore.load(SocketFactory.getAsStream(this.trustStorePath), trustStorePass);
                tmf.init(trustStore);
                context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                return context;
            }
            return SSLContext.getDefault();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create ssl context", e);
        }
    }

    public static InputStream getAsStream(String path) throws IOException {
        InputStream input;
        try {
            URL url = new URI(path).toURL();
            input = url.openStream();
        }
        catch (MalformedURLException | URISyntaxException ignore) {
            input = null;
        }
        if (input == null) {
            input = SocketFactory.class.getResourceAsStream(path);
        }
        if (input == null) {
            input = SocketFactory.class.getClassLoader().getResourceAsStream(path);
        }
        if (input == null) {
            try {
                path = new File(path).getAbsolutePath();
                input = new FileInputStream(path);
            }
            catch (FileNotFoundException ignore) {
                input = null;
            }
        }
        if (input == null) {
            throw new IOException("Could not load resource from path: " + path);
        }
        return input;
    }

    private Socket configureSocket(Socket socket) {
        return socket;
    }

    public Socket createSocket() throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket());
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket(host, port));
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket(host, port));
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket(host, port, localHost, localPort));
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.configureSocket(this.getBackingFactory().createSocket(address, port, localAddress, localPort));
    }
}

