/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.remote.RemoteException;
import com.arcadedb.remote.RemoteHttpComponent;
import com.arcadedb.serializer.json.JSONObject;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteServer
extends RemoteHttpComponent {
    public RemoteServer(String server, int port, String userName, String userPassword) {
        this(server, port, userName, userPassword, new ContextConfiguration());
    }

    public RemoteServer(String server, int port, String userName, String userPassword, ContextConfiguration configuration) {
        super(server, port, userName, userPassword, configuration);
    }

    public void create(String databaseName) {
        this.serverCommand("POST", "create database " + databaseName, true, true, null);
    }

    public List<String> databases() {
        return (List)this.serverCommand("POST", "list databases", true, true, (connection, response) -> response.getJSONArray("result").toList());
    }

    public boolean exists(String databaseName) {
        return (Boolean)this.httpCommand("GET", databaseName, "exists", "SQL", null, null, false, true, (connection, response) -> response.getBoolean("result"));
    }

    public void drop(String databaseName) {
        try {
            HttpURLConnection connection = this.createConnection("POST", this.getUrl("server"));
            this.setRequestPayload(connection, new JSONObject().put("command", "drop database " + databaseName));
            connection.connect();
            if (connection.getResponseCode() != 200) {
                Exception detail = this.manageException(connection, "drop database");
                throw new RemoteException("Error on deleting database: " + connection.getResponseMessage(), detail);
            }
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on deleting database", (Throwable)e);
        }
    }

    public String toString() {
        return "http://" + this.currentServer + ":" + this.currentPort;
    }

    public void createUser(String userName, String password, Map<String, String> databases) {
        try {
            HttpURLConnection connection = this.createConnection("POST", this.getUrl("server"));
            JSONObject jsonUser = new JSONObject();
            jsonUser.put("name", userName);
            jsonUser.put("password", password);
            if (databases != null && !databases.isEmpty()) {
                JSONObject databasesJson = new JSONObject();
                for (Map.Entry<String, String> entry : databases.entrySet()) {
                    databasesJson.put(entry.getKey(), (Object)new String[]{entry.getValue()});
                }
                jsonUser.put("databases", (Object)databasesJson);
            }
            this.setRequestPayload(connection, new JSONObject().put("command", "create user " + jsonUser));
            connection.connect();
            if (connection.getResponseCode() != 200) {
                Exception detail = this.manageException(connection, "create user");
                throw new SecurityException("Error on creating user: " + connection.getResponseMessage(), detail);
            }
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on creating user", (Throwable)e);
        }
    }

    public void createUser(String userName, String password, List<String> databases) {
        HashMap<String, String> databasesWithGroups = new HashMap<String, String>();
        for (String dbName : databases) {
            databasesWithGroups.put(dbName, "admin");
        }
        this.createUser(userName, password, databasesWithGroups);
    }

    public void dropUser(String userName) {
        try {
            HttpURLConnection connection = this.createConnection("POST", this.getUrl("server"));
            this.setRequestPayload(connection, new JSONObject().put("command", "drop user " + userName));
            connection.connect();
            if (connection.getResponseCode() != 200) {
                Exception detail = this.manageException(connection, "drop user");
                throw new RemoteException("Error on deleting user: " + connection.getResponseMessage(), detail);
            }
        }
        catch (Exception e) {
            throw new RemoteException("Error on deleting user", e);
        }
    }

    private Object serverCommand(String method, String command, boolean leaderIsPreferable, boolean autoReconnect, RemoteHttpComponent.Callback callback) {
        return this.httpCommand(method, null, "server", null, command, null, leaderIsPreferable, autoReconnect, callback);
    }
}

