/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.ImmutableDocument;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RID;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteMutableDocument;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.serializer.json.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RemoteImmutableDocument
extends ImmutableDocument {
    protected final RemoteDatabase remoteDatabase;
    protected final Map<String, Object> map;

    protected RemoteImmutableDocument(RemoteDatabase remoteDatabase, Map<String, Object> attributes) {
        super(null, remoteDatabase.getSchema().getType((String)attributes.get("@type")), null, null);
        this.remoteDatabase = remoteDatabase;
        this.map = new HashMap<String, Object>(attributes);
        String ridAsString = (String)this.map.remove("@rid");
        this.rid = ridAsString != null ? new RID((BasicDatabase)remoteDatabase, ridAsString) : null;
        this.map.remove("@type");
        this.map.remove("@out");
        this.map.remove("@in");
        this.map.remove("@cat");
    }

    protected RemoteImmutableDocument(RemoteDatabase remoteDatabase, Map<String, Object> attributes, String typeName, RID rid) {
        super(null, remoteDatabase.getSchema().getType(typeName), rid, null);
        this.remoteDatabase = remoteDatabase;
        this.map = new HashMap<String, Object>(attributes);
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public synchronized Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public synchronized boolean has(String propertyName) {
        return this.map.containsKey(propertyName);
    }

    public synchronized Object get(String propertyName) {
        return this.map.get(propertyName);
    }

    public synchronized MutableDocument modify() {
        return new RemoteMutableDocument(this);
    }

    public synchronized Map<String, Object> toMap(boolean includeMetadata) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        if (includeMetadata) {
            result.put("@cat", "d");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public synchronized JSONObject toJSON(boolean includeMetadata) {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map, null, new String[0]);
        if (includeMetadata) {
            result.put("@cat", "d");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public DocumentType getType() {
        return this.type;
    }

    public Database getDatabase() {
        throw new UnsupportedOperationException("Embedded Database API not supported in remote database");
    }

    public Binary getBuffer() {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    public void reload() {
        throw new UnsupportedOperationException("Unable to reload an immutable document");
    }

    protected boolean checkForLazyLoading() {
        return false;
    }
}

