/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Neo4jImporter;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.AbstractImporterFormat;
import java.io.IOException;
import java.io.InputStream;

public class Neo4jImporterFormat
extends AbstractImporterFormat {
    @Override
    public void load(final SourceSchema sourceSchema, AnalyzedEntity.EntityType entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws ImportException {
        context.parsed.set(0L);
        try {
            new Neo4jImporter(this, (Database)database, context){

                @Override
                public InputStream openInputStream() throws IOException {
                    sourceSchema.getSource().reset();
                    return sourceSchema.getSource().inputStream;
                }
            }.run();
        }
        catch (IOException e) {
            throw new ImportException("Error on importing Neo4j database", e);
        }
    }

    @Override
    public SourceSchema analyze(AnalyzedEntity.EntityType entityType, Parser parser, ImporterSettings settings, AnalyzedSchema analyzedSchema) throws IOException {
        return new SourceSchema(this, parser.getSource(), analyzedSchema);
    }

    @Override
    public String getFormat() {
        return "Neo4j";
    }
}

