/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.index.CompressedAny2RIDIndex;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedProperty;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.AbstractImporterFormat;
import com.arcadedb.integration.importer.graph.GraphImporter;
import com.arcadedb.log.LogManager;
import com.arcadedb.schema.Type;
import com.arcadedb.utility.FileUtils;
import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.tsv.TsvParser;
import com.univocity.parsers.tsv.TsvParserSettings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;

public class CSVImporterFormat
extends AbstractImporterFormat {
    private static final Object[] NO_PARAMS = new Object[0];
    public static final int _32MB = 0x2000000;

    @Override
    public void load(SourceSchema sourceSchema, AnalyzedEntity.EntityType entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws ImportException {
        context.parsed.set(0L);
        switch (entityType) {
            case DOCUMENT: 
            case DATABASE: {
                this.loadDocuments(sourceSchema, parser, (Database)database, context, settings);
                break;
            }
            case VERTEX: {
                this.loadVertices(sourceSchema, parser, (Database)database, context, settings);
                break;
            }
            case EDGE: {
                this.loadEdges(sourceSchema, parser, database, context, settings);
            }
        }
    }

    private void loadDocuments(SourceSchema sourceSchema, Parser parser, Database database, ImporterContext context, ImporterSettings settings) throws ImportException {
        long skipEntries;
        AbstractParser csvParser = this.createCSVParser(settings);
        LogManager.instance().log((Object)this, Level.INFO, "Started importing documents from CSV source");
        long beginTime = System.currentTimeMillis();
        long l = skipEntries = settings.documentsSkipEntries != null ? settings.documentsSkipEntries : 0L;
        if (settings.documentsHeader == null && settings.documentsSkipEntries == null) {
            skipEntries = 1L;
        }
        try (InputStreamReader inputFileReader = new InputStreamReader(parser.getInputStream(), DatabaseFactory.getDefaultCharset());){
            String[] row;
            csvParser.beginParsing((Reader)inputFileReader);
            if (!database.isTransactionActive()) {
                database.begin();
            }
            AnalyzedEntity entity = sourceSchema.getSchema().getEntity(settings.documentTypeName);
            ArrayList<AnalyzedProperty> properties = new ArrayList<AnalyzedProperty>();
            if (!settings.documentPropertiesInclude.equalsIgnoreCase("*")) {
                String[] includes = settings.documentPropertiesInclude.split(",");
                HashSet<String> propertiesSet = new HashSet<String>(Arrays.asList(includes));
                for (AnalyzedProperty p : entity.getProperties()) {
                    if (!propertiesSet.contains(p.getName())) continue;
                    properties.add(p);
                }
            } else if (entity != null) {
                properties.addAll(entity.getProperties());
            }
            LogManager.instance().log((Object)this, Level.INFO, "Importing the following document properties: %s", null, properties);
            database.async().onError(exception -> LogManager.instance().log((Object)this, Level.SEVERE, "Error on inserting documents", exception));
            long line = 0L;
            while ((row = csvParser.parseNext()) != null) {
                context.parsed.incrementAndGet();
                if (skipEntries <= 0L || line >= skipEntries) {
                    MutableDocument document = database.newDocument(settings.documentTypeName);
                    for (int p = 0; p < properties.size(); ++p) {
                        AnalyzedProperty prop = (AnalyzedProperty)properties.get(p);
                        document.set(prop.getName(), (Object)row[prop.getIndex()]);
                    }
                    document.save();
                }
                ++line;
            }
            database.commit();
            database.async().waitCompletion();
        }
        catch (IOException e) {
            try {
                throw new ImportException("Error on importing CSV", e);
            }
            catch (Throwable throwable) {
                long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
                LogManager.instance().log((Object)this, Level.INFO, "Importing of documents from CSV source completed in %d seconds (%d/sec)", null, (Object)elapsedInSecs, (Object)(elapsedInSecs > 0L ? context.createdDocuments.get() / elapsedInSecs : context.createdDocuments.get()));
                LogManager.instance().log((Object)this, Level.INFO, "- Parsed lines...: %d", null, (Object)context.parsed.get());
                LogManager.instance().log((Object)this, Level.INFO, "- Total documents: %d", null, (Object)context.createdDocuments.get());
                csvParser.stopParsing();
                throw throwable;
            }
        }
        long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
        LogManager.instance().log((Object)this, Level.INFO, "Importing of documents from CSV source completed in %d seconds (%d/sec)", null, (Object)elapsedInSecs, (Object)(elapsedInSecs > 0L ? context.createdDocuments.get() / elapsedInSecs : context.createdDocuments.get()));
        LogManager.instance().log((Object)this, Level.INFO, "- Parsed lines...: %d", null, (Object)context.parsed.get());
        LogManager.instance().log((Object)this, Level.INFO, "- Total documents: %d", null, (Object)context.createdDocuments.get());
        csvParser.stopParsing();
    }

    private void loadVertices(SourceSchema sourceSchema, Parser parser, Database database, ImporterContext context, ImporterSettings settings) throws ImportException {
        long skipEntries;
        if (settings.typeIdProperty == null) {
            LogManager.instance().log((Object)this, Level.INFO, "Property id was not defined. Set `-typeIdProperty <name>`. Importing is aborted", null, (Object)settings.vertexTypeName, (Object)settings.typeIdProperty);
            throw new IllegalArgumentException("Property id was not defined. Set `-typeIdProperty <name>`. Importing is aborted");
        }
        AnalyzedEntity entity = sourceSchema.getSchema().getEntity(settings.vertexTypeName);
        if (entity == null) {
            LogManager.instance().log((Object)this, Level.INFO, "Vertex type '%s' not defined", null, (Object)settings.vertexTypeName);
            return;
        }
        AnalyzedProperty id = entity.getProperty(settings.typeIdProperty);
        if (id == null) {
            LogManager.instance().log((Object)this, Level.INFO, "Property Id '%s.%s' is null. Importing is aborted", null, (Object)settings.vertexTypeName, (Object)settings.typeIdProperty);
            throw new IllegalArgumentException("Property Id '" + settings.vertexTypeName + "." + settings.typeIdProperty + "' is null. Importing is aborted");
        }
        long expectedVertices = settings.expectedVertices;
        if (expectedVertices <= 0L) {
            expectedVertices = (int)(sourceSchema.getSource().totalSize / (long)entity.getAverageRowLength());
        }
        if (expectedVertices <= 0L) {
            expectedVertices = 1000000L;
        } else if (expectedVertices > Integer.MAX_VALUE) {
            expectedVertices = Integer.MAX_VALUE;
        }
        try {
            context.graphImporter = new GraphImporter((DatabaseInternal)database, (int)expectedVertices, (int)settings.expectedEdges, Type.valueOf((String)settings.typeIdType.toUpperCase(Locale.ENGLISH)));
        }
        catch (ClassNotFoundException e) {
            throw new ImportException("Error on creating internal component", e);
        }
        AbstractParser csvParser = this.createCSVParser(settings);
        LogManager.instance().log((Object)this, Level.INFO, "Started importing vertices from CSV source");
        long beginTime = System.currentTimeMillis();
        database.async().onError(exception -> LogManager.instance().log((Object)this, Level.SEVERE, "Error on inserting vertices", exception));
        long l = skipEntries = settings.verticesSkipEntries != null ? settings.verticesSkipEntries : 0L;
        if (settings.verticesSkipEntries == null) {
            skipEntries = 1L;
        }
        try (InputStreamReader inputFileReader = new InputStreamReader(parser.getInputStream(), DatabaseFactory.getDefaultCharset());){
            String[] row;
            csvParser.beginParsing((Reader)inputFileReader);
            int idIndex = id.getIndex();
            ArrayList<AnalyzedProperty> properties = new ArrayList<AnalyzedProperty>();
            if (!settings.vertexPropertiesInclude.isEmpty() && !settings.vertexPropertiesInclude.equalsIgnoreCase("*")) {
                String[] includes = settings.vertexPropertiesInclude.split(",");
                HashSet<String> propertiesSet = new HashSet<String>(Arrays.asList(includes));
                for (AnalyzedProperty p : entity.getProperties()) {
                    if (!propertiesSet.contains(p.getName())) continue;
                    properties.add(p);
                }
            } else {
                properties.addAll(entity.getProperties());
            }
            LogManager.instance().log((Object)this, Level.INFO, "Importing the following vertex properties: %s", null, properties);
            Object[] vertexProperties = new Object[properties.size() * 2];
            CompressedAny2RIDIndex<Object> verticesIndex = context.graphImporter.getVerticesIndex();
            long line = 0L;
            while ((row = csvParser.parseNext()) != null) {
                context.parsed.incrementAndGet();
                if (skipEntries <= 0L || line >= skipEntries) {
                    if (idIndex >= row.length) {
                        LogManager.instance().log((Object)this, Level.INFO, "Property Id is configured on property %d but cannot be found on current record. Skip it", null, (Object)idIndex);
                    } else {
                        String vertexId = row[idIndex];
                        for (int p = 0; p < properties.size(); ++p) {
                            AnalyzedProperty prop = (AnalyzedProperty)properties.get(p);
                            vertexProperties[p * 2] = prop.getName();
                            vertexProperties[p * 2 + 1] = row[prop.getIndex()];
                        }
                        context.graphImporter.createVertex(settings.vertexTypeName, vertexId, vertexProperties);
                        context.createdVertices.incrementAndGet();
                        if (line > 0L && line % 10000000L == 0L) {
                            LogManager.instance().log((Object)this, Level.INFO, "Map chunkSize=%s chunkAllocated=%s size=%d totalUsedSlots=%d", null, (Object)FileUtils.getSizeAsString((long)verticesIndex.getChunkSize()), (Object)FileUtils.getSizeAsString((long)verticesIndex.getChunkAllocated()), (Object)verticesIndex.size(), (Object)verticesIndex.getTotalUsedSlots());
                        }
                    }
                }
                ++line;
            }
            database.async().waitCompletion();
        }
        catch (IOException e) {
            try {
                throw new ImportException("Error on importing CSV", e);
            }
            catch (Throwable throwable) {
                long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
                LogManager.instance().log((Object)this, Level.INFO, "Importing of vertices from CSV source completed in %d seconds (%d/sec)", null, (Object)elapsedInSecs, (Object)(elapsedInSecs > 0L ? context.createdVertices.get() / elapsedInSecs : context.createdVertices.get()));
                LogManager.instance().log((Object)this, Level.INFO, "- Parsed lines...: %d", null, (Object)context.parsed.get());
                LogManager.instance().log((Object)this, Level.INFO, "- Total vertices.: %d", null, (Object)context.createdVertices.get());
                csvParser.stopParsing();
                throw throwable;
            }
        }
        long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
        LogManager.instance().log((Object)this, Level.INFO, "Importing of vertices from CSV source completed in %d seconds (%d/sec)", null, (Object)elapsedInSecs, (Object)(elapsedInSecs > 0L ? context.createdVertices.get() / elapsedInSecs : context.createdVertices.get()));
        LogManager.instance().log((Object)this, Level.INFO, "- Parsed lines...: %d", null, (Object)context.parsed.get());
        LogManager.instance().log((Object)this, Level.INFO, "- Total vertices.: %d", null, (Object)context.createdVertices.get());
        csvParser.stopParsing();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadEdges(SourceSchema sourceSchema, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws ImportException {
        long skipEntries;
        long expectedVertices;
        AbstractParser csvParser = this.createCSVParser(settings);
        long beginTime = System.currentTimeMillis();
        AnalyzedEntity entity = sourceSchema.getSchema().getEntity(settings.edgeTypeName);
        if (entity == null) {
            LogManager.instance().log((Object)this, Level.INFO, "Edge type '%s' not defined", null, (Object)settings.edgeTypeName);
            return;
        }
        AnalyzedProperty from = entity.getProperty(settings.edgeFromField);
        if (from == null) {
            throw new IllegalArgumentException("Specify -edgeFromField <from-field-name>");
        }
        AnalyzedProperty to = entity.getProperty(settings.edgeToField);
        if (to == null) {
            throw new IllegalArgumentException("Specify -edgeToField <from-field-name>");
        }
        long expectedEdges = settings.expectedEdges;
        if (expectedEdges <= 0L) {
            expectedEdges = (int)(sourceSchema.getSource().totalSize / (long)entity.getAverageRowLength());
        }
        if (expectedEdges <= 0L || expectedEdges > 0x2000000L) {
            expectedEdges = 0x2000000L;
        }
        if ((expectedVertices = settings.expectedVertices) <= 0L) {
            expectedVertices = expectedEdges / 2L;
        }
        LogManager.instance().log((Object)this, Level.INFO, "Started importing edges from CSV source (expectedVertices=%d expectedEdges=%d)", null, (Object)expectedVertices, (Object)expectedEdges);
        try {
            if (context.graphImporter == null) {
                context.graphImporter = new GraphImporter(database, (int)expectedVertices, (int)expectedEdges, Type.valueOf((String)settings.typeIdType.toUpperCase(Locale.ENGLISH)));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ImportException("Error on creating internal component", e);
        }
        context.graphImporter.startImportingEdges();
        database.async().onError(exception -> LogManager.instance().log((Object)this, Level.SEVERE, "Error on inserting edges", exception));
        long l = skipEntries = settings.edgesSkipEntries != null ? settings.edgesSkipEntries : 0L;
        if (settings.edgesSkipEntries == null) {
            skipEntries = 1L;
        }
        try (InputStreamReader inputFileReader = new InputStreamReader(parser.getInputStream(), DatabaseFactory.getDefaultCharset());){
            String[] row;
            csvParser.beginParsing((Reader)inputFileReader);
            ArrayList<AnalyzedProperty> properties = new ArrayList<AnalyzedProperty>();
            if (!settings.edgePropertiesInclude.isEmpty() && !settings.edgePropertiesInclude.equalsIgnoreCase("*")) {
                String[] includes = settings.edgePropertiesInclude.split(",");
                HashSet<String> propertiesSet = new HashSet<String>(Arrays.asList(includes));
                for (AnalyzedProperty p : entity.getProperties()) {
                    if (!propertiesSet.contains(p.getName())) continue;
                    properties.add(p);
                }
            } else {
                properties.addAll(entity.getProperties());
            }
            LogManager.instance().log((Object)this, Level.INFO, "Importing the following edge properties: %s", null, properties);
            long line = 0L;
            while ((row = csvParser.parseNext()) != null) {
                context.parsed.incrementAndGet();
                if (skipEntries <= 0L || line >= skipEntries) {
                    try {
                        this.createEdgeFromRow(row, properties, from, to, context, settings);
                    }
                    catch (Exception e) {
                        LogManager.instance().log((Object)this, Level.SEVERE, "Error on parsing line %d", (Throwable)e, (Object)line);
                    }
                }
                ++line;
            }
            context.graphImporter.close(linked -> context.linkedEdges.addAndGet(linked));
        }
        catch (IOException e) {
            try {
                throw new ImportException("Error on importing CSV", e);
            }
            catch (Throwable throwable) {
                long elapsedInSecs2 = (System.currentTimeMillis() - beginTime) / 1000L;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                LogManager.instance().log((Object)this, Level.INFO, "Importing of edges from CSV source completed in %d seconds (%d/sec)", null, (Object)elapsedInSecs2, (Object)(elapsedInSecs2 > 0L ? context.createdEdges.get() / elapsedInSecs2 : context.createdEdges.get()));
                LogManager.instance().log((Object)this, Level.INFO, "- Parsed lines......: %d", null, (Object)context.parsed.get());
                LogManager.instance().log((Object)this, Level.INFO, "- Total edges.......: %d", null, (Object)context.createdEdges.get());
                LogManager.instance().log((Object)this, Level.INFO, "- Total linked Edges: %d", null, (Object)context.linkedEdges.get());
                LogManager.instance().log((Object)this, Level.INFO, "- Skipped edges.....: %d", null, (Object)context.skippedEdges.get());
                csvParser.stopParsing();
                throw throwable;
            }
        }
        long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        LogManager.instance().log((Object)this, Level.INFO, "Importing of edges from CSV source completed in %d seconds (%d/sec)", null, (Object)elapsedInSecs, (Object)(elapsedInSecs > 0L ? context.createdEdges.get() / elapsedInSecs : context.createdEdges.get()));
        LogManager.instance().log((Object)this, Level.INFO, "- Parsed lines......: %d", null, (Object)context.parsed.get());
        LogManager.instance().log((Object)this, Level.INFO, "- Total edges.......: %d", null, (Object)context.createdEdges.get());
        LogManager.instance().log((Object)this, Level.INFO, "- Total linked Edges: %d", null, (Object)context.linkedEdges.get());
        LogManager.instance().log((Object)this, Level.INFO, "- Skipped edges.....: %d", null, (Object)context.skippedEdges.get());
        csvParser.stopParsing();
    }

    public void createEdgeFromRow(String[] row, List<AnalyzedProperty> properties, AnalyzedProperty from, AnalyzedProperty to, ImporterContext context, ImporterSettings settings) {
        Object[] params;
        if (from.getIndex() >= row.length || to.getIndex() >= row.length) {
            context.skippedEdges.incrementAndGet();
            return;
        }
        String fromValue = row[from.getIndex()];
        String toValue = row[to.getIndex()];
        if (fromValue == null || toValue == null) {
            context.skippedEdges.incrementAndGet();
            return;
        }
        long sourceVertexKey = Long.parseLong(fromValue);
        long destinationVertexKey = Long.parseLong(toValue);
        if (row.length > 2) {
            params = new Object[properties.size() * 2];
            for (int i = 0; i < properties.size(); ++i) {
                AnalyzedProperty property = properties.get(i);
                params[i * 2] = property.getName();
                params[i * 2 + 1] = row[property.getIndex()];
            }
        } else {
            params = NO_PARAMS;
        }
        context.graphImporter.createEdge(sourceVertexKey, settings.edgeTypeName, destinationVertexKey, params, context, settings);
    }

    @Override
    public SourceSchema analyze(AnalyzedEntity.EntityType entityType, Parser parser, ImporterSettings settings, AnalyzedSchema analyzedSchema) throws IOException {
        String header;
        int maxPropertySize;
        TsvParserSettings parserSettings;
        parser.reset();
        String delimiter = settings.getValue("delimiter", ",");
        if ("\t".equals(delimiter) || "\\t".equals(delimiter)) {
            TsvParserSettings tsvParserSettings;
            parserSettings = tsvParserSettings = new TsvParserSettings();
        } else {
            CsvParserSettings csvParserSettings = new CsvParserSettings();
            parserSettings = csvParserSettings;
            csvParserSettings.setDelimiterDetectionEnabled(false);
            if (delimiter != null) {
                csvParserSettings.detectFormatAutomatically(new char[]{delimiter.charAt(0)});
                ((CsvFormat)csvParserSettings.getFormat()).setDelimiter(delimiter.charAt(0));
            }
        }
        parserSettings.setReadInputOnSeparateThread(false);
        int maxProperties = settings.getIntValue("maxProperties", 0);
        if (maxProperties > 0) {
            parserSettings.setMaxColumns(maxProperties);
        }
        if ((maxPropertySize = settings.getIntValue("maxPropertySize", 0)) != 0) {
            parserSettings.setAutoConfigurationEnabled(false);
            parserSettings.setMaxCharsPerColumn(maxPropertySize);
        }
        Object csvParser = "\t".equals(delimiter) || "\\t".equals(delimiter) ? new TsvParser(parserSettings) : new CsvParser((CsvParserSettings)parserSettings);
        ArrayList<String> fieldNames = new ArrayList<String>();
        String entityName = entityType == AnalyzedEntity.EntityType.VERTEX ? settings.vertexTypeName : (entityType == AnalyzedEntity.EntityType.EDGE ? settings.edgeTypeName : settings.documentTypeName);
        long skipEntries = 0L;
        switch (entityType) {
            case VERTEX: {
                header = settings.verticesHeader;
                long l = skipEntries = settings.verticesSkipEntries != null ? settings.verticesSkipEntries : 0L;
                if (settings.verticesSkipEntries != null) break;
                skipEntries = 1L;
                break;
            }
            case EDGE: {
                header = settings.edgesHeader;
                long l = skipEntries = settings.edgesSkipEntries != null ? settings.edgesSkipEntries : 0L;
                if (settings.edgesSkipEntries != null) break;
                skipEntries = 1L;
                break;
            }
            case DOCUMENT: {
                header = settings.documentsHeader;
                long l = skipEntries = settings.documentsSkipEntries != null ? settings.documentsSkipEntries : 0L;
                if (settings.documentsSkipEntries != null) break;
                skipEntries = 1L;
                break;
            }
            default: {
                header = null;
            }
        }
        if (header != null) {
            if (delimiter == null) {
                fieldNames.add(header);
            } else {
                String[] headerColumns = header.split(",");
                fieldNames.addAll(Arrays.asList(headerColumns));
            }
            LogManager.instance().log((Object)this, Level.INFO, "Parsing with custom header: %s", null, fieldNames);
        }
        try (InputStreamReader inputFileReader2 = new InputStreamReader(parser.getInputStream(), DatabaseFactory.getDefaultCharset());){
            Object[] row;
            csvParser.beginParsing((Reader)inputFileReader2);
            long line = 0L;
            while ((row = csvParser.parseNext()) != null) {
                if (skipEntries <= 0L || line >= skipEntries || fieldNames.isEmpty()) {
                    if (settings.analysisLimitBytes > 0L && csvParser.getContext().currentChar() > settings.analysisLimitBytes) {
                        break;
                    }
                    if (settings.analysisLimitEntries > 0L && line > settings.analysisLimitEntries) {
                        break;
                    }
                    if (line == 0L && header == null) {
                        fieldNames.addAll(Arrays.asList(row));
                        LogManager.instance().log((Object)this, Level.INFO, "Reading header from 1st line in data file: %s", null, (Object)Arrays.toString(row));
                    } else {
                        AnalyzedEntity entity = analyzedSchema.getOrCreateEntity(entityName, entityType);
                        entity.setRowSize((String[])row);
                        for (int i = 0; i < row.length; ++i) {
                            entity.getOrCreateProperty((String)fieldNames.get(i), (String)row[i]);
                        }
                    }
                }
                ++line;
            }
        }
        catch (EOFException inputFileReader2) {
        }
        catch (IOException e) {
            throw new ImportException("Error on importing CSV", e);
        }
        analyzedSchema.endParsing();
        return new SourceSchema(this, parser.getSource(), analyzedSchema);
    }

    @Override
    public String getFormat() {
        return "CSV";
    }

    protected AbstractParser createCSVParser(ImporterSettings settings) {
        String delimiter = ",";
        if (settings.options.containsKey("delimiter")) {
            delimiter = settings.getValue("delimiter", ",");
        }
        if ("\t".equals(delimiter) || "\\t".equals(delimiter)) {
            TsvParserSettings tsvParserSettings = new TsvParserSettings();
            tsvParserSettings.setMaxColumns(settings.getIntValue("maxProperties", tsvParserSettings.getMaxColumns()));
            tsvParserSettings.setMaxCharsPerColumn(settings.getIntValue("maxPropertySize", tsvParserSettings.getMaxCharsPerColumn()));
            return new TsvParser(tsvParserSettings);
        }
        CsvParserSettings csvParserSettings = new CsvParserSettings();
        ((CsvFormat)csvParserSettings.getFormat()).setDelimiter(delimiter);
        csvParserSettings.setMaxColumns(settings.getIntValue("maxProperties", csvParserSettings.getMaxColumns()));
        csvParserSettings.setMaxCharsPerColumn(settings.getIntValue("maxPropertySize", csvParserSettings.getMaxCharsPerColumn()));
        return new CsvParser(csvParserSettings);
    }
}

