/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.AbstractImporter;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceDiscovery;
import com.arcadedb.integration.importer.SourceSchema;
import java.io.IOException;
import java.util.Map;

public class Importer
extends AbstractImporter {
    public Importer(String[] args) {
        super(args);
    }

    public Importer(Database database, String url) {
        super((DatabaseInternal)database);
        this.settings.url = url;
    }

    public static void main(String[] args) {
        new Importer(args).load();
        System.exit(0);
    }

    public Map<String, Object> load() {
        this.source = null;
        try {
            int cfgValue = this.settings.getIntValue("maxValueSampling", 100);
            AnalyzedSchema analyzedSchema = new AnalyzedSchema(cfgValue);
            this.openDatabase();
            this.startImporting();
            this.loadFromSource(this.settings.url, AnalyzedEntity.EntityType.DATABASE, analyzedSchema);
            this.loadFromSource(this.settings.documents, AnalyzedEntity.EntityType.DOCUMENT, analyzedSchema);
            this.loadFromSource(this.settings.vertices, AnalyzedEntity.EntityType.VERTEX, analyzedSchema);
            this.loadFromSource(this.settings.edges, AnalyzedEntity.EntityType.EDGE, analyzedSchema);
            if (this.settings.probeOnly) {
                Map<String, Object> map = null;
                return map;
            }
            if (this.database.isTransactionActive()) {
                this.database.commit();
            }
        }
        catch (Exception e) {
            if (this.settings.probeOnly) {
                throw new IllegalArgumentException(e);
            }
            throw new ImportException("Error on parsing source '" + String.valueOf(this.source) + "'", e);
        }
        finally {
            this.stopImporting();
            if (this.database != null) {
                this.closeDatabase();
            }
            this.closeInputFile();
        }
        return this.context.toMap();
    }

    protected void loadFromSource(String url, AnalyzedEntity.EntityType entityType, AnalyzedSchema analyzedSchema) throws IOException {
        if (url == null) {
            return;
        }
        SourceDiscovery sourceDiscovery = new SourceDiscovery(url);
        if (this.settings.probeOnly) {
            sourceDiscovery.getSource();
            return;
        }
        SourceSchema sourceSchema = sourceDiscovery.getSchema(this.settings, entityType, analyzedSchema, this.logger);
        if (sourceSchema == null) {
            return;
        }
        this.updateDatabaseSchema(sourceSchema.getSchema());
        this.source = sourceDiscovery.getSource();
        this.parser = new Parser(this.source, 0L);
        this.parser.reset();
        this.format = sourceSchema.getContentImporter();
        this.format.load(sourceSchema, entityType, this.parser, this.database, this.context, this.settings);
    }

    @Override
    protected void closeDatabase() {
        if (!this.databaseCreatedDuringImporting) {
            return;
        }
        if (this.database != null) {
            if (this.database.isTransactionActive()) {
                this.database.commit();
            }
            this.database.close();
        }
    }
}

