/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedProperty;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnalyzedSchema {
    private final Map<String, AnalyzedEntity> entities = new LinkedHashMap<String, AnalyzedEntity>();
    private final long maxValueSampling;

    public AnalyzedSchema(long maxValueSampling) {
        this.maxValueSampling = maxValueSampling;
    }

    public AnalyzedEntity getOrCreateEntity(String entityName, AnalyzedEntity.EntityType entityType) {
        return this.entities.computeIfAbsent(entityName, n -> new AnalyzedEntity((String)n, entityType, this.maxValueSampling));
    }

    public void endParsing() {
        for (AnalyzedEntity entity : this.entities.values()) {
            for (AnalyzedProperty property : entity.getProperties()) {
                property.endParsing();
            }
        }
    }

    public Collection<AnalyzedEntity> getEntities() {
        return this.entities.values();
    }

    public AnalyzedEntity getEntity(String name) {
        return this.entities.get(name);
    }
}

