/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.integration.importer.Source;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicLong;

public class Parser {
    private final Source source;
    private InputStream is;
    private InputStreamReader reader;
    private final long limit;
    private final AtomicLong position = new AtomicLong();
    private final long total;
    private char currentChar;
    private final boolean compressed;

    public Parser(Source source, long limit) throws IOException {
        this.source = source;
        this.limit = limit;
        this.resetInput();
        this.compressed = source.compressed;
        this.total = source.totalSize;
    }

    public char getCurrentChar() {
        return this.currentChar;
    }

    public char nextChar() throws IOException {
        this.position.incrementAndGet();
        this.currentChar = (char)this.reader.read();
        return this.currentChar;
    }

    public void mark() {
        this.is.mark(0);
    }

    public void reset() throws IOException {
        this.currentChar = '\u0000';
        this.position.set(0L);
        this.source.reset();
        this.resetInput();
    }

    public boolean isAvailable() throws IOException {
        if (this.limit > 0L) {
            return this.position.get() < this.limit && this.is.available() > 0;
        }
        if (this.reader.ready()) {
            return true;
        }
        return this.is.available() > 0;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public InputStreamReader getReader() {
        return this.reader;
    }

    public long getPosition() {
        return this.position.get();
    }

    public long getTotal() {
        return this.limit > 0L ? Math.min(this.limit, this.total) : this.total;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public Source getSource() {
        return this.source;
    }

    private void resetInput() {
        this.is = new BufferedInputStream(this.source.inputStream){

            @Override
            public synchronized int read() throws IOException {
                Parser.this.position.incrementAndGet();
                return super.read();
            }

            @Override
            public synchronized int read(byte[] b) throws IOException {
                if (Parser.this.limit > 0L && Parser.this.position.get() > Parser.this.limit) {
                    throw new EOFException();
                }
                int res = super.read(b);
                Parser.this.position.addAndGet(res);
                return res;
            }

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                if (Parser.this.limit > 0L && Parser.this.position.get() > Parser.this.limit) {
                    throw new EOFException();
                }
                int res = super.read(b, off, len);
                Parser.this.position.addAndGet(res);
                return res;
            }

            @Override
            public synchronized int available() throws IOException {
                if (Parser.this.limit > 0L && Parser.this.position.get() > Parser.this.limit) {
                    return 0;
                }
                return super.available();
            }

            @Override
            public synchronized void reset() {
                this.pos = 0;
                Parser.this.position.set(0L);
            }
        };
        this.reader = new InputStreamReader(this.is, DatabaseFactory.getDefaultCharset());
        this.is.mark(0);
    }
}

