/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.graph;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RID;
import com.arcadedb.database.async.DatabaseAsyncExecutorImpl;
import com.arcadedb.database.async.DatabaseAsyncTask;
import com.arcadedb.graph.GraphEngine;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.VertexInternal;
import com.arcadedb.index.CompressedAny2RIDIndex;
import com.arcadedb.index.CompressedRID2RIDsIndex;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.graph.CreateEdgeFromImportTask;
import com.arcadedb.integration.importer.graph.EdgeLinkedCallback;
import com.arcadedb.integration.importer.graph.LinkEdgeFromImportTask;
import com.arcadedb.log.LogManager;
import com.arcadedb.schema.Type;
import com.arcadedb.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class GraphImporter {
    private final CompressedAny2RIDIndex verticesIndex;
    private final DatabaseInternal database;
    private final GraphImporterThreadContext[] threadContexts;
    private STATUS status = STATUS.IMPORTING_VERTEX;

    public GraphImporter(DatabaseInternal database, int expectedVertices, int expectedEdges, Type idType) throws ClassNotFoundException {
        this.database = database;
        int parallel = database.async().getParallelLevel();
        this.verticesIndex = new CompressedAny2RIDIndex((Database)database, idType, expectedVertices);
        int expectedEdgesPerThread = expectedEdges / parallel;
        this.threadContexts = new GraphImporterThreadContext[parallel];
        for (int i = 0; i < parallel; ++i) {
            this.threadContexts[i] = new GraphImporterThreadContext(expectedVertices, expectedEdgesPerThread);
        }
    }

    public void close() {
        this.close(null);
    }

    public void close(EdgeLinkedCallback callback) {
        int i;
        this.database.commit();
        this.database.async().waitCompletion();
        for (i = 0; i < this.threadContexts.length; ++i) {
            this.threadContexts[i].incomingConnectionsIndexThread.setReadOnly();
        }
        this.createIncomingEdges(this.database, callback);
        this.database.async().waitCompletion();
        for (i = 0; i < this.threadContexts.length; ++i) {
            this.threadContexts[i] = null;
        }
        this.status = STATUS.CLOSED;
    }

    public RID getVertex(Binary vertexIndexThreadBuffer, long vertexId) {
        return this.verticesIndex.get(vertexIndexThreadBuffer, (Object)vertexId);
    }

    public RID getVertex(long vertexId) {
        return this.verticesIndex.get((Object)vertexId);
    }

    public void createVertex(String vertexTypeName, String vertexId, Object[] vertexProperties) {
        Object transformedVertexId = this.verticesIndex.getKeyBinaryType().newInstance((Object)vertexId);
        RID sourceVertexRID = this.verticesIndex.get(transformedVertexId);
        if (sourceVertexRID == null) {
            MutableVertex sourceVertex = this.database.newVertex(vertexTypeName);
            sourceVertex.set(vertexProperties);
            this.database.async().createRecord((MutableDocument)sourceVertex, newDocument -> {
                DatabaseInternal db = this.database;
                db.getGraphEngine().createOutEdgeChunk(sourceVertex);
                db.getGraphEngine().createInEdgeChunk(sourceVertex);
                this.verticesIndex.put(transformedVertexId, newDocument.getIdentity());
            });
        }
    }

    public void createEdge(long sourceVertexKey, String edgeTypeName, long destinationVertexKey, Object[] edgeProperties, ImporterContext context, ImporterSettings settings) {
        DatabaseAsyncExecutorImpl async = (DatabaseAsyncExecutorImpl)this.database.async();
        int slot = async.getSlot((int)sourceVertexKey);
        async.scheduleTask(slot, (DatabaseAsyncTask)new CreateEdgeFromImportTask(this.threadContexts[slot], edgeTypeName, sourceVertexKey, destinationVertexKey, edgeProperties, context, settings), true, 70);
    }

    public void startImportingEdges() {
        if (this.status != STATUS.IMPORTING_VERTEX) {
            throw new IllegalStateException("Cannot import edges on current status " + this.status);
        }
        this.status = STATUS.IMPORTING_EDGE;
        for (int i = 0; i < this.threadContexts.length; ++i) {
            this.threadContexts[i].vertexIndexThreadBuffer = this.verticesIndex.getInternalBuffer().slice();
        }
    }

    public CompressedAny2RIDIndex<Object> getVerticesIndex() {
        return this.verticesIndex;
    }

    protected void createIncomingEdges(DatabaseInternal database, EdgeLinkedCallback callback) {
        ArrayList<Object> connections = new ArrayList<Pair<Identifiable, Identifiable>>();
        long browsedVertices = 0L;
        long browsedEdges = 0L;
        long verticesWithNoEdges = 0L;
        long verticesWithEdges = 0L;
        LogManager.instance().log((Object)this, Level.INFO, "Linking back edges for %d vertices...", null, (Object)this.verticesIndex.size());
        CompressedAny2RIDIndex.EntryIterator it = this.verticesIndex.vertexIterator();
        while (it.hasNext()) {
            RID destinationVertex = it.next();
            ++browsedVertices;
            for (int t = 0; t < this.threadContexts.length; ++t) {
                List edges = this.threadContexts[t].incomingConnectionsIndexThread.get(destinationVertex);
                if (edges == null) continue;
                for (int e = 0; e < edges.size(); ++e) {
                    Pair edge = (Pair)edges.get(e);
                    connections.add((Pair<Identifiable, Identifiable>)new Pair((Object)((Identifiable)edge.getFirst()), (Object)((Identifiable)edge.getSecond())));
                    ++browsedEdges;
                }
            }
            if (!connections.isEmpty()) {
                DatabaseAsyncExecutorImpl async = (DatabaseAsyncExecutorImpl)database.async();
                int slot = async.getSlot(destinationVertex.getBucketId());
                async.scheduleTask(slot, (DatabaseAsyncTask)new LinkEdgeFromImportTask((Identifiable)destinationVertex, connections, callback), true, 70);
                connections = new ArrayList();
                ++verticesWithEdges;
                continue;
            }
            ++verticesWithNoEdges;
        }
        LogManager.instance().log((Object)this, Level.INFO, "Linking back edges completed: browsedVertices=%d browsedEdges=%d verticesWithEdges=%d verticesWithNoEdges=%d", null, (Object)browsedVertices, (Object)browsedEdges, (Object)verticesWithEdges, (Object)verticesWithNoEdges);
    }

    static enum STATUS {
        IMPORTING_VERTEX,
        IMPORTING_EDGE,
        CLOSED;

    }

    public class GraphImporterThreadContext {
        Binary vertexIndexThreadBuffer;
        CompressedRID2RIDsIndex incomingConnectionsIndexThread;
        Long lastSourceKey = null;
        VertexInternal lastSourceVertex = null;
        List<GraphEngine.CreateEdgeOperation> connections = new ArrayList<GraphEngine.CreateEdgeOperation>();
        int importedEdges = 0;

        public GraphImporterThreadContext(int expectedVertices, int expectedEdges) throws ClassNotFoundException {
            this.incomingConnectionsIndexThread = new CompressedRID2RIDsIndex((Database)GraphImporter.this.database, expectedVertices, expectedEdges);
        }
    }
}

