/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.utility.FileUtils;
import java.util.HashMap;
import java.util.Map;

public class ImporterSettings {
    public String database = "./databases/imported";
    public String url = null;
    public boolean wal = false;
    public int verboseLevel = 2;
    public boolean probeOnly = false;
    public String documents;
    public String documentsFileType;
    public String documentsDelimiter;
    public String documentsHeader;
    public Long documentsSkipEntries = null;
    public String documentTypeName = "Document";
    public String documentPropertiesInclude = "*";
    public String vertices;
    public String verticesFileType;
    public String verticesDelimiter;
    public String verticesHeader;
    public Long verticesSkipEntries = null;
    public String vertexTypeName = "Node";
    public String vertexPropertiesInclude = "*";
    public long expectedVertices = 0L;
    public String edges;
    public String edgesFileType;
    public String edgesDelimiter;
    public String edgesHeader;
    public Long edgesSkipEntries = null;
    public String edgeTypeName = "Relationship";
    public String edgePropertiesInclude = "*";
    public long expectedEdges = 0L;
    public long maxRAMIncomingEdges = 0x10000000L;
    public String edgeFromField = null;
    public String edgeToField = null;
    public boolean edgeBidirectional = true;
    public String typeIdProperty = null;
    public boolean typeIdPropertyIsUnique = false;
    public String typeIdType = "String";
    public int parallel = 1;
    public boolean forceDatabaseCreate = false;
    public boolean trimText = true;
    public long analysisLimitBytes = 100000L;
    public long analysisLimitEntries = 10000L;
    public long parsingLimitBytes;
    public long parsingLimitEntries;
    public int commitEvery = 5000;
    public String mapping = null;
    public final Map<String, Object> options = new HashMap<String, Object>();

    public ImporterSettings() {
        this.parallel = Runtime.getRuntime().availableProcessors() / 2 - 1;
        if (this.parallel < 1) {
            this.parallel = 1;
        }
    }

    public <T> T getValue(String name, T defaultValue) {
        Object v = this.options.get(name);
        return (T)(v != null ? v : defaultValue);
    }

    public int getIntValue(String name, int defaultValue) {
        Object v = this.options.get(name);
        if (v != null) {
            if (v instanceof Number) {
                Number number = (Number)v;
                return number.intValue();
            }
            return Integer.parseInt(v.toString());
        }
        return defaultValue;
    }

    protected void parseParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length - 1; i += 2) {
                char begin = args[i].charAt(0);
                if (begin != '-') {
                    throw new IllegalArgumentException("Arguments must begin with '-'");
                }
                this.parseParameter(args[i].substring(1), args[i + 1]);
            }
        }
    }

    public void parseParameter(String name, String value) {
        value = FileUtils.getStringContent((Object)value);
        switch (name) {
            case "database": {
                this.database = value;
                break;
            }
            case "url": {
                this.url = value;
                break;
            }
            case "forceDatabaseCreate": {
                this.forceDatabaseCreate = Boolean.parseBoolean(value);
                break;
            }
            case "wal": {
                this.wal = Boolean.parseBoolean(value);
                break;
            }
            case "commitEvery": {
                this.commitEvery = Integer.parseInt(value);
                break;
            }
            case "parallel": {
                this.parallel = Integer.parseInt(value);
                break;
            }
            case "typeIdProperty": {
                this.typeIdProperty = value;
                break;
            }
            case "typeIdUnique": {
                this.typeIdPropertyIsUnique = Boolean.parseBoolean(value);
                break;
            }
            case "typeIdType": {
                this.typeIdType = value;
                break;
            }
            case "trimText": {
                this.trimText = Boolean.parseBoolean(value);
                break;
            }
            case "analysisLimitBytes": {
                this.analysisLimitBytes = FileUtils.getSizeAsNumber((Object)value);
                break;
            }
            case "analysisLimitEntries": {
                this.analysisLimitEntries = Long.parseLong(value);
                break;
            }
            case "parsingLimitBytes": {
                this.parsingLimitBytes = FileUtils.getSizeAsNumber((Object)value);
                break;
            }
            case "parsingLimitEntries": {
                this.parsingLimitEntries = Long.parseLong(value);
                break;
            }
            case "mapping": {
                this.mapping = value;
                break;
            }
            case "probeOnly": {
                this.probeOnly = Boolean.parseBoolean(value);
                break;
            }
            case "documents": {
                this.documents = value;
                break;
            }
            case "documentsFileType": {
                this.documentsFileType = value;
                break;
            }
            case "documentsDelimiter": {
                this.documentsDelimiter = value;
                break;
            }
            case "documentsHeader": {
                this.documentsHeader = value;
                break;
            }
            case "documentsSkipEntries": {
                this.documentsSkipEntries = Long.parseLong(value);
                break;
            }
            case "documentPropertiesInclude": {
                this.documentPropertiesInclude = value;
                break;
            }
            case "documentType": {
                this.documentTypeName = value;
                break;
            }
            case "vertices": {
                this.vertices = value;
                break;
            }
            case "verticesFileType": {
                this.verticesFileType = value;
                break;
            }
            case "verticesDelimiter": {
                this.verticesDelimiter = value;
                break;
            }
            case "verticesHeader": {
                this.verticesHeader = value;
                break;
            }
            case "verticesSkipEntries": {
                this.verticesSkipEntries = Long.parseLong(value);
                break;
            }
            case "expectedVertices": {
                this.expectedVertices = Integer.parseInt(value);
                break;
            }
            case "vertexType": {
                this.vertexTypeName = value;
                break;
            }
            case "vertexPropertiesInclude": {
                this.vertexPropertiesInclude = value;
                break;
            }
            case "edges": {
                this.edges = value;
                break;
            }
            case "edgesFileType": {
                this.edgesFileType = value;
                break;
            }
            case "edgesDelimiter": {
                this.edgesDelimiter = value;
                break;
            }
            case "edgesHeader": {
                this.edgesHeader = value;
                break;
            }
            case "edgesSkipEntries": {
                this.edgesSkipEntries = Long.parseLong(value);
                break;
            }
            case "expectedEdges": {
                this.expectedEdges = Integer.parseInt(value);
                break;
            }
            case "maxRAMIncomingEdges": {
                this.maxRAMIncomingEdges = Long.parseLong(value);
                break;
            }
            case "edgeType": {
                this.edgeTypeName = value;
                break;
            }
            case "edgePropertiesInclude": {
                this.edgePropertiesInclude = value;
                break;
            }
            case "edgeFromField": {
                this.edgeFromField = value;
                break;
            }
            case "edgeToField": {
                this.edgeToField = value;
                break;
            }
            case "edgeBidirectional": {
                this.edgeBidirectional = Boolean.parseBoolean(value);
            }
        }
        this.options.put(name, value);
    }
}

