/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.backup;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.backup.BackupException;
import com.arcadedb.integration.backup.BackupSettings;
import com.arcadedb.integration.backup.format.AbstractBackupFormat;
import com.arcadedb.integration.backup.format.FullBackupFormat;
import com.arcadedb.integration.importer.ConsoleLogger;
import java.util.Locale;
import java.util.Timer;

public class Backup {
    protected BackupSettings settings = new BackupSettings();
    protected DatabaseInternal database;
    protected Timer timer;
    protected ConsoleLogger logger;
    protected AbstractBackupFormat formatImplementation;
    protected boolean closeDatabaseAtEnd = false;

    public Backup(String[] args) {
        this.settings.parseParameters(args);
    }

    public Backup(Database database) {
        this.database = (DatabaseInternal)database;
    }

    public Backup(Database database, String file) {
        this.database = (DatabaseInternal)database;
        this.settings.file = file;
    }

    public static void main(String[] args) {
        new Backup(args).backupDatabase();
        System.exit(0);
    }

    public String backupDatabase() {
        try {
            if (this.logger == null) {
                this.logger = new ConsoleLogger(this.settings.verboseLevel);
            }
            this.openDatabase();
            this.settings.databaseName = this.database.getName();
            this.settings.validateSettings();
            if (this.logger.getVerboseLevel() != this.settings.verboseLevel) {
                this.logger = new ConsoleLogger(this.settings.verboseLevel);
            }
            this.formatImplementation = this.createFormatImplementation();
            this.formatImplementation.backupDatabase();
            String string = this.settings.file;
            return string;
        }
        catch (Exception e) {
            throw new BackupException("Error during backup of database '" + (this.database != null ? this.database.getName() : this.settings.databaseURL) + "' to file '" + this.settings.file + "'", e);
        }
        finally {
            this.closeDatabase();
        }
    }

    public Backup setDirectory(String directory) {
        this.settings.directory = directory;
        return this;
    }

    public Backup setVerboseLevel(int verboseLevel) {
        this.settings.verboseLevel = verboseLevel;
        return this;
    }

    protected void openDatabase() {
        if (this.database != null && this.database.isOpen()) {
            return;
        }
        DatabaseFactory factory = new DatabaseFactory(this.settings.databaseURL);
        if (!factory.exists()) {
            throw new BackupException("Database '%s' not found".formatted(this.settings.databaseURL));
        }
        this.logger.logLine(0, "Opening database '%s'...", this.settings.databaseURL);
        this.database = (DatabaseInternal)factory.open();
        this.closeDatabaseAtEnd = true;
    }

    protected void closeDatabase() {
        if (this.database != null && this.closeDatabaseAtEnd) {
            if (this.database.isTransactionActive()) {
                this.database.commit();
            }
            this.database.close();
        }
    }

    protected AbstractBackupFormat createFormatImplementation() {
        switch (this.settings.format.toLowerCase(Locale.ENGLISH)) {
            case "full": {
                return new FullBackupFormat(this.database, this.settings, this.logger);
            }
        }
        throw new BackupException("Format '" + this.settings.format + "' not supported");
    }
}

