/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium.capture;

import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.appium.capture.MobileImageProvider;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.openqa.selenium.OutputType;

public class AndroidViewportScreenshotImageProvider
extends MobileImageProvider {
    public AndroidViewportScreenshotImageProvider(EyesWebDriver driver) {
        super((EyesAppiumDriver)driver);
    }

    public BufferedImage getImage() {
        BufferedImage screenshot = ImageUtils.imageFromBytes((byte[])((byte[])this.driver.getScreenshotAs(OutputType.BYTES)));
        Map<String, Integer> systemBarHeights = EyesAppiumUtils.getSystemBarsHeights(this.driver);
        if (!this.captureStatusBar) {
            screenshot = this.cropTop(screenshot, systemBarHeights.get("statusBar"));
        }
        screenshot = this.cropBottom(screenshot, systemBarHeights.get("navigationBar"));
        BufferedImage result = new BufferedImage(screenshot.getWidth(), screenshot.getHeight(), 6);
        result.setData(screenshot.getData());
        return result;
    }

    private BufferedImage cropTop(BufferedImage screenshot, Integer cropHeight) {
        if (cropHeight == null || cropHeight <= 0 || cropHeight >= screenshot.getHeight()) {
            return screenshot;
        }
        return screenshot.getSubimage(0, cropHeight, screenshot.getWidth(), screenshot.getHeight() - cropHeight);
    }

    private BufferedImage cropBottom(BufferedImage screenshot, Integer cropHeight) {
        if (cropHeight == null || cropHeight <= 0 || cropHeight >= screenshot.getHeight()) {
            return screenshot;
        }
        return screenshot.getSubimage(0, 0, screenshot.getWidth(), screenshot.getHeight() - cropHeight);
    }
}

